#include <stdlib.h>
#include <lynx.h>
#include <lynxlib.h>
#include <joy.h>

// Bug in cc65? Needs real code before C++ comments occur?

//#include "cosinus.h"
#include "sinus.h"
#include "sprites.h"
#include "ingame.pal"
#include "intro.pal"
#include "backgrnd.c"
#include "cartread.c"

/*
*******************************************************************************
 *  VBL synchronization
 *******************************************************************************
 */

#define VSYNC { ++VBLflag; while(VBLflag) {} }

extern uchar VBLflag;
uchar HBLline;

#asm
_VBLflag = $a0
#endasm

VBL() interrupt 
{ 
#asm
	stz _VBLflag
	stz _HBLline
#endasm
}

HBL() interrupt
{
#asm
	inc _HBLline
	pha
	lda _HBLline
	and #$F0
	sta $FDB0
	pla
#endasm
}

/*
*******************************************************************************
 *  Joypad functions
 *******************************************************************************
 */

register uchar joy;

uchar WaitButton() {
	uchar key;
	while (!(key = joystick)) {}
	while (joystick) {}
	return key;
	}


/*
*******************************************************************************
 *  global variables
 *******************************************************************************
 */

struct fileCache cache_beepbeep;
struct fileCache cache_coyote;

struct spriteInfo sprite_beepbeep;
struct spriteInfo sprite_coyote;

uchar pursuit_mode = 0;

uchar beepbeep_lagtime = 0;
uchar beepbeep_standtime = 0;

uchar coyote_lagtime = 1;
uchar coyote_has_dynamite = 0;

struct elementInfo elements[ELEMENT_NB];

/*
*******************************************************************************
 *  elements
 *******************************************************************************
 */

uchar elements_i;
uchar elements_j;

void elements_ini(elements_k) uchar elements_k; {
	elements[elements_k].ele_b0 = 0xc5;
	elements[elements_k].ele_b1 = 0x18;
	elements[elements_k].ele_b2 = 0x20;
	elements[elements_k].ele_next = 0;
	elements[elements_k].ele_x = -200;
	elements[elements_k].ele_y = 0;
	elements[elements_k].ele_sizex = 0x100;
	elements[elements_k].ele_sizey = 0x100;
	elements[elements_k].ele_type = 0;
	elements[elements_k].ele_anim = 0;
	}

void elements_new() {
	uchar elements_n;
	uchar elements_m;
	
	for (elements_m = 0, elements_n = 250; elements_m < ELEMENT_NB; ++elements_m) {
		if (elements[elements_m].ele_type == 0) { elements_n = elements_m; break; }
		}
	
	if (elements_n != 250) {
		
		elements[elements_n].ele_next = 0;
		elements[elements_n].ele_x = random() % 160;
		elements[elements_n].ele_y = (random() % 60) + 40;
		elements[elements_n].ele_type = (random() % 12) + 1;
		elements[elements_n].ele_anim = 0;

		if ((random() % 2) && elements[elements_n].ele_type != ELEMENT_VAN1) { elements[elements_n].ele_b0 |= 0x20; } 
								                                                    else { elements[elements_n].ele_b0 &= 0xdf; }

		switch (elements[elements_n].ele_type) {
			case ELEMENT_SEED:			elements[elements_n].ele_bitmap = seed;			break;
			case ELEMENT_LEMONADE:	elements[elements_n].ele_bitmap = lemonade; break;
			case ELEMENT_MINE:			elements[elements_n].ele_bitmap = mine;			break;
			case ELEMENT_VAN1:			elements[elements_n].ele_bitmap = van01;		break;
			case ELEMENT_VAN2:			elements[elements_n].ele_bitmap = van11;		break;
			case ELEMENT_VAN3:			elements[elements_n].ele_bitmap = van21;		break;
			case ELEMENT_VAN4:			elements[elements_n].ele_bitmap = van31;		break;
			case ELEMENT_ROCKET:		elements[elements_n].ele_bitmap = rocket1;	break;
			case ELEMENT_ROCK1:			elements[elements_n].ele_bitmap = rock1;		break;
			case ELEMENT_ROCK2:			elements[elements_n].ele_bitmap = rock2;		break;
			case ELEMENT_ROCK3:			elements[elements_n].ele_bitmap = rock3;		break;
			case ELEMENT_GUNBALL:		elements[elements_n].ele_bitmap = gunball1; break;
			case ELEMENT_DYNAMITE:	elements[elements_n].ele_bitmap = dynamite; break;
  		}

		switch (elements[elements_n].ele_type) {
			case ELEMENT_SEED:
			case ELEMENT_LEMONADE:
			case ELEMENT_MINE:
			case ELEMENT_DYNAMITE:
				while(GetColor(elements[elements_n].ele_x, elements[elements_n].ele_y) != 5) {
					elements[elements_n].ele_x = (random() % 140) + 10;
					elements[elements_n].ele_y = (random() % 82) + 10;
					++elements[elements_n].ele_anim;
					if (elements[elements_n].ele_anim > 10) { elements_die(elements_n); break; }
					}
				break;
			case ELEMENT_VAN1:
			case ELEMENT_VAN2:
			case ELEMENT_VAN3:
			case ELEMENT_VAN4:
			case ELEMENT_GUNBALL:
				if (elements[elements_n].ele_b0 & 0x20) { elements[elements_n].ele_x += 170; } else { elements[elements_n].ele_x -= 170; }
				break;
			case ELEMENT_ROCKET:
				if (elements[elements_n].ele_b0 & 0x20) { elements[elements_n].ele_x -= 170; } else { elements[elements_n].ele_x += 170; }
				break;
			case ELEMENT_ROCK1:
			case ELEMENT_ROCK2:
			case ELEMENT_ROCK3:
				if (elements[elements_n].ele_b0 & 0x20) { elements[elements_n].ele_y += 112; } else { elements[elements_n].ele_y -= 112; }
				break;
  		}
		}
	}

void elements_die(elements_k) uchar elements_k; {
	elements[elements_k].ele_type = 0;
	elements[elements_k].ele_x = -200;
	elements[elements_k].ele_y = 0;
	elements[elements_k].ele_anim = 0;
	}

void elements_animate(elements_k) uchar elements_k; {

	if (elements[elements_k].ele_anim) { elements[elements_k].ele_anim = 0; } else { elements[elements_k].ele_anim = 1; }
	
	switch (elements[elements_k].ele_type) {
		case ELEMENT_VAN1:
			if (elements[elements_k].ele_anim) { elements[elements_k].ele_bitmap = van02; } else { elements[elements_k].ele_bitmap = van01; }
			goto codedeporc;
		case ELEMENT_VAN2:
			if (elements[elements_k].ele_anim) { elements[elements_k].ele_bitmap = van12; } else { elements[elements_k].ele_bitmap = van11; }
			goto codedeporc;
		case ELEMENT_VAN3:
			if (elements[elements_k].ele_anim) { elements[elements_k].ele_bitmap = van22; } else { elements[elements_k].ele_bitmap = van21; }
			goto codedeporc;
		case ELEMENT_VAN4:
			if (elements[elements_k].ele_anim) { elements[elements_k].ele_bitmap = van32; } else { elements[elements_k].ele_bitmap = van31; }
			codedeporc:
		  if (elements[elements_k].ele_b0 & 0x20) { --elements[elements_k].ele_x; }  else { ++elements[elements_k].ele_x; }
			break;
		case ELEMENT_ROCKET:
			if (elements[elements_k].ele_anim) { elements[elements_k].ele_bitmap = rocket2; } else { elements[elements_k].ele_bitmap = rocket1; }
		  if (elements[elements_k].ele_b0 & 0x20) { elements[elements_k].ele_x += 2; } else { elements[elements_k].ele_x -= 2; }
			break;
		case ELEMENT_GUNBALL:
			if (elements[elements_k].ele_anim) { elements[elements_k].ele_bitmap = gunball2; } else { elements[elements_k].ele_bitmap = gunball1; }
		  if (elements[elements_k].ele_b0 & 0x20) { elements[elements_k].ele_x -= 2; } else { elements[elements_k].ele_x += 2; }
			break;
		case ELEMENT_ROCK1:
		case ELEMENT_ROCK2:
		case ELEMENT_ROCK3:
		  if (elements[elements_k].ele_b0 & 0x20) { --elements[elements_k].ele_y; }  else { ++elements[elements_k].ele_y; }
			break;
		}
	}

void elements_set_state() {
	uchar die;
	
	for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) {
		die = 0;
		
		switch (elements[elements_j].ele_type) {
			case ELEMENT_ROCK1:
			case ELEMENT_ROCK2:
			case ELEMENT_ROCK3:
				if (elements[elements_j].ele_b0 & 0x20) { if (elements[elements_j].ele_y < -10) { die = 1; } }  
				                                   else { if (elements[elements_j].ele_y > 140) { die = 1; } }
				break;
			default:
				if (elements[elements_j].ele_x < -170 || elements[elements_j].ele_x > 330  || elements[elements_j].ele_y < -10 || elements[elements_j].ele_y > 140) { die = 1; }
				break;
			}
				
		if (die) {
			elements_die(elements_j);
			elements_new();
			}
		else {
			elements_animate(elements_j);
  		}
		}
	}


/*
 *******************************************************************************
 *  beepbeep
 *******************************************************************************
 */

uchar beepbeep_is_falling() {
	if (sprite_beepbeep.spr_state & STATE_FALLING) { return 1; }
	if (GetColor(sprite_beepbeep.spr_x, sprite_beepbeep.spr_y) != 5) { 
		
		if (sprite_coyote.spr_state & STATE_FALLING) { sprite_coyote.spr_next = &sprite_beepbeep; }
																						else { SCBNEXT(BACK04) = &sprite_beepbeep; }
		sprite_beepbeep.spr_next = MAP01;
			
		sprite_beepbeep.spr_b1 = 0x10;
		sprite_beepbeep.spr_anim = 100;
		sprite_beepbeep.spr_id = ID_BEEPBEEP_STAND;
		sprite_beepbeep.spr_state = STATE_FALLING;
		
		return 1;
		}
	return 0;
	}

void beepbeep_set_falling() {
	--sprite_beepbeep.spr_anim;
	if (sprite_beepbeep.spr_sizex > 2) { sprite_beepbeep.spr_sizex -= 2; }
	if (sprite_beepbeep.spr_sizex > 2) { sprite_beepbeep.spr_sizey -= 2; }
	
	if (!(sprite_beepbeep.spr_anim % 3)) {
		switch (sprite_beepbeep.spr_d) {
			case DIRECTION_LEFT:  --sprite_beepbeep.spr_x; break;
			case DIRECTION_RIGHT: ++sprite_beepbeep.spr_x; break;
			case DIRECTION_UP:    --sprite_beepbeep.spr_y; break;
			case DIRECTION_DOWN:  ++sprite_beepbeep.spr_y; break;		
			}	
		}
				
	if (sprite_beepbeep.spr_anim < 1) {

		if (sprite_coyote.spr_state & STATE_FALLING) { sprite_coyote.spr_next = MAP01; } else { SCBNEXT(BACK04) = MAP01; }
			
		sprite_beepbeep.spr_b1 = 0x18;
		sprite_beepbeep.spr_next = 0;
		sprite_beepbeep.spr_x = 50;
		sprite_beepbeep.spr_y = 60;
		sprite_beepbeep.spr_sizex = 0x100;
		sprite_beepbeep.spr_sizey = 0x100;
		sprite_beepbeep.spr_anim = 0;
		sprite_beepbeep.spr_act = ACT_NOTHING;
		sprite_beepbeep.spr_state = STATE_NORMAL;
		}
	}

void beepbeep_inc_anim() {
	++sprite_beepbeep.spr_anim;
	if (sprite_beepbeep.spr_anim > 250) { sprite_beepbeep.spr_anim = 0; }
	}

void beepbeep_is_mocking_or_jumping() {
	
	beepbeep_inc_anim();
	
	if ((joy & BUTTON_OUTER) && (sprite_beepbeep.spr_act == ACT_NOTHING) && !beepbeep_lagtime) {
		
	 	sprite_beepbeep.spr_act = ACT_JUMPING;
		beepbeep_lagtime = 20;
		sprite_beepbeep.spr_anim = 20;
		sprite_beepbeep.spr_id = ID_BEEPBEEP_JUMP;
		}
	else if ((joy & BUTTON_INNER) && (sprite_beepbeep.spr_act == ACT_NOTHING) && !beepbeep_lagtime) {
		
		beepbeep_lagtime = 15;
		sprite_beepbeep.spr_anim = 7;
	 	sprite_beepbeep.spr_act = ACT_MOCKING;
		
		if ((sprite_beepbeep.spr_anim & 3) == 3) { ++sprite_beepbeep.spr_anim; }
		
		switch (sprite_beepbeep.spr_anim & 3) {
			case 0: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_MOCK_1; break;
			case 1: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_MOCK_2; break;
			case 2: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_MOCK_3; break;
			}
		}
	else {
		
	 	sprite_beepbeep.spr_act = ACT_NOTHING;
		
		if ((sprite_beepbeep.spr_anim & 3) == 3) { ++sprite_beepbeep.spr_anim; }
		
		switch (sprite_beepbeep.spr_anim & 3) {
			case 0: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_1; break;
			case 1: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_2; break;
			case 2: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_3; break;
			}
		}
	}

void beepbeep_set_sprite() {
	
	if (!(sprite_beepbeep.spr_state & STATE_CAUGHT) && sprite_beepbeep.spr_act != ACT_JUMPING) { 
		if (beepbeep_is_falling()) { beepbeep_set_falling(); return; } 
		}
	
	if (sprite_beepbeep.spr_state & STATE_CAUGHT) {
		
		sprite_beepbeep.spr_x = sprite_coyote.spr_x + (sprite_coyote.spr_d == DIRECTION_INVERSE ? 12 : -12);
		sprite_beepbeep.spr_y = sprite_coyote.spr_y + (pursuit_mode ? -3 : 0) + ((sprite_coyote.spr_id == ID_COYOTE_BOINK_GET_2) ? -3 : 0);
		sprite_beepbeep.spr_d = (sprite_coyote.spr_d == DIRECTION_INVERSE) ? DIRECTION_NORMAL : DIRECTION_INVERSE;
		
		if (sprite_beepbeep.spr_state & STATE_FIRED) { sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_9; }
																						else { sprite_beepbeep.spr_id = ID_BEEPBEEP_CAUGHT; }
		
		return;
		}
	else if (sprite_beepbeep.spr_state & STATE_FIRED) {
		
		sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_9;
		return;
		}
	else if (sprite_beepbeep.spr_state & STATE_SMASHED) {
		
		--sprite_beepbeep.spr_anim;
		if (sprite_beepbeep.spr_anim) {
			
			if ((sprite_beepbeep.spr_anim & 3) == 3) { --sprite_beepbeep.spr_anim; }
			
			switch (sprite_beepbeep.spr_anim & 3) {
				case 0: sprite_beepbeep.spr_id = ID_BEEPBEEP_HIT_1; break;
				case 1: sprite_beepbeep.spr_id = ID_BEEPBEEP_HIT_2; break;
				case 2: sprite_beepbeep.spr_id = ID_BEEPBEEP_HIT_3; break;
				}
			
			return;
			}
		sprite_beepbeep.spr_state &= !STATE_SMASHED;
		}
	
	if (sprite_beepbeep.spr_act == ACT_BURNING) {
		
		--sprite_beepbeep.spr_anim;
		
		if (sprite_beepbeep.spr_anim) {
			
			switch (sprite_beepbeep.spr_anim) {
				case 8: sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_8; break;
				case 7: sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_7; break;
				case 6: sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_6; break;
				case 5: sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_5; break;
				case 4: sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_4; break;
				case 3: sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_3; break;
				case 2: sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_2; break;
				case 1:
					sprite_beepbeep.spr_id = ID_BEEPBEEP_BURN_1;
					sprite_beepbeep.spr_state |= STATE_FIRED;
					break;
				}
			
			return;
			}
		}
	else if (sprite_beepbeep.spr_act == ACT_DRINKING) {
		
		--sprite_beepbeep.spr_anim;
		if (sprite_beepbeep.spr_anim) {
			
			if (sprite_beepbeep.spr_anim & 1) { sprite_beepbeep.spr_id = ID_BEEPBEEP_DRINK_1; }
																	 else { sprite_beepbeep.spr_id = ID_BEEPBEEP_DRINK_2; }
			
			return;
			}
		}
	else if (sprite_beepbeep.spr_act == ACT_JUMPING) {
		
		--sprite_beepbeep.spr_anim;
		if (sprite_beepbeep.spr_anim) {
			
			if (sprite_beepbeep.spr_d == DIRECTION_LEFT) { --sprite_beepbeep.spr_x; }
			else 
			if (sprite_beepbeep.spr_d == DIRECTION_RIGHT) { ++sprite_beepbeep.spr_x; }
			
			sprite_beepbeep.spr_id = ID_BEEPBEEP_JUMP;
			
			return;
			}
		}
	else if (sprite_beepbeep.spr_act == ACT_MOCKING) {
		
		--sprite_beepbeep.spr_anim;
		if (sprite_beepbeep.spr_anim) {
			
			if (sprite_beepbeep.spr_id == ID_BEEPBEEP_STAND_MOCK) { --sprite_beepbeep.spr_anim; return; }
			
			if (sprite_beepbeep.spr_d == DIRECTION_LEFT) { --sprite_beepbeep.spr_x; }
			else 
			if (sprite_beepbeep.spr_d == DIRECTION_RIGHT) { ++sprite_beepbeep.spr_x; }
			
			if ((sprite_beepbeep.spr_anim & 3) == 3) { --sprite_beepbeep.spr_anim; }
			
			switch (sprite_beepbeep.spr_anim & 3) {
				case 0: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_MOCK_1; break;
				case 1: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_MOCK_2; break;
				case 2: sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_MOCK_3; break;
				}
			
			return;
			}
		}
	
	if (beepbeep_lagtime) { --beepbeep_lagtime; }
	
 	joy = joystick;
		
	if (joy) { beepbeep_standtime = 0; }
	
	if ((joy & JOY_UP) && (sprite_beepbeep.spr_act == ACT_NOTHING)) {
		
		--sprite_beepbeep.spr_y;
		if (sprite_beepbeep.spr_y < 20) { sprite_beepbeep.spr_y = 20; }
			
		if (sprite_beepbeep.spr_d != DIRECTION_UP) { sprite_beepbeep.spr_anim = 0; }
		sprite_beepbeep.spr_d = DIRECTION_UP;
		
		beepbeep_inc_anim();
		
		if (sprite_beepbeep.spr_anim & 1) { sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_UP_1; }
		                             else { sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_UP_2; }
		}
	else if ((joy & JOY_DOWN) && (sprite_beepbeep.spr_act == ACT_NOTHING)) {
	
		++sprite_beepbeep.spr_y; 
		if (sprite_beepbeep.spr_y > 82) { sprite_beepbeep.spr_y = 82; }
			
		if (sprite_beepbeep.spr_d != DIRECTION_DOWN) { sprite_beepbeep.spr_anim = 0; }
		sprite_beepbeep.spr_d = DIRECTION_DOWN;
		
		beepbeep_inc_anim();
		
		if (sprite_beepbeep.spr_anim & 1) { sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_DOWN_1; }
		                             else { sprite_beepbeep.spr_id = ID_BEEPBEEP_RUN_DOWN_2; }
		}
	else if (joy & JOY_LEFT) {
		
		--sprite_beepbeep.spr_x;
		if (sprite_beepbeep.spr_x < 20) { sprite_beepbeep.spr_x = 20; }
			
		if (sprite_beepbeep.spr_d != DIRECTION_LEFT) { sprite_beepbeep.spr_anim = 0; }
		sprite_beepbeep.spr_d = DIRECTION_LEFT;
		
		beepbeep_is_mocking_or_jumping();
		}
	else if (joy & JOY_RIGHT) {
		
		++sprite_beepbeep.spr_x;
		if (sprite_beepbeep.spr_x > 140) { sprite_beepbeep.spr_x = 140; }
			
		if (sprite_beepbeep.spr_d != DIRECTION_RIGHT) { sprite_beepbeep.spr_anim = 0; }
		sprite_beepbeep.spr_d = DIRECTION_RIGHT;
		
		beepbeep_is_mocking_or_jumping();
		}
	else {
		
		if ((joy & BUTTON_INNER) && (sprite_beepbeep.spr_act == ACT_NOTHING) && !beepbeep_lagtime) {
			
			beepbeep_lagtime = 15;
			sprite_beepbeep.spr_anim = 7;
 		 	sprite_beepbeep.spr_act = ACT_MOCKING;
			sprite_beepbeep.spr_id = ID_BEEPBEEP_STAND_MOCK;
			}
		else {
 		 	sprite_beepbeep.spr_act = ACT_NOTHING;
			
			if (beepbeep_standtime < 200) {
				++beepbeep_standtime;
				sprite_beepbeep.spr_id = ID_BEEPBEEP_STAND;
				}
			else if (beepbeep_standtime < 220) {
				++beepbeep_standtime;
				sprite_beepbeep.spr_id = ID_BEEPBEEP_NOD_1;
				}
			else if (beepbeep_standtime < 240) {
				++beepbeep_standtime;
				sprite_beepbeep.spr_id = ID_BEEPBEEP_NOD_2;
				}
			else {
				beepbeep_standtime = 201;
				sprite_beepbeep.spr_id = ID_BEEPBEEP_NOD_2;
				}
			}
		}
	}


/*
*******************************************************************************
 *  coyote
 *******************************************************************************
 */

uchar coyote_is_falling() {
	if (sprite_coyote.spr_state & STATE_FALLING) { return 1; }
	if (GetColor(sprite_coyote.spr_x, sprite_coyote.spr_y) != 5) { 
		if (sprite_coyote.spr_x < 0) { return 0; }
		if (sprite_coyote.spr_x > 160) { return 0; }
		if (sprite_coyote.spr_y < 0) { return 0; }
		if (sprite_coyote.spr_x > 102) { return 0; }
		
		SCBNEXT(BACK04) = &sprite_coyote;
		if (sprite_beepbeep.spr_state & STATE_FALLING) { sprite_coyote.spr_next = &sprite_beepbeep; }
		                                          else { sprite_coyote.spr_next = MAP01; }
			
		sprite_coyote.spr_b1 = 0x10;
		sprite_coyote.spr_anim = 100;
		sprite_coyote.spr_id = ID_COYOTE_HELP;
		sprite_coyote.spr_state = STATE_FALLING;
		
		return 1;
		}
	return 0;
	}

void coyote_set_falling() {
	--sprite_coyote.spr_anim;
	if (sprite_coyote.spr_sizex > 2) { sprite_coyote.spr_sizex -= 2; }
	if (sprite_coyote.spr_sizey > 2) { sprite_coyote.spr_sizey -= 2; }
		
	if (!(sprite_coyote.spr_anim % 3)) {
		switch (sprite_coyote.spr_d) {
			case DIRECTION_LEFT:  --sprite_coyote.spr_x; break;
			case DIRECTION_RIGHT: ++sprite_coyote.spr_x; break;
			case DIRECTION_UP:    --sprite_coyote.spr_y; break;
			case DIRECTION_DOWN:  ++sprite_coyote.spr_y; break;		
			}
		}	

	if (sprite_coyote.spr_anim < 1) {

		if (sprite_beepbeep.spr_state & STATE_FALLING) { SCBNEXT(BACK04) = &sprite_beepbeep; } else { SCBNEXT(BACK04) = MAP01; }
			
		++pursuit_mode;
		if (pursuit_mode > 4) { pursuit_mode = 0; }
		sprite_coyote.spr_b1 = 0x18;
		sprite_coyote.spr_next = 0;
		sprite_coyote.spr_x = 110;
		sprite_coyote.spr_y = 60;
		sprite_coyote.spr_sizex = 0x100;
		sprite_coyote.spr_sizey = 0x100;
		sprite_coyote.spr_anim = 0;
		sprite_coyote.spr_act = ACT_NOTHING;
		sprite_coyote.spr_state = STATE_NORMAL;
		}
	}

void coyote_set_move(dx, dy) char dx; char dy; {
	if (sprite_coyote.spr_x < 0 || sprite_coyote.spr_x > 160 || sprite_coyote.spr_y < 0 || sprite_coyote.spr_y > 102 || 
			GetColor(sprite_coyote.spr_x + dx, sprite_coyote.spr_y + dy) == 5) { 

		sprite_coyote.spr_x += dx; 
		sprite_coyote.spr_y += dy; 
		}
	}

void coyote_set_sprite_run() {
		
	if (!(sprite_beepbeep.spr_state & STATE_CAUGHT) && sprite_coyote.spr_act != ACT_BREAKING) { if (coyote_is_falling()) { coyote_set_falling(); return; } }

  if (sprite_beepbeep.spr_state & STATE_FALLING) { sprite_coyote.spr_id = ID_COYOTE_STAND; return; }

	if (sprite_coyote.spr_state & STATE_SMASHED) {
		--sprite_coyote.spr_anim;
		if (sprite_coyote.spr_anim) {
			sprite_coyote.spr_id = ID_COYOTE_SMASH;
			
			return;
			}
		
		sprite_coyote.spr_state &= !STATE_SMASHED;
		}
	else if (sprite_coyote.spr_act == ACT_BURNING) {
		--sprite_coyote.spr_anim;
		if (sprite_coyote.spr_anim) {
			
			switch (sprite_coyote.spr_anim) {
				case 8: sprite_coyote.spr_id = ID_COYOTE_BURN_8; break;
				case 7: sprite_coyote.spr_id = ID_COYOTE_BURN_7; break;
				case 6: sprite_coyote.spr_id = ID_COYOTE_BURN_6; break;
				case 5: sprite_coyote.spr_id = ID_COYOTE_BURN_5; break;
				case 4: sprite_coyote.spr_id = ID_COYOTE_BURN_4; break;
				case 3: sprite_coyote.spr_id = ID_COYOTE_BURN_3; break;
				case 2: sprite_coyote.spr_id = ID_COYOTE_BURN_2; break;
				case 1:
					sprite_coyote.spr_id = ID_COYOTE_BURN_1;
					sprite_coyote.spr_state &= STATE_FIRED;
					break;
				}
			}
		else {
			sprite_coyote.spr_act = ACT_NOTHING;
			}
		return;
		}
	else if (sprite_coyote.spr_act == ACT_DRINKING) {
		--sprite_coyote.spr_anim;
		if (sprite_coyote.spr_anim) {
			
			if ((sprite_coyote.spr_anim & 3) == 3) { --sprite_coyote.spr_anim; }
			
			switch (sprite_coyote.spr_anim & 3) {
				case 0: sprite_coyote.spr_id = ID_COYOTE_DRINK_1; break;
				case 1: sprite_coyote.spr_id = ID_COYOTE_DRINK_2; break;
				case 2: sprite_coyote.spr_id = ID_COYOTE_DRINK_3; break;
				}
			}
		else {
			sprite_coyote.spr_act = ACT_NOTHING;
			}
		return;
		}
	else if (sprite_coyote.spr_act == ACT_BREAKING) {
		--sprite_coyote.spr_anim;
		if (sprite_coyote.spr_anim) {
			
			if (sprite_coyote.spr_d == DIRECTION_LEFT) {
				--sprite_coyote.spr_x;
				if (sprite_beepbeep.spr_x < (sprite_coyote.spr_x + 25)) { sprite_coyote.spr_id = ID_COYOTE_BREAK_1; }
				else { sprite_coyote.spr_id = ID_COYOTE_BREAK_2; }
				}
			else {
				++sprite_coyote.spr_x;
				if (sprite_beepbeep.spr_x > (sprite_coyote.spr_x - 25)) { sprite_coyote.spr_id = ID_COYOTE_BREAK_1; }
				else { sprite_coyote.spr_id = ID_COYOTE_BREAK_2; }
				}
			
			return;
			}
		
	 	if (sprite_coyote.spr_d == DIRECTION_LEFT) { sprite_coyote.spr_d = DIRECTION_RIGHT; }
		else { sprite_coyote.spr_d = DIRECTION_LEFT; }
		
		sprite_coyote.spr_act = ACT_NOTHING;
		}
	
	if (coyote_lagtime > 0) { --coyote_lagtime; return; }
	coyote_lagtime = 1;
		
	if (sprite_beepbeep.spr_state & STATE_CAUGHT) {
		
		sprite_coyote.spr_d = DIRECTION_RIGHT;
		++sprite_coyote.spr_x;
		}
	else if (sprite_beepbeep.spr_x < sprite_coyote.spr_x) {
		
		if (sprite_coyote.spr_d == DIRECTION_RIGHT) {
			sprite_coyote.spr_act = ACT_BREAKING;
			sprite_coyote.spr_anim = 20;
			}
		else {
			sprite_coyote.spr_d = DIRECTION_LEFT;
			coyote_set_move(-1, 0);
			}
		}
	else if (sprite_beepbeep.spr_x > sprite_coyote.spr_x) {
		
		if (sprite_coyote.spr_d == DIRECTION_LEFT) {
			sprite_coyote.spr_act = ACT_BREAKING;
			sprite_coyote.spr_anim = 20;
			}
		else {
			sprite_coyote.spr_d = DIRECTION_RIGHT;
			coyote_set_move(1, 0);
			}
		}
	
	if (!(sprite_beepbeep.spr_state & STATE_CAUGHT)) {
		if (sprite_beepbeep.spr_y < sprite_coyote.spr_y)	 {
			coyote_set_move(0, -1);
			}
		else if (sprite_beepbeep.spr_y > sprite_coyote.spr_y) {
			coyote_set_move(0, 1);
			}
		}
	
	if (sprite_coyote.spr_act == ACT_NOTHING) {
		
		++sprite_coyote.spr_anim;
		if (sprite_coyote.spr_anim > 250) { sprite_coyote.spr_anim = 0; }
		
		if (sprite_beepbeep.spr_state & STATE_CAUGHT) {
			
			if ((sprite_coyote.spr_anim & 3) == 3) { ++sprite_coyote.spr_anim; }
			
			switch (sprite_coyote.spr_anim & 3) {
				case 0: sprite_coyote.spr_id = ID_COYOTE_RUN_GET_1; break;
				case 1: sprite_coyote.spr_id = ID_COYOTE_RUN_GET_2; break;
				case 2: sprite_coyote.spr_id = ID_COYOTE_RUN_GET_3; break;
				}
			}
		else {
			
			switch (sprite_coyote.spr_anim & 3) {
				case 0: sprite_coyote.spr_id = ID_COYOTE_RUN_1; break;
				case 1: sprite_coyote.spr_id = ID_COYOTE_RUN_2; break;
				case 2: sprite_coyote.spr_id = ID_COYOTE_RUN_3; break;
				case 3: sprite_coyote.spr_id = ID_COYOTE_RUN_4; break;
				}
			}
		}
	}

void coyote_is_turning_skate() {
	if (sprite_coyote.spr_d == DIRECTION_LEFT) {
		if (sprite_beepbeep.spr_x > (sprite_coyote.spr_x + 20)) {
			sprite_coyote.spr_d = DIRECTION_RIGHT;
			coyote_set_move(1, 0);
			}
		else {
			coyote_set_move(-1, 0);
			}
		}
	else {
		if (sprite_beepbeep.spr_x < (sprite_coyote.spr_x - 20)) {
			sprite_coyote.spr_d = DIRECTION_LEFT;
			coyote_set_move(-1, 0);
			}
		else {
			coyote_set_move(1, 0);
			}
		}
	}

void coyote_set_sprite_skate() {

	if (sprite_beepbeep.spr_state & STATE_CAUGHT) {		
		
		if (sprite_coyote.spr_d == DIRECTION_RIGHT) { coyote_set_move(1, 0); } else { coyote_set_move(-1, 0); }
		}
	else if (coyote_is_falling()) { 
		
		coyote_set_falling(); 
		return; 
		}
	else 	if (sprite_beepbeep.spr_state & STATE_FALLING) { 
	
		sprite_coyote.spr_id = ID_COYOTE_STAND; 
		return; 
		}
	else if (sprite_beepbeep.spr_y < sprite_coyote.spr_y)	 {
		
		if (coyote_lagtime > 0) { --coyote_lagtime; return; }
		coyote_lagtime = 1;
		
		coyote_is_turning_skate();
		coyote_set_move(0, -1);
		}
	else if (sprite_beepbeep.spr_y > sprite_coyote.spr_y) {
		
		if (coyote_lagtime > 0) { --coyote_lagtime; return; }
		coyote_lagtime = 1;
		
		coyote_is_turning_skate();
		coyote_set_move(0, 1);
		}
	else if (sprite_beepbeep.spr_x < sprite_coyote.spr_x)	 {
		
		sprite_coyote.spr_d = DIRECTION_LEFT;
		coyote_set_move(-1, 0);
		}
	else if (sprite_beepbeep.spr_x > sprite_coyote.spr_x) {
		
		sprite_coyote.spr_d = DIRECTION_RIGHT;
		coyote_set_move(1, 0);
		}
	
	++sprite_coyote.spr_anim;
	if (sprite_coyote.spr_anim > 250) { sprite_coyote.spr_anim = 0; }
	
	if (sprite_beepbeep.spr_state & STATE_CAUGHT) {
		switch (sprite_coyote.spr_anim & 1) {
			case 0: sprite_coyote.spr_id = ID_COYOTE_SKATE_GET_1; break;
			case 1: sprite_coyote.spr_id = ID_COYOTE_SKATE_GET_2; break;
			}
		}
	else {
		switch (sprite_coyote.spr_anim & 1) {
			case 0: sprite_coyote.spr_id = ID_COYOTE_SKATE_1; break;
			case 1: sprite_coyote.spr_id = ID_COYOTE_SKATE_2; break;
			}
		}
	}

void coyote_set_sprite_boink() {
	
	if (!(sprite_beepbeep.spr_state & STATE_CAUGHT) && (sprite_coyote.spr_id != ID_COYOTE_BOINK_2 && sprite_coyote.spr_id != ID_COYOTE_BOINK_DOWN_2)) { 
		if (coyote_is_falling()) { coyote_set_falling(); return; } 
		}

	if (sprite_beepbeep.spr_state & STATE_FALLING) { sprite_coyote.spr_id = ID_COYOTE_STAND; return; }

	if (coyote_lagtime > 0) { --coyote_lagtime; return; }
	
	if (sprite_coyote.spr_anim) {
		
		if (sprite_beepbeep.spr_state & STATE_CAUGHT) {
			
			sprite_coyote.spr_id = ID_COYOTE_BOINK_GET_2;
			coyote_set_move(1, 0);
			}
		else {
			switch (sprite_coyote.spr_d) {
				case DIRECTION_LEFT:  --sprite_coyote.spr_x; sprite_coyote.spr_id = ID_COYOTE_BOINK_2; break;
				case DIRECTION_RIGHT: ++sprite_coyote.spr_x; sprite_coyote.spr_id = ID_COYOTE_BOINK_2; break;
				case DIRECTION_UP:    --sprite_coyote.spr_y; sprite_coyote.spr_id = ID_COYOTE_BOINK_2; break;
				case DIRECTION_DOWN:  ++sprite_coyote.spr_y; sprite_coyote.spr_id = ID_COYOTE_BOINK_DOWN_2; break;
    		}
			}
		--sprite_coyote.spr_anim;
		return;
		}
	else {
		coyote_lagtime = 4;
		}

	if (sprite_beepbeep.spr_state & STATE_CAUGHT) {
		
		sprite_coyote.spr_d = DIRECTION_RIGHT;
 		sprite_coyote.spr_id = ID_COYOTE_BOINK_GET_1;
		sprite_coyote.spr_anim =  12;
		
		return;
		}
	else 	if (coyote_is_falling()) { 
	
		coyote_set_falling(); 
		return; 
		}
	else if (sprite_beepbeep.spr_x < sprite_coyote.spr_x)	 {
		
		sprite_coyote.spr_d = DIRECTION_LEFT;
 		sprite_coyote.spr_id = ID_COYOTE_BOINK_1;
		sprite_coyote.spr_anim = (random() & 1) ? 24 : 12;
		}
	else if (sprite_beepbeep.spr_x > sprite_coyote.spr_x) {
		
		sprite_coyote.spr_d = DIRECTION_RIGHT;
 		sprite_coyote.spr_id = ID_COYOTE_BOINK_1;
		sprite_coyote.spr_anim =  (random() & 1) ? 24 : 12;
		}
	if (random() & 1) { return; }
	if (sprite_beepbeep.spr_y < sprite_coyote.spr_y)	 {
		
		sprite_coyote.spr_d = DIRECTION_UP;
 		sprite_coyote.spr_id = ID_COYOTE_BOINK_1;
		sprite_coyote.spr_anim = 12;
		}
	else {
		
		sprite_coyote.spr_d = DIRECTION_DOWN;
 		sprite_coyote.spr_id = ID_COYOTE_BOINK_DOWN_1;
		sprite_coyote.spr_anim = 12;
		}
	}

void coyote_set_sprite_rocket() {
	
	++sprite_coyote.spr_anim;
	if (sprite_coyote.spr_anim > 250) { sprite_coyote.spr_anim = 0; }
	
	if (sprite_coyote.spr_d == DIRECTION_LEFT) {
		sprite_coyote.spr_x -= 2;
		
		if (sprite_coyote.spr_x < -40) {
			sprite_coyote.spr_d = DIRECTION_RIGHT;
			sprite_coyote.spr_y = (random() % 80) + 20;
			}
		
		switch (sprite_coyote.spr_anim & 1) {
			case 0:
				if (sprite_beepbeep.spr_x > (sprite_coyote.spr_x + 30)) { sprite_coyote.spr_id = ID_COYOTE_ROCKET_BEHIND_1; }
				else { sprite_coyote.spr_id = ID_COYOTE_ROCKET_1; }
				break;
			case 1:
				if (sprite_beepbeep.spr_x > (sprite_coyote.spr_x + 30)) { sprite_coyote.spr_id = ID_COYOTE_ROCKET_BEHIND_2; }
				else { sprite_coyote.spr_id = ID_COYOTE_ROCKET_2; }
				break;
			}
		}
	else {
		sprite_coyote.spr_x += 2;
		
		if (sprite_coyote.spr_x > 200) {
			sprite_coyote.spr_d = DIRECTION_LEFT;
			sprite_coyote.spr_y = (random() % 80) + 20;
  		}
		
		switch (sprite_coyote.spr_anim & 1) {
			case 0:
				if (sprite_beepbeep.spr_state & STATE_CAUGHT) { sprite_coyote.spr_id = ID_COYOTE_ROCKET_GET_1; }
				else if (sprite_beepbeep.spr_x < (sprite_coyote.spr_x - 30)) { sprite_coyote.spr_id = ID_COYOTE_ROCKET_BEHIND_1; }
				else { sprite_coyote.spr_id = ID_COYOTE_ROCKET_1; }
				break;
			case 1:
				if (sprite_beepbeep.spr_state & STATE_CAUGHT) { sprite_coyote.spr_id = ID_COYOTE_ROCKET_GET_2; }
				else if (sprite_beepbeep.spr_x < (sprite_coyote.spr_x - 30)) { sprite_coyote.spr_id = ID_COYOTE_ROCKET_BEHIND_2; }
				else { sprite_coyote.spr_id = ID_COYOTE_ROCKET_2; }
				break;
			}
		}
	}

void coyote_set_sprite_helico() {
	
	if (sprite_coyote.spr_d == DIRECTION_LEFT) {
		sprite_coyote.spr_x -= 2;
		
		if (sprite_coyote.spr_x < -40) {
			sprite_coyote.spr_d = DIRECTION_RIGHT;
			sprite_coyote.spr_y = (random() % 40);
			}
		}
	else {
		sprite_coyote.spr_x += 2;
		
		if (sprite_coyote.spr_x > 200) {
			sprite_coyote.spr_d = DIRECTION_LEFT;
			sprite_coyote.spr_y = (random() % 40);
  		}
		}
	
	++sprite_coyote.spr_anim;
	if (sprite_coyote.spr_anim > 250) { sprite_coyote.spr_anim = 0; }
	
	if (coyote_has_dynamite) { sprite_coyote.spr_id = ID_COYOTE_FLY_DYNAMITE; }
	else { sprite_coyote.spr_id = ID_COYOTE_FLY; }
	
	switch (sprite_coyote.spr_anim & 3) {
		case 0:
			sprite_coyote.spr_next = 0;
			break;
		case 1:
			sprite_coyote.spr_next = SCB_helico2;
			SCBX(SCB_helico2) = sprite_coyote.spr_x;
			SCBY(SCB_helico2) = sprite_coyote.spr_y;
			if (sprite_coyote.spr_d == DIRECTION_INVERSE) { SCBCTL0(SCB_helico2) |= 0x20; }
				else { SCBCTL0(SCB_helico2) &= 0xdf; }
				break;
		case 2:
			sprite_coyote.spr_next = SCB_helico3;
			SCBX(SCB_helico3) = sprite_coyote.spr_x;
			SCBY(SCB_helico3) = sprite_coyote.spr_y;
			if (sprite_coyote.spr_d == DIRECTION_INVERSE) { SCBCTL0(SCB_helico3) |= 0x20; }
				else { SCBCTL0(SCB_helico3) &= 0xdf; }
				break;
		case 3:
			sprite_coyote.spr_next = SCB_helico4;
			SCBX(SCB_helico4) = sprite_coyote.spr_x;
			SCBY(SCB_helico4) = sprite_coyote.spr_y;
			if (sprite_coyote.spr_d == DIRECTION_INVERSE) { SCBCTL0(SCB_helico4) |= 0x20; }
				else { SCBCTL0(SCB_helico4) &= 0xdf; }
				break;
	}
}

/*
*******************************************************************************
 *  interactions
 *******************************************************************************
 */

int sprite_dx = 0;
int sprite_dy = 0;
uchar sprite_dw = 0;
uchar sprite_dh = 0;
uchar test_exit = 0;

void test_capture() {
	
	if (pursuit_mode == 4) { return; }
	
	sprite_dx = (sprite_coyote.spr_x - sprite_beepbeep.spr_x);
	sprite_dy = (sprite_coyote.spr_y - sprite_beepbeep.spr_y);
	
	sprite_dx = (sprite_dx > 0) ? sprite_dx : -sprite_dx;
	sprite_dy = (sprite_dy > 0) ? sprite_dy : -sprite_dy;
	
	if ((sprite_dx + sprite_dy) < 7) { 
		if (!(sprite_beepbeep.spr_state & STATE_FALLING) && !(sprite_coyote.spr_state & STATE_FALLING)) { 
			sprite_beepbeep.spr_state |= STATE_CAUGHT; 
			} 
		}
	}


uchar test_distance_beepbeep(d1, d2, d3, d4) char d1; char d2; uchar d3; uchar d4; {
	
	if (sprite_beepbeep.spr_act == ACT_JUMPING) { return 0; }
	
	sprite_dx = elements[elements_j].ele_x + d1;
	sprite_dy = elements[elements_j].ele_y + d2;
	sprite_dw = d3;
	sprite_dh = d4;
	
	if (sprite_beepbeep.spr_x < sprite_dx) { return 0; }
	if (sprite_beepbeep.spr_x > (sprite_dx + sprite_dw)) { return 0; }
	if (sprite_beepbeep.spr_y < sprite_dy) { return 0; }
	if (sprite_beepbeep.spr_y > (sprite_dy + sprite_dh)) { return 0; }
	
	return 1;
	}

void test_elements_with_beepbeep() {
	
	test_exit = 0;
	
	for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) {
		
		switch(elements[elements_j].ele_type) {
			case ELEMENT_SEED:
				if (test_distance_beepbeep(-3, -3, 6, 6)) {
					elements_die(elements_j);
					test_exit = 1;
				}
				break;
			case ELEMENT_LEMONADE:
				if (test_distance_beepbeep(-2, -2, 4, 4)) {
					elements_die(elements_j);
					sprite_beepbeep.spr_act = ACT_DRINKING;
					sprite_beepbeep.spr_anim = 20;
					test_exit = 1;
				}
				break;
			case ELEMENT_GUNBALL:
			case ELEMENT_DYNAMITE:
			case ELEMENT_MINE:
				if (test_distance_beepbeep(-3, -3, 6, 6)) {
					elements_die(elements_j);
					sprite_beepbeep.spr_act = ACT_BURNING;
					sprite_beepbeep.spr_anim = 9;
					test_exit = 1;
				}
				break;
			case ELEMENT_VAN1:
			case ELEMENT_VAN2:
			case ELEMENT_VAN3:
			case ELEMENT_VAN4:
				if (!(sprite_beepbeep.spr_state & STATE_SMASHED)) {
					if (test_distance_beepbeep(-40, -6, 45, 6)) {
						sprite_beepbeep.spr_state |= STATE_SMASHED;
						sprite_beepbeep.spr_anim = 40;
						test_exit = 1;
						}
					}
				break;
			case ELEMENT_ROCK1:
			case ELEMENT_ROCK2:
			case ELEMENT_ROCK3:
				if (!sprite_beepbeep.spr_state) {
					if (test_distance_beepbeep(-10, -10, 20, 20)) {
						sprite_beepbeep.spr_state = STATE_SMASHED;
						sprite_beepbeep.spr_anim = 40;
						test_exit = 1;
						}
					}
				break;
			}
		if (test_exit) { break; }
		}
	}

uchar test_distance_coyote(d1, d2, d3, d4) char d1; char d2; uchar d3; uchar d4; {
	
	sprite_dx = elements[elements_j].ele_x + d1;
	sprite_dy = elements[elements_j].ele_y + d2;
	sprite_dw = d3;
	sprite_dh = d4;
	
	if (sprite_coyote.spr_x < sprite_dx) { return 0; }
	if (sprite_coyote.spr_x > (sprite_dx + sprite_dw)) { return 0; }
	if (sprite_coyote.spr_y < sprite_dy) { return 0; }
	if (sprite_coyote.spr_y > (sprite_dy + sprite_dh)) { return 0; }
	
	return 1;
	}


void test_elements_with_coyote() {
	
	if (pursuit_mode) { return; }
	
	test_exit = 0;
	
	for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) {
		
		switch(elements[elements_j].ele_type) {
			case ELEMENT_LEMONADE:
				if (test_distance_coyote(-3, -3, 3, 3)) {
					elements_die(elements_j);
					sprite_coyote.spr_act = ACT_DRINKING;
					sprite_coyote.spr_anim = 60;
					test_exit = 1;
					}
				break;
			case ELEMENT_GUNBALL:
			case ELEMENT_DYNAMITE:
			case ELEMENT_MINE:
				if (test_distance_coyote(-3, -3, 6, 6)) {
					elements_die(elements_j);
					sprite_coyote.spr_act = ACT_BURNING;
					sprite_coyote.spr_anim = 9;
					test_exit = 1;
					}
				break;
			case ELEMENT_VAN1:
			case ELEMENT_VAN2:
			case ELEMENT_VAN3:
			case ELEMENT_VAN4:
				if (!sprite_coyote.spr_state) {
					if (test_distance_coyote(-40, -6, 45, 6)) {
						sprite_coyote.spr_state = STATE_SMASHED;
						sprite_coyote.spr_anim = 40;
						test_exit = 1;
						}
					}
				break;
			case ELEMENT_ROCK1:
			case ELEMENT_ROCK2:
			case ELEMENT_ROCK3:
				if (!sprite_coyote.spr_state) {
					if (test_distance_coyote(-10, -10, 20, 20)) {
						sprite_coyote.spr_state = STATE_SMASHED;
						sprite_coyote.spr_anim = 40;
						test_exit = 1;
						}
					}
				break;
			}
		if (test_exit) { break; }
		}
	}

/*
*******************************************************************************
 *  dcors
 *******************************************************************************
 */

void background_set() {
			
	if (joy & JOY_ALL) {
		if (background_scroll_lag == 1) { background_scroll_lag = 0; } else {
					
			background_scroll_lag = 1;
					
			if (sprite_beepbeep.spr_x < 21 && (joy & JOY_LEFT)) {
				++SCBX(BACK01);
				++SCBX(BACK02);
				++SCBX(BACK03);
				++SCBX(BACK04);
				if (SCBX(BACK01) > 0) { 
					SCBX(BACK01) = SCBX(BACK03) = -160; 
					SCBX(BACK02) = SCBX(BACK04) = 0; 
					}
				}
			else if (sprite_beepbeep.spr_x > 139 && (joy & JOY_RIGHT)) {
				--SCBX(BACK01);
				--SCBX(BACK02);
				--SCBX(BACK03);
				--SCBX(BACK04);
				if (SCBX(BACK01) < -160) { 
					SCBX(BACK01) = SCBX(BACK03) = 0; 
					SCBX(BACK02) = SCBX(BACK04) = 160; 
					}
				}
			if (sprite_beepbeep.spr_y < 21 && (joy & JOY_UP)) {
				++SCBY(BACK01);
				++SCBY(BACK02);
				++SCBY(BACK03);
				++SCBY(BACK04);
				if (SCBY(BACK01) > 0) { 
					SCBY(BACK01) = SCBY(BACK02) = -102; 
					SCBY(BACK03) = SCBY(BACK04) = 0; 
					}
				}
			else if (sprite_beepbeep.spr_y > 81 && (joy & JOY_DOWN)) {
				--SCBY(BACK01);
				--SCBY(BACK02);
				--SCBY(BACK03);
				--SCBY(BACK04);
				if (SCBY(BACK01) < -102) { 
					SCBY(BACK01) = SCBY(BACK02) = 0; 
					SCBY(BACK03) = SCBY(BACK04) = 102; 
					}
				}
			}

		if (sprite_beepbeep.spr_x < 21 && (joy & JOY_LEFT)) { 
			++foreground_x; 
			++sprite_coyote.spr_x;
			++sprite_beepbeep.spr_x;
			for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) { ++elements[elements_j].ele_x; }
			}
		else if (sprite_beepbeep.spr_x > 139 && (joy & JOY_RIGHT)) { 
			--foreground_x; 
			--sprite_coyote.spr_x;
			--sprite_beepbeep.spr_x;
			for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) { --elements[elements_j].ele_x; }
			}
		if (sprite_beepbeep.spr_y < 21 && (joy & JOY_UP)) { 
			++foreground_y; 
			++sprite_coyote.spr_y;
			++sprite_beepbeep.spr_y;
			for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) { ++elements[elements_j].ele_y; }
			}
		else if (sprite_beepbeep.spr_y > 81 && (joy & JOY_DOWN)) { 
			--foreground_y; 
			--sprite_coyote.spr_y;
			--sprite_beepbeep.spr_y;
			for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) { --elements[elements_j].ele_y; }
			}

		SCBX(MAP01) = foreground_x;
		SCBY(MAP01) = foreground_y;
		}
		
	DrawSprite(BACK01);
	}

/*
*******************************************************************************
 *  initialization
 *******************************************************************************
 */

void initialize_variables() {
	
	joy = 0;
	
 	InitIRQ();
 	InstallIRQ(2, VBL);
 	EnableIRQ(2);
	CLI;
	
	InstallIRQ(0,HBL);
	EnableIRQ(0);

	sprsys = _sprsys |= 0xc0;
	
	_SetRGB(intro_pal);
	
	SetBuffers(0xa000, 0xc000, 0);
	
	cache_beepbeep.entry = 0;
	cache_beepbeep.block = 0;
	cache_beepbeep.offset = 0;
	
	getFile(&fpos[ID_BEEPBEEP_STAND], &cache_beepbeep);
	
	sprite_beepbeep.spr_b0 = 0xc5;
	sprite_beepbeep.spr_b1 = 0x18;
	sprite_beepbeep.spr_b2 = 0x20;
	sprite_beepbeep.spr_next = 0;
	sprite_beepbeep.spr_bitmap = cache_beepbeep.address;
	sprite_beepbeep.spr_x = 50;
	sprite_beepbeep.spr_y = 60;
	sprite_beepbeep.spr_sizex = 0x100;
	sprite_beepbeep.spr_sizey = 0x100;
	sprite_beepbeep.spr_palette[0] = 0x01;
	sprite_beepbeep.spr_palette[1] = 0x23;
	sprite_beepbeep.spr_palette[2] = 0x45;
	sprite_beepbeep.spr_palette[3] = 0x67;
	sprite_beepbeep.spr_palette[4] = 0x89;
	sprite_beepbeep.spr_palette[5] = 0xab;
	sprite_beepbeep.spr_palette[6] = 0xcd;
	sprite_beepbeep.spr_palette[7] = 0xef;
	sprite_beepbeep.spr_d = DIRECTION_LEFT;
	sprite_beepbeep.spr_anim = 0;
	sprite_beepbeep.spr_state = STATE_NORMAL;
	sprite_beepbeep.spr_act = ACT_NOTHING;
	sprite_beepbeep.spr_id = ID_BEEPBEEP_STAND;
	
	cache_coyote.entry = 0;
	cache_coyote.block = 0;
	cache_coyote.offset = 0;
	
	getFile(&fpos[ID_COYOTE_STAND], &cache_coyote);
	
	sprite_coyote.spr_b0 = 0xc5;
	sprite_coyote.spr_b1 = 0x18;
	sprite_coyote.spr_b2 = 0x20;
	sprite_coyote.spr_next = 0;
	sprite_coyote.spr_bitmap = cache_coyote.address;
	sprite_coyote.spr_x = 110;
	sprite_coyote.spr_y = 60;
	sprite_coyote.spr_sizex = 0x100;
	sprite_coyote.spr_sizey = 0x100;
	sprite_coyote.spr_palette[0] = 0x01;
	sprite_coyote.spr_palette[1] = 0x23;
	sprite_coyote.spr_palette[2] = 0x45;
	sprite_coyote.spr_palette[3] = 0x67;
	sprite_coyote.spr_palette[4] = 0x89;
	sprite_coyote.spr_palette[5] = 0xab;
	sprite_coyote.spr_palette[6] = 0xcd;
	sprite_coyote.spr_palette[7] = 0xef;
	sprite_coyote.spr_d = DIRECTION_LEFT;
	sprite_coyote.spr_anim = 0;
	sprite_coyote.spr_state = STATE_NORMAL;
	sprite_coyote.spr_act = ACT_NOTHING;
	sprite_coyote.spr_id = ID_COYOTE_STAND;
	
	SCBNEXT(SCB_helico2) = 0;
	SCBNEXT(SCB_helico3) = 0;
	SCBNEXT(SCB_helico4) = 0;
	
	for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) { elements_ini(elements_j); }

	load_buffer_intro();
	}

/*
*******************************************************************************
 *  main
 *******************************************************************************
 */

char *scb_start;
char *scb_current;
char *scb_next;
char *scb_last;
int scb_current_y;
int scb_next_y;

uchar ingame = 0;
uchar intro_j = 0;
uchar intro_k = 0;

void intro_set_xy(scb_ptr, scb_dec_y) char *scb_ptr; uchar scb_dec_y; {
	--SCBX(scb_ptr); 
	if (SCBX(scb_ptr) < -170) { SCBX(scb_ptr) = 170; }
	
	SCBY(scb_ptr) = (45 - (sinus[(sprite_beepbeep.spr_anim + scb_dec_y) % 256] >> 2));
	}

void main() {
	
	initialize_variables();
	
	for (elements_i = 0; elements_i < ELEMENT_NB; ++elements_i) { elements_new(); }
	
	while(1) {
		
		if (ingame > 0) {
			
		  background_set();

			switch (pursuit_mode) {
				case 0: coyote_set_sprite_run(); break;
				case 1: coyote_set_sprite_skate(); break;
				case 2: coyote_set_sprite_boink(); break;
				case 3: coyote_set_sprite_rocket(); break;
				case 4: coyote_set_sprite_helico(); break;
				}
			beepbeep_set_sprite();
			elements_set_state();
			
			getFile(&fpos[sprite_beepbeep.spr_id], &cache_beepbeep);
			if (sprite_beepbeep.spr_d == DIRECTION_INVERSE) { sprite_beepbeep.spr_b0 |= 0x20; } else { sprite_beepbeep.spr_b0 &= 0xdf; }
			
			sprite_beepbeep.spr_bitmap = cache_beepbeep.address;
			
			getFile(&fpos[sprite_coyote.spr_id], &cache_coyote);
			if (sprite_coyote.spr_d == DIRECTION_INVERSE && !(sprite_coyote.spr_state & STATE_FALLING)) { sprite_coyote.spr_b0 |= 0x20; } else { sprite_coyote.spr_b0 &= 0xdf; }
			
			sprite_coyote.spr_bitmap = cache_coyote.address;
			
		  elements[0].ele_next = 0;
			scb_start = &elements[0];
			
			for (elements_i = 1; elements_i < ELEMENT_NB; ++elements_i) {
				elements[elements_i].ele_next = 0;
				
				scb_current = &elements[elements_i];
				scb_current_y = SCBY(scb_current);
				
				scb_next = scb_start;
				scb_next_y = SCBY(scb_next);
				scb_last = scb_start;
				
				while (scb_current_y >= scb_next_y) {
					scb_last = scb_next;
					scb_next = SCBNEXT(scb_next);
					if (scb_next) { scb_next_y = SCBY(scb_next); } else { break; }
					}
				
				if (scb_next == scb_start) {
					SCBNEXT(scb_current) = scb_start;
					scb_start = scb_current;
					}
				else {
					SCBNEXT(scb_last) = scb_current;
					SCBNEXT(scb_current) = scb_next;
					}
				}
			
			if (sprite_beepbeep.spr_state & STATE_FALLING) {}
			else {
				sprite_beepbeep.spr_next = 0;
				
				scb_current_y = sprite_beepbeep.spr_y; 
				
				scb_next = scb_start;
				scb_next_y = SCBY(scb_next);
				scb_last = scb_start;
				
				while (scb_current_y >= scb_next_y) {
					scb_last = scb_next;
					scb_next = SCBNEXT(scb_next);
					if (scb_next) { scb_next_y = SCBY(scb_next); } else { break; }
					}
				
				if (scb_next == scb_start) {
					sprite_beepbeep.spr_next = scb_start;
					scb_start = &sprite_beepbeep;
					}
				else {
					SCBNEXT(scb_last) = &sprite_beepbeep;
					sprite_beepbeep.spr_next = scb_next;
					}
				}

			if (sprite_coyote.spr_state & STATE_FALLING) {}
			else if (pursuit_mode == 4) {
				scb_next = scb_start;
				while (scb_next) {
					scb_last = scb_next;
					scb_next = SCBNEXT(scb_next);
					}
				SCBNEXT(scb_last) = &sprite_coyote;
				}
			else {
				sprite_coyote.spr_next = 0;
				
				scb_current_y = sprite_coyote.spr_y; 
				
				scb_next = scb_start;
				scb_next_y = SCBY(scb_next);
				scb_last = scb_start;
				
				while (scb_current_y >= scb_next_y) {
					scb_last = scb_next;
					scb_next = SCBNEXT(scb_next);
					if (scb_next) { scb_next_y = SCBY(scb_next); } else { break; }
					}
				
				if (scb_next == scb_start) {
					sprite_coyote.spr_next = scb_start;
					scb_start = &sprite_coyote;
					}
				else {
					SCBNEXT(scb_last) = &sprite_coyote;
					sprite_coyote.spr_next = scb_next;
					}
				}
			
			SCBNEXT(STARTSPR) = scb_start;
			DrawSprite(STARTSPR);
			
			VSYNC;
			SwapBuffers();
			
			test_capture();
			test_elements_with_beepbeep();
			test_elements_with_coyote();
			
			joy = joystick;
			if (joy & BUTTON_OPTION1) {
				++pursuit_mode;
				if (pursuit_mode > 4) { pursuit_mode = 0; }
				sprite_coyote.spr_anim = 0;
				sprite_coyote.spr_act = ACT_NOTHING;
				sprite_coyote.spr_next = 0;
				WaitButton();
				}
			else if (joy & BUTTON_OPTION2) {
				sprite_beepbeep.spr_x = 50;
				sprite_beepbeep.spr_y = 60;
				sprite_beepbeep.spr_state &= !STATE_CAUGHT;
				
				sprite_coyote.spr_x = 110;
				sprite_coyote.spr_y = 60;

				foreground_x = FOREGROUND_START_X;
				foreground_y = FOREGROUND_START_Y;
				
				SCBX(MAP01) = foreground_x;
				SCBY(MAP01) = foreground_y;
				
				for (elements_j = 0; elements_j < ELEMENT_NB; ++elements_j) { elements_die(elements_j); }
				}
			}
		else {
			
			++sprite_beepbeep.spr_anim; if (sprite_beepbeep.spr_anim > 250) { sprite_beepbeep.spr_anim = 0; }
	   
		  intro_set_xy(INTRO_THE, 16);
		  intro_set_xy(INTRO_RETURN, 32);
		  intro_set_xy(INTRO_OF, 48);
		  intro_set_xy(INTRO_THES, 64);
		  intro_set_xy(INTRO_SPACE, 80);
		  intro_set_xy(INTRO_COYOTE, 96);
						
			DrawFBox(0, 0, 160, 102, 0); // 8
			DrawSprite(INTRO_THE);
			VSYNC;
			SwapBuffers();
			
			joy = joystick;
			if (joy) {
				DisableIRQ(0);
				ingame = 1;
				load_buffer_background();
				sprite_beepbeep.spr_anim = 0;
				_SetRGB(ingame_pal);
				}
			}    
		}
	}





