/*
 * sprites (structure start is SCB)
 */

// Bug in cc65? Needs real code before C++ comments occur?

extern char STARTSPR[];

extern char INTRO_THE[];
extern char INTRO_RETURN[];
extern char INTRO_OF[];
extern char INTRO_THES[];
extern char INTRO_SPACE[];
extern char INTRO_COYOTE[];
extern char INTRO_FACE[];

#asm

_STARTSPR dc.b $c5,$10,$20
          dc.w 0
          dc.w 0
          dc.w -1,-1
          dc.w $100,$100
          dc.b $01,$23,$45,$67,$89,$ab,$cd,$ef

_INTRO_THE			dc.b $45,$10,$20
								dc.w _INTRO_RETURN
								dc.w 0
								dc.w -1,-1
								dc.w $100,$100
								dc.b $0d,$7a,$00,$00,$00,$00,$00,$00

_INTRO_RETURN		dc.b $45,$18,$20
								dc.w _INTRO_OF
								dc.w 0
								dc.w -1,-1
								dc.w $100,$100

_INTRO_OF				dc.b $45,$18,$20
								dc.w _INTRO_THES
								dc.w 0
								dc.w -1,-1
								dc.w $100,$100

_INTRO_THES			dc.b $45,$18,$20
								dc.w _INTRO_SPACE
								dc.w 0
								dc.w -1,-1
								dc.w $100,$100

_INTRO_SPACE		dc.b $45,$18,$20
								dc.w _INTRO_COYOTE
								dc.w 0
								dc.w -1,-1
								dc.w $100,$100

_INTRO_COYOTE		dc.b $45,$18,$20
								dc.w _INTRO_FACE
								dc.w 0
								dc.w -1,-1
								dc.w $100,$100

_INTRO_FACE			dc.b $c5,$10,$20
								dc.w 0
								dc.w 0
								dc.w -1,-1
								dc.w $100,$100
								dc.b $01,$23,$45,$67,$89,$ab,$cd,$ef

#endasm

struct spriteInfo {
	uchar spr_b0;
	uchar spr_b1;
	uchar spr_b2;
	uint *spr_next;
	uint *spr_bitmap;
	int   spr_x;         // x-coord
	int   spr_y;         // y-coord
	int   spr_sizex;
	int   spr_sizey;
	uchar spr_palette[8];
	uchar spr_d;				 // direction
	uchar spr_anim;			 // animation
	uchar spr_state;		 // state
	uchar spr_act;			 // beepbeeping or getting
	uchar spr_id;				 // identity (depends on state & anim)
	};

struct elementInfo {
	uchar ele_b0;
	uchar ele_b1;
	uchar ele_b2;
	uint *ele_next;
	uint *ele_bitmap;
	int   ele_x;
	int   ele_y;
	int   ele_sizex;
	int   ele_sizey;
	uchar ele_type;
	uchar ele_anim;
	};

/*
 * constantes
 */

#define DIRECTION_NORMAL	1
#define DIRECTION_INVERSE	2
#define	DIRECTION_LEFT	1
#define	DIRECTION_RIGHT	2
#define	DIRECTION_DOWN	3
#define	DIRECTION_UP		4

#define ACT_NOTHING			0
#define ACT_MOCKING			1
#define ACT_BREAKING		2
#define ACT_JUMPING			3
#define ACT_DRINKING		4
#define ACT_BURNING			5

#define STATE_NORMAL		0x00
#define STATE_CAUGHT		0x01
#define STATE_STARVING	0x02
#define STATE_SMASHED		0x04
#define STATE_FIRED			0x08
#define STATE_FALLING		0x10

#define ID_BEEPBEEP_STAND				16
#define ID_BEEPBEEP_STAND_MOCK	17
#define ID_BEEPBEEP_RUN_1				0
#define ID_BEEPBEEP_RUN_2				1
#define ID_BEEPBEEP_RUN_3				2
#define ID_BEEPBEEP_RUN_MOCK_1	3
#define ID_BEEPBEEP_RUN_MOCK_2	4
#define ID_BEEPBEEP_RUN_MOCK_3	5
#define ID_BEEPBEEP_RUN_UP_1		10
#define ID_BEEPBEEP_RUN_UP_2		11
#define ID_BEEPBEEP_RUN_DOWN_1	12
#define ID_BEEPBEEP_RUN_DOWN_2	13
#define ID_BEEPBEEP_WALK_1			6
#define ID_BEEPBEEP_WALK_2			7
#define ID_BEEPBEEP_WALK_3			8
#define ID_BEEPBEEP_WALK_4			9
#define ID_BEEPBEEP_NOD_1				14
#define ID_BEEPBEEP_NOD_2				15
#define ID_BEEPBEEP_DRINK_1			18
#define ID_BEEPBEEP_DRINK_2			19
#define ID_BEEPBEEP_JUMP				20
#define ID_BEEPBEEP_BURN_1			21
#define ID_BEEPBEEP_BURN_2			22
#define ID_BEEPBEEP_BURN_3			23
#define ID_BEEPBEEP_BURN_4			24
#define ID_BEEPBEEP_BURN_5			25
#define ID_BEEPBEEP_BURN_6			26
#define ID_BEEPBEEP_BURN_7			27
#define ID_BEEPBEEP_BURN_8			28
#define ID_BEEPBEEP_BURN_9			29
#define ID_BEEPBEEP_HIT_1				30
#define ID_BEEPBEEP_HIT_2				31
#define ID_BEEPBEEP_HIT_3				32
#define ID_BEEPBEEP_CAUGHT			33

#define ID_COYOTE_RUN_1					34
#define ID_COYOTE_RUN_2					35
#define ID_COYOTE_RUN_3					36
#define ID_COYOTE_RUN_4					37
#define ID_COYOTE_RUN_GET_1			38
#define ID_COYOTE_RUN_GET_2			39
#define ID_COYOTE_RUN_GET_3			40
#define ID_COYOTE_BREAK_1				41
#define ID_COYOTE_BREAK_2				42
#define ID_COYOTE_DRINK_1				43
#define ID_COYOTE_DRINK_2				44
#define ID_COYOTE_DRINK_3				45
#define ID_COYOTE_EAT_1					46
#define ID_COYOTE_EAT_2					47
#define ID_COYOTE_STAND					48
#define ID_COYOTE_IDEA_2				49
#define ID_COYOTE_IDEA_3				50
#define ID_COYOTE_JUMP					51
#define ID_COYOTE_HELP					52
#define ID_COYOTE_SMASH					53
#define ID_COYOTE_BURN_1				54
#define ID_COYOTE_BURN_2				55
#define ID_COYOTE_BURN_3				56
#define ID_COYOTE_BURN_4				57
#define ID_COYOTE_BURN_5				58
#define ID_COYOTE_BURN_6				59
#define ID_COYOTE_BURN_7				60
#define ID_COYOTE_BURN_8				61
#define ID_COYOTE_BURN_9				62
#define ID_COYOTE_SKATE_1				63
#define ID_COYOTE_SKATE_2				64
#define ID_COYOTE_SKATE_GET_1		65
#define ID_COYOTE_SKATE_GET_2		66
#define ID_COYOTE_BOINK_1				67
#define ID_COYOTE_BOINK_2				68
#define ID_COYOTE_BOINK_GET_1		69
#define ID_COYOTE_BOINK_GET_2		70
#define ID_COYOTE_BOINK_DOWN_1	71
#define ID_COYOTE_BOINK_DOWN_2	72
#define ID_COYOTE_FLY						73
#define ID_COYOTE_FLY_DYNAMITE	74
#define ID_COYOTE_ROCKET_1			75
#define ID_COYOTE_ROCKET_2			76
#define ID_COYOTE_ROCKET_GET_1	77
#define ID_COYOTE_ROCKET_GET_2	78
#define ID_COYOTE_ROCKET_BEHIND_1		79
#define ID_COYOTE_ROCKET_BEHIND_2		80
#define ID_COYOTE_ROCKET_STAND_1		81
#define ID_COYOTE_ROCKET_STAND_2		82

/*
 *******************************************************************************
 *  SCB declarations
 *******************************************************************************
 */

extern char SCB_beepbeep[];
extern char SCB_coyote[];

extern char boink[];
extern char dynamite[];
extern char fire1[];
extern char fire2[];
extern char fire3[];
extern char fire4[];
extern char fire5[];
extern char fire6[];
extern char fire7[];
extern char fire8[];
extern char gunball1[];
extern char gunball2[];
extern char helico1[];
extern char helico2[];
extern char helico3[];
extern char helico4[];
extern char lemonade[];
extern char mine[];
extern char seed[];
extern char rock1[];
extern char rock2[];
extern char rock3[];
extern char rocket1[];
extern char rocket2[];
extern char van01[];
extern char van02[];
extern char van11[];
extern char van12[];
extern char van21[];
extern char van22[];
extern char van31[];
extern char van32[];

extern char SCB_element[];
extern char SCB_helico2[];
extern char SCB_helico3[];
extern char SCB_helico4[];

#asm

_SCB_helico2	   	  dc.b $c4,$18,$20
          					dc.w 0
          					dc.w _helico2
          					dc.w 64,64
          					dc.w $100,$100

_SCB_helico3	   	  dc.b $c4,$18,$20
          					dc.w 0
          					dc.w _helico3
          					dc.w 64,64
          					dc.w $100,$100

_SCB_helico4	   	  dc.b $c4,$18,$20
          					dc.w 0
          					dc.w _helico4
          					dc.w 64,64
          					dc.w $100,$100

#endasm


#define ELEMENT_NB				4

#define ELEMENT_SEED			1
#define ELEMENT_LEMONADE	2
#define ELEMENT_MINE			3
#define ELEMENT_VAN1			4
#define ELEMENT_VAN2			5
#define ELEMENT_VAN3			6
#define ELEMENT_VAN4			7
#define ELEMENT_ROCKET		8
#define ELEMENT_ROCK1			9
#define ELEMENT_ROCK2			10
#define ELEMENT_ROCK3			11
#define ELEMENT_GUNBALL		12
#define ELEMENT_DYNAMITE	13
