/*
 * cartridge reading functions
 */
 
// Bug in cc65? Needs real code before C++ comments occur?

extern char FileEntry[8];

struct fileCache {
	uchar entry;
	uchar block;
	int		offset;
	char  *address;
	char 	buffer[1024];
	};

struct fileLocation {
	uchar	fileEntry;		// with LoadCardDir(F)
	uchar	blockOffset;		// + N blocks of 1024
	int	byteOffset;		// + O bytes
	};

struct fileLocation fpos[83] = {
	{2,	0,	0},		// 270 bytes for sprites\brun1.spr
	{2,	0,	270},		// 264 bytes for #sprites\brun2.spr
	{2,	0,	534},		// 278 bytes for #sprites\brun3.spr
	{2,	1,	0},		// 274 bytes for #sprites\btongue1.spr
	{2,	1,	274},		// 266 bytes for #sprites\btongue2.spr
	{2,	1,	540},		// 278 bytes for #sprites\btongue3.spr
	{2,	2,	0},		// 258 bytes for #sprites\bwalk1.spr
	{2,	2,	258},		// 266 bytes for #sprites\bwalk2.spr
	{2,	2,	524},		// 264 bytes for #sprites\bwalk3.spr
	{2,	3,	0},		// 260 bytes for #sprites\bwalk4.spr
	{2,	3,	260},		// 252 bytes for #sprites\bback1.spr
	{2,	3,	512},		// 254 bytes for #sprites\bback2.spr
	{2,	4,	0},		// 262 bytes for #sprites\bfront1.spr
	{2,	4,	262},		// 264 bytes for #sprites\bfront2.spr
	{2,	4,	526},		// 252 bytes for #sprites\bnod1.spr
	{2,	5,	0},		// 252 bytes for #sprites\bnod2.spr
	{2,	5,	252},		// 254 bytes for #sprites\bmock1.spr
	{2,	5,	506},		// 254 bytes for #sprites\bmock2.spr
	{2,	6,	0},		// 304 bytes for #sprites\bdrink1.spr
	{2,	6,	304},		// 316 bytes for #sprites\bdrink2.spr
	{2,	6,	620},		// 336 bytes for #sprites\bjump1.spr
	{2,	7,	0},		// 272 bytes for #sprites\bburnin1.spr
	{2,	7,	272},		// 288 bytes for #sprites\bburnin2.spr
	{2,	7,	560},		// 286 bytes for #sprites\bburnin3.spr
	{2,	8,	0},		// 262 bytes for #sprites\bburnin4.spr
	{2,	8,	262},		// 254 bytes for #sprites\bburnin5.spr
	{2,	8,	516},		// 234 bytes for #sprites\bburnin6.spr
	{2,	8,	750},		// 236 bytes for #sprites\bburnin7.spr
	{2,	9,	0},		// 238 bytes for #sprites\bburnin8.spr
	{2,	9,	238},		// 228 bytes for #sprites\bburnin9.spr
	{2,	9,	466},		// 274 bytes for #sprites\bhit1.spr
	{2,	10,	0},		// 294 bytes for #sprites\bhit2.spr
	{2,	10,	294},		// 284 bytes for #sprites\bhit3.spr
	{2,	10,	578},		// 240 bytes for #sprites\bcaught1.spr
	{2,	11,	0},		// 244 bytes for #sprites\crun1.spr
	{2,	11,	244},		// 232 bytes for #sprites\crun2.spr
	{2,	11,	476},		// 238 bytes for #sprites\crun3.spr
	{2,	11,	714},		// 224 bytes for #sprites\crun4.spr
	{2,	12,	0},		// 232 bytes for #sprites\crun5.spr
	{2,	12,	232},		// 232 bytes for #sprites\crun6.spr
	{2,	12,	464},		// 224 bytes for #sprites\crun7.spr
	{2,	13,	0},		// 234 bytes for @sprites\cbreak1.spr
	{2,	13,	234},		// 234 bytes for #sprites\cbreak2.spr
	{2,	14,	0},		// 242 bytes for @sprites\cdrink1.spr
	{2,	14,	242},		// 242 bytes for #sprites\cdrink2.spr
	{2,	14,	484},		// 240 bytes for #sprites\cdrink3.spr
	{2,	15,	0},		// 276 bytes for @sprites\ceat1.spr
	{2,	15,	276},		// 282 bytes for #sprites\ceat2.spr
	{2,	16,	0},		// 254 bytes for @sprites\cidea1.spr
	{2,	16,	254},		// 308 bytes for #sprites\cidea2.spr
	{2,	16,	562},		// 302 bytes for #sprites\cidea3.spr
	{2,	17,	0},		// 226 bytes for @sprites\cjump1.spr
	{2,	17,	226},		// 402 bytes for #sprites\chelp1.spr
	{2,	17,	628},		// 94 bytes for #sprites\csmash1.spr
	{2,	18,	0},		// 268 bytes for @sprites\cburnin1.spr
	{2,	18,	268},		// 272 bytes for #sprites\cburnin2.spr
	{2,	18,	540},		// 280 bytes for #sprites\cburnin3.spr
	{2,	19,	0},		// 248 bytes for #sprites\cburnin4.spr
	{2,	19,	248},		// 248 bytes for #sprites\cburnin5.spr
	{2,	19,	496},		// 244 bytes for #sprites\cburnin6.spr
	{2,	19,	740},		// 244 bytes for #sprites\cburnin7.spr
	{2,	20,	0},		// 242 bytes for #sprites\cburnin8.spr
	{2,	20,	242},		// 234 bytes for #sprites\cburnin9.spr
	{2,	21,	0},		// 284 bytes for @sprites\cskate1.spr
	{2,	21,	284},		// 288 bytes for #sprites\cskate2.spr
	{2,	22,	0},		// 280 bytes for @sprites\cskate3.spr
	{2,	22,	280},		// 286 bytes for #sprites\cskate4.spr
	{2,	23,	0},		// 280 bytes for @sprites\cboink1.spr
	{2,	23,	280},		// 330 bytes for #sprites\cboink2.spr
	{2,	24,	0},		// 278 bytes for @sprites\cboink3.spr
	{2,	24,	278},		// 330 bytes for #sprites\cboink4.spr
	{2,	25,	0},		// 330 bytes for @sprites\cboink5.spr
	{2,	25,	330},		// 366 bytes for #sprites\cboink6.spr
	{2,	26,	0},		// 330 bytes for @sprites\chelico1.spr
	{2,	26,	330},		// 360 bytes for #sprites\chelico2.spr
	{2,	27,	0},		// 340 bytes for @sprites\crocket1.spr
	{2,	27,	340},		// 342 bytes for #sprites\crocket2.spr
	{2,	28,	0},		// 340 bytes for @sprites\crocket3.spr
	{2,	28,	340},		// 342 bytes for #sprites\crocket4.spr
	{2,	29,	0},		// 334 bytes for @sprites\crocket5.spr
	{2,	29,	334},		// 342 bytes for #sprites\crocket6.spr
	{2,	30,	0},		// 398 bytes for @sprites\crocket7.spr
	{2,	30,	398}		// 400 bytes for #sprites\crocket8.spr
	};

void getFile(fp, fc) struct fileLocation *fp; struct fileCache *fc; {

	if (fc->entry != fp->fileEntry) {

		fc->entry = fp->fileEntry;
		fc->block = fp->blockOffset;
		fc->offset = fp->byteOffset;
		fc->address = fc->buffer + fc->offset;

		LoadCartDir(fc->entry);
		LoadCartBlock(FileEntry[0] + fc->block, fc->buffer);
		}
	else if (fc->block != fp->blockOffset) {
		
		fc->block = fp->blockOffset;
		fc->offset = fp->byteOffset;
		fc->address = fc->buffer + fc->offset;
		
		LoadCartBlock(FileEntry[0] + fc->block, fc->buffer);
		}
	else if (fc->offset != fp->byteOffset) {
		
		fc->offset = fp->byteOffset;
		fc->address = fc->buffer + fc->offset;
		}
	}

char buffer_3k[3072];

void load_buffer_intro() {
	LoadCartDir(3);
	LoadCartBlock(FileEntry[0], buffer_3k);
	LoadCartBlock(FileEntry[0] + 1, buffer_3k + 1024);
	LoadCartBlock(FileEntry[0] + 2, buffer_3k + 2048);
	LoadCartDir(2);

	SCBDATA(INTRO_THE) = (buffer_3k + 1110);
	SCBX(INTRO_THE) = 170;
	SCBDATA(INTRO_RETURN) = (buffer_3k + 1332); 
	SCBX(INTRO_RETURN) = 210;
	SCBDATA(INTRO_OF) = (buffer_3k + 1714); 
	SCBX(INTRO_OF) = 279;
	SCBDATA(INTRO_THES) = (buffer_3k + 1110); 
	SCBX(INTRO_THES) = 303;
	SCBDATA(INTRO_SPACE) = (buffer_3k + 1890);
	SCBX(INTRO_SPACE) = 343;
	SCBDATA(INTRO_COYOTE) = (buffer_3k + 2232); 
	SCBX(INTRO_COYOTE) = 404;
	SCBDATA(INTRO_FACE) = buffer_3k; 
	SCBX(INTRO_FACE) = 20;
	SCBY(INTRO_FACE) = 28;
	}

void load_buffer_background() {

	LoadCartDir(4);
	LoadCartBlock(FileEntry[0], buffer_3k);
	LoadCartBlock(FileEntry[0]+ 1, buffer_3k + 1024);
	LoadCartBlock(FileEntry[0]+ 2, buffer_3k + 2048);
	LoadCartDir(2);
	
	SCBDATA(BACK01) = buffer_3k;
	SCBDATA(BACK02) = SCBDATA(BACK01);
	SCBDATA(BACK03) = SCBDATA(BACK01);
	SCBDATA(BACK04) = SCBDATA(BACK01);
	SCBDATA(MAP01) = buffer_3k + 972;

	SCBX(BACK01) = -160;
	SCBY(BACK01) = -102;
	SCBX(BACK02) = 0;
	SCBY(BACK02) = -102;
	SCBX(BACK03) = -160;
	SCBY(BACK03) = 0;
	SCBX(BACK04) = 0;
	SCBY(BACK04) = 0;
  }
