/***********************************************************
** Raycast-Project                                        **
** SPR_DATA.H                                             **
** 27.08.1998                                             **
***********************************************************/


/***********************************************************
SPRPCK-call:
bitmap has 32*32 pixels

SPRPCK -u -t6 -p0 -S001032 -r032001 -a001016 st.bmp

libr65 a st.olb st*.obj
***********************************************************/


extern uchar init_scb[23];
extern uchar spr0[15];
//extern uchar spr[80][15];
extern uchar* Sprites[32];

#asm

;_spr = $ff00-2*8160-80*15     ; Below the first screen

; Mit init_scb werden die SpriteEngine Register mit den allgemeingltigen Pen-Werten initialisiert
; dadurch knnen die einzelnen spr[] SCBs auf 15 Bytes verkrzt werden!
_init_scb:
         dc.b $c1, $90, $20
         dc.w init2_scb, dummy   ; ptrNext, ptrData
         dc.w 0, 0   ; x,y
         dc.w 160*$100, 52*$100  ; upper half of the screen + 1
         dc.b $01, $23,     $b5, $67, $89, $ab, $cd, $ef
init2_scb:
         dc.b $c1, $90, $20
         dc.w _spr, dummy        ; ptrNext, ptrData         
         dc.w 0, 52              ; lower half of the screen - 1
         dc.w 160*$100, 51*$100
         dc.b $01, $23,     $55, $67, $89, $ab, $cd, $ef

dummy:   dc.b 2,$40,0  ; One Pixel with pen index 4, because 0-3 are already used by the wall texture

_spr0:   dc.b $c1, $98, $00,  ; reuse existing palette
         dc.w 0, 0            ; ptrNext, ptrData
         dc.w 0, 0            ; x, y position
         dc.w $100, $100      ; x, y size



         xref _st000000, _st000001, _st000002, _st000003
         xref _st000004, _st000005, _st000006, _st000007
         xref _st000008, _st000009, _st000010, _st000011
         xref _st000012, _st000013, _st000014, _st000015

         xref _st000016, _st000017, _st000018, _st000019
         xref _st000020, _st000021, _st000022, _st000023
         xref _st000024, _st000025, _st000026, _st000027
         xref _st000028, _st000029, _st000030, _st000031

_Sprites: dc.w _st000000, _st000001, _st000002, _st000003
          dc.w _st000004, _st000005, _st000006, _st000007
          dc.w _st000008, _st000009, _st000010, _st000011
          dc.w _st000012, _st000013, _st000014, _st000015

          dc.w _st000016, _st000017, _st000018, _st000019
          dc.w _st000020, _st000021, _st000022, _st000023
          dc.w _st000024, _st000025, _st000026, _st000027
          dc.w _st000028, _st000029, _st000030, _st000031
#endasm
