/***********************************************************
** Raycast-Project                                        **
** RAYCAST.C                                              **
** 27.08.1998                                             **
***********************************************************/

#include <lynx.h>
#include <lynxlib.h>
#include <stdlib.h>
#include <joy.h>

#include "spr_data.h"

// The bitmap is 32*32 pixels
#define SCALE_H 2
#define SCALE_V 4

uchar SCREEN1[8160]       at (0xff00-2*8160); // screen 1
uchar SCREEN2[8160]       at (0xff00-1*8160); // screen 2
uchar spr[80][15]         at (0xff00-2*8160-80*15); // Below the screen 1

uchar frames;
char szOut[] = "1 frame/0 VBLs";


//#include "st.pal"
#include "raycast.pal"

/*****************************************************/
extern uchar VBLflag;
#asm
_VBLflag = $a0
#endasm

#define VSYNC {++VBLflag;while( VBLflag );}

VBL() interrupt
{
   VBLflag = 0; /* indicates that a VBL has ocurred */
   frames++;
}

HBL() interrupt
{
}
/*****************************************************/


main()
{
register uchar x,y,c;
register uchar joy;
register uchar x_pos;


   InitIRQ();
   InstallIRQ(2,VBL);
//   InstallIRQ(0,HBL);  /* Don't use HBL with SAMPLE.M65 */

   EnableIRQ(2); /* 42BS */
   CLI;          /* 42BS */


   SetBuffers(SCREEN1, SCREEN2, 0);

   _SetRGB(pal);

   frames = 0;
   c = 0;
   x_pos = 80/2;

   // Set up the 80 screen sprites
   for (x = 0; x < 80; ++x)
      {
      bcopy(&spr0[0], &spr[x][0], 15);  // src, dest, count

      SCBX(&spr[x][0]) = x*2;   // 80 sprites !!!
      SCBY(&spr[x][0]) = 102/2+1;

      SCBHS(&spr[x][0]) = SCALE_H*0x100;

      SCBNEXT(&spr[x][0]) = &spr[x][0] + 15; // daisy chain the sprites
      }
   SCBNEXT(&spr[80-1][0]) = 0;     // Terminate the sprite chain !!!


   DrawFBox(0,0,160,102, 4);  // Clear screen, will exchanged by parallax-background sprite
   VSYNC;
   SwapBuffers();

   //  main loop
   for(;;)
      {
      VSYNC;
      SwapBuffers();

      // Get the amount of vbls used to build a frame
      szOut[8] = '0' + frames;
      frames = 0;


/****************************************************************
old loop with focus in the mid of the screen
      for (x = 0; x < 80/2; ++x)
         {
         SCBVS(&spr[39 - x][0]) = SCALE_V*((0x100 * x)/(80/2));
         SCBVS(&spr[40 + x][0]) = SCALE_V*((0x100 * x)/(80/2));

         SCBDATA(&spr[39 - x][0]) = Sprites[     (c + x) % 32];
         SCBDATA(&spr[40 + x][0]) = Sprites[31 - (c + x) % 32];  // 31- : else the bitmap would look mirrored
         }
****************************************************************/
      for (x = 0; x < x_pos; ++x)
         {
         SCBVS(&spr[(x_pos-1) - x][0]) = SCALE_V*((0x100 * x)/(x_pos));

         SCBDATA(&spr[(x_pos-1) - x][0]) = Sprites[     (c + x) % 32];
         }

      for (x = 0; x < (80-x_pos); ++x)
         {
         SCBVS(&spr[x_pos + x][0]) = SCALE_V*((0x100 * x)/(80-x_pos));

         SCBDATA(&spr[x_pos + x][0]) = Sprites[31 - (c + x) % 32];  // 31- : else the bitmap would look mirrored
         }


      DrawSprite(init_scb);

      TextOut2(80-7*8, 0, 6, 0, szOut);

      joy = joystick;

      if (joy & JOY_UP)
         c -= 2;

      if (joy & JOY_DOWN)
         c += 2;

      if (joy & JOY_LEFT)
         if (x_pos > 0)
            x_pos -= 2;

      if (joy & JOY_RIGHT)
         if (x_pos < 80-2)
            x_pos += 2;


      } // for ever
}
