#include "sprpck.h"

extern BYTE rgb[];
extern BYTE CollRedirect[];

BYTE *original = NULL;		/* ptr to the complete converted file */
int org_w;
int org_h;					/* original size */

/*
  prototypes
*/

  void  error(int line,char *w, ...);
  void  SaveRGB(char *filename,BYTE *data,int type,int size,int line);
  void  SaveSprite(char *filename,BYTE *data,int len,int line,int type);
  long  LoadFile(char *filename,BYTE **adr);
  long  ConvertFile(BYTE *in,long in_size,int type,int *in_w,int *in_h,int line);

/*******************************************************************/


long ConvertPCX(BYTE * in,long in_size,int *in_w, int *in_h,int line)
    {
    BYTE shifter,i;
    BYTE r,g,b;
    BYTE byte,*pByte,*help;
    int count,count_bpl,x,y,count_planes;
	int bpp,bpl,planes;
    long new_size;
    long save_insize = in_size;

    if ( *in != 10 || *(in+PCX_VERSION) != 5 || *(in+PCX_ENC) != 1)
      error(line,"No or unsupported PCX-file !\r\n");

    (*in_w) = org_w = BLINTEL(in,PCX_XMAX)-BLINTEL(in,PCX_XMIN) +1 ;
    (*in_h) = org_h = BLINTEL(in,PCX_YMAX)-BLINTEL(in,PCX_YMIN) +1 ;

    planes = *(in+PCX_PLANES);

    bpp = (int) *(in+PCX_BPP) ;
    bpl = BLINTEL(in,PCX_BPL) ;

    if ( !((planes == 1 && bpp == 8) || (planes == 4 && bpp == 1) ))
      error(line,"No or unsupported PCX-file !\r\n");

    new_size = (long) ( org_w * org_h)  ;

    if ( (original = malloc(new_size)) == NULL)
      error(line,"Not enough memory for original pcx!");


    if (verbose)
      printf("PCX-size : w = %d h = %d (%d) \r\n",org_w,org_h,bpp);

    pByte = in+PCX_RGB;
    help = rgb;

    for (x = 16 ; x ; --x)
    {
      r = (*pByte++) >> 4; /* red */
      g = (*pByte++) >> 4; /* green */
      b = (*pByte++) >> 4; /* blue */
      *help++ = g;
      *help++ = ( b<<4 ) | r;
    }

    help  = original;
    pByte = in+PCX_DATA;

    if ( bpp == 8)
    {
      x = org_w+1;
      count_bpl = bpl;
      in_size = new_size;
      while (in_size > 0)
      {
        if ( ((byte = *pByte++) & 0xc0 )== 0xc0 )
        {
          count = byte & 0x3f;
          byte = *pByte++;
          do{
            if ( x-- ) { *help++ = byte & 15; --in_size; }
            --count_bpl;
            if ( ! count_bpl ) { x = org_w+1;  count_bpl = bpl; }
          }while (--count);
        }
        else
        {
          if ( x-- ) { *help++ = byte & 15; --in_size; }
          --count_bpl;
          if ( !count_bpl ) { x = org_w+1; count_bpl = bpl; }
        }
      } /*while*/
      if ( pByte != in+save_insize )
      {
        pByte = in+save_insize-16*3;
        help = rgb;
    
        for (x = 16 ; x ; --x)
        {
          r = (*pByte++) >> 4; /* red */
          g = (*pByte++) >> 4; /* green */
          b = (*pByte++) >> 4; /* blue */
          *help++ = g;
          *help++ = ( b<<4 ) | r;
        }
        if (verbose) printf("PCX: using palette at the end of file !\r\n");
      }      
    }
    else  /* 1bit / 8 planes */
    {
      for ( y = org_h; y ; --y, help += org_w) {
	  
        for (i = org_w ; i ; --i) { *(help+i) = 0; }

        for (count_planes = planes, shifter = 1; count_planes; --count_planes, help -= org_w, shifter <<=1) {

          for ( x = org_w ; x ; ) {
		  
            if ( ( (byte = *pByte++) & 0xc0 ) == 0xc0 ) { 
                
				count = byte & 0x3f;
                byte = *pByte++;
                
				do {
                  for (i = 0x80; x && i; i>>=1, --x) {
                    if  (byte & (BYTE)i) { *help |= shifter; }
					help++;
					}
                  --count;
                  }
				while ( count );
                }
              else { 
                for (i = 0x20; x && i ; i>>=1, --x) {  
				  if  (byte & (BYTE)i) { *help |= shifter; }
				  help++;
				  }
                } 
             }
		  }   
       }/*for (y ..*/
    }
    
   help = original;

   for (in_size = new_size ; in_size ; --in_size) { *help++ &=15; }

   free(in);
   return ( new_size );
}
/************************/
/* main conversion-loop */
/************************/
long ConvertFile(BYTE *in,
								 long in_size,
								 int type,
                 int *in_w,int *in_h,
                 int line)
{
  BYTE *pByte = NULL,*pByte2;
  long new_size = 0;


  switch (type)
  {
  case TYPE_RAW1:
    {
    int bit;
    signed char byte;

    new_size = in_size << 3;
    
    if ( (original = malloc(new_size)) == NULL)
      error(line,"Not enough memory for raw data!");
      
    pByte = original;
    pByte2 = in;
    while (in_size)
    {
      byte = *pByte2++;
      for (bit = 8 ; bit ; byte <<= 1 , --bit )
        *pByte++ = (byte < 0) ? 1 : 0;
        
      --in_size;
    }
    }
    org_w = (*in_w);
    org_h = (*in_h);
    free(in);
    break;

  case TYPE_RAW4:
    new_size = in_size<<1;
    if ( (original = malloc(new_size)) == NULL)
      error(line,"Not enough memory for raw data!");
      
    pByte  = original;
    pByte2 = in;
    
    while (in_size)
    {
      *pByte++ = (*pByte2)>>4;
      *pByte++ = (*pByte2++) & 0xf;
      --in_size;
    }
    org_w = (*in_w);
    org_h = (*in_h);
    free(in);
    break;
    
  case TYPE_RAW8:
    original = in;
    new_size = in_size;
    org_w = (*in_w);
    org_h = (*in_h);
    break;
    
  case TYPE_SPS:
    pByte = original = in;
    
    while (in_size)
    {
      BYTE b = *in++;
      --in_size;
      
      if ( b < ' ' ) continue; /* skip LF and CR */
      if ( ' ' == b )
      {
        b = 0;      }
      else if (('0' <= b) && (b <= '9'))
      {
        b = b - '0';
      }
      else if (('A' <= b) && (b <= 'F'))
      {        
      	b = b - 'A' + 10;
      }
      else if (('a' <= b) && (b <= 'f'))
      {
        b = b - 'a' + 10;
      }
        
      *pByte++ = b;
      ++new_size;
    }
    org_w = (*in_w);
    org_h = (*in_h);
    break;
    
  case TYPE_PCX:
    new_size = ConvertPCX(in,in_size,in_w,in_h,line);
    break;

  case TYPE_PI1:
    {
      int i,o;
/*    USHORT *puShort; */
      
	  (*in_w) = org_w = 320;
	  (*in_h) = org_h = 200;

      original = malloc(new_size = 64000l);
    
      pByte2= in + 2;  /* skip first 2 bytes */

	  pByte = rgb;	    

      for ( i = 15; i >= 0 ; --i)
      {
        register BYTE r,g,b;

        if ( (r = (((*pByte2++) & 0x07) << 1)) != 0) {++r;}
        if ( (g = (((*pByte2)   & 0x70) >> 3)) != 0) {++g;}
        if ( (b = (((*pByte2++) & 0x07) << 1)) != 0) {++b;}

	/* printf("r %x g %x b %x \r\n",r,g,b); */

        *pByte++ = g;
        *pByte++ = (b<<4) | r;
      }
  
  /*	  puShort = (USHORT *)pByte2;     */
  	  
      pByte = original-16;
	      
      for ( i = 3999; i >= 0 ; --i)
      {
	register USHORT w0,w1,w2,w3;

	w3 = *((USHORT *)pByte2)++;
	w2 = *((USHORT *)pByte2)++;
	w1 = *((USHORT *)pByte2)++;
	w0 = *((USHORT *)pByte2)++;     
#ifdef i386
	w3 = (w3<<8)|(w3>>8); /* swap byte-order */
	w2 = (w2<<8)|(w2>>8); /* hey, gcc knows rorw !!! */
	w1 = (w1<<8)|(w1>>8);
	w0 = (w0<<8)|(w0>>8);
#endif
	pByte += 32;

	for ( o = 15 ; o >= 0 ; --o )
	{
	  *--pByte = ((w0&1)<<3) | ((w1&1)<<2) | ((w2&1)<<1) | (w3&1);
	  w0 >>= 1;
	  w1 >>= 1;
 	  w2 >>= 1;
	  w3 >>= 1;
	}
      } 
    }
    break;

 } /*switch*/
 

 return ( new_size );
}
 
BYTE* HandleOffset(BYTE * original,
           			 int *in_w,int *in_h,
                 int off_x,int off_y,
                 int line)
{
	BYTE *help,*help1,*modified;
	int x,y;
	
	if ( (modified = malloc( ((long)(*in_w))*((long)(*in_h)) ) ) == 0)
	  error(line,"Out of memory (HandleOffset) !");
	

  help  = modified;
    
  help1 = original + off_y * (*in_w);
 
  (*in_h) -= off_y;
  (*in_w) -= off_x;

  for ( y = *in_h ; y ; --y)
  {
    help1 += off_x;
    for ( x = *in_w ; x ; --x)
      *help++ = *help1++;
  }

  return (modified);
}

long LoadFile(char fn[],BYTE **ptr)
{
  long len;
  int f;

  if ((f = open(fn,O_RDONLY | O_BINARY)) >= 0)
  {
    len = lseek(f,0L,SEEK_END);
    lseek(f,0L,SEEK_SET);
    if ( ( *ptr=malloc(len) ) == NULL)
      return 0;
#ifdef DEBUG
  printf("filesize: %lu\r\n", len);
#endif
    len  = read(f,*ptr,len);
#ifdef DEBUG
      /*printf("sizeof(int): %u\r\n", sizeof(int));*/
      printf("bytes read: %lu\r\n", len);
#endif
    close(f);
    if (verbose) printf("Read: %s \r\n",fn);

    return (len);
  }else
    return 0;
}

void SaveRGB(char *filename,BYTE *pal,int type,int size,int line)
{
  int i;
  FILE *f;
  BYTE *pal2 = pal+1,g,br;
  BYTE *pCollRedirect = CollRedirect;
  
  if ( (f = fopen(filename,"w") ) == NULL)
    error(line,"Couldn't write color-table !\r\n");  
  switch (type){
  case C_HEADER:
  
    fprintf(f,"char redir[]={");
    for (i = 1<<(size-1) ; i ; --i)
    { 
      g = *pCollRedirect++;
      br = *pCollRedirect++;
      fprintf(f,"0x%02X",(g<<4)|br);
      if (i > 1)
        putc(',',f);
    }

    fprintf(f,"};\nchar pal[]={\n\t");
    for (i = 16 ; i ; --i , pal += 2)
      fprintf(f,"0x%02X,",(int)*pal);
    fprintf(f,"\n\t");
    for (i = 16 ; i ; --i , pal2 += 2)
      if ( i > 1 )
        fprintf(f,"0x%02X,",(int)*pal2);
      else
        fprintf(f,"0x%02X};\n",(int)*pal2);

    break;
    
  case ASM_SRC:
    fprintf(f,"redir:\tdc.b ");
    for (i = 1<<(size-1) ; i ; --i)
    { 
      g = *pCollRedirect++;
      br = *pCollRedirect++;
      fprintf(f,"$%02X",(g<<4)|br);
      if (i > 1)
        putc(',',f);
    }
    fprintf(f,"\npal:\tdc.b ");
    for (i = 16; i ; --i , pal += 2)
      if ( i > 1 ) fprintf(f,"$%02X,",(int)*pal);
    else
      fprintf(f,"$%02X\r\n\tdc.b ",(int)*pal);
      
    for (i = 16; i ; --i , pal2 += 2)
      if ( i > 1 ) fprintf(f,"$%02X,",(int)*pal2);
    else
      fprintf(f,"$%02X\n",(int)*pal2);
      
    break;
  case LYXASS_SRC:
    fprintf(f,"redir:\tdc.b ");
    for (i = 1<<(size-1) ; i ; --i)
    { 
      g = *pCollRedirect++;
      br = *pCollRedirect++;
      fprintf(f,"$%02X",(g<<4)|br);
      if (i > 1)
        putc(',',f);
    }

    fprintf(f,"\npal:\tDP ");
    for (i = 16; i ; --i)
    { g = *pal++; br = *pal++;
      if ( i > 1 )
        fprintf(f,"%X%02X,",g,br);
      else
        fprintf(f,"%X%02X\n",g,br);
    }
    break;
  }/*switch*/
      
  fclose(f);
  if (verbose)
    printf("%s written.\r\n",filename);
}

void SaveSprite(char *filename,BYTE *ptr,int size,int line,int type)
{
  if ( type != C_HEADER )
  {
    int handle;
     
    if ( (handle = open(filename,O_CREAT | O_TRUNC | O_BINARY | O_RDWR, 0644)) <0 )
    {
      error(line,"Couldn't open %s for writing !\r\n",filename);
    }

    if ( write(handle,ptr,size) != size )
      error(line,"Couldn't write %s !\r\n",filename);
    close(handle);
  }
  else
  {
    FILE * out;
    char label[34] = "_";
    int i,o,segdata;
    char * dot;
    
    if ( (out = fopen(filename,"wb")) == NULL )
	error(line,"Couldn't open %s !\r\n",filename);

    dot = strrchr(filename,'.');
    *dot = 0;
    strcat(label,filename);
    *dot = '.';
    
    segdata = size + ((size+0x1f) >> 5 );
    
    putc(0xfd,out); putc(0xfd,out);  /*magic*/
    putc(7+(char)strlen(label),out); /*symbol-struct-len low*/
    putc(0,out);                     /*symbol-struct-len high*/
    putc(size & 0xff,out);            /*data-len low*/
    putc(size>>8,out);                /*data-len high*/
    putc(segdata & 0xff,out);        /*seg-len low*/
    putc(segdata>>8,out);            /*seg-len high*/
    putc(1,out);                     /*symbols low*/
    putc(0,out);                     /*symbols high*/
    putc((char)strlen(label),out);
    fprintf(out,"%s",label);
    putc(0,out); putc(0,out);        /*symbol pos 0 rel to seg-start*/
    putc(7,out); putc(0,out);        /*symbol flag = rel to seg-start*/

    for (i = size>>5; i ; --i)
    {
      putc(0,out);
      for (o = 32; o ; --o ) { putc(*ptr++,out); }
    }
    if ( (i = (size & 0x1f)) != 0)
    {
      putc(i,out);
      for ( ; i ; --i) { putc(*ptr++,out); }
    }
    fclose(out);
  }

   if (verbose)
     printf("Written: %s \r\n--------------------------\r\n",filename);
}

void error(int line,char *f,...)
{
  va_list argp;
  
  va_start(argp,f);
  printf("Error (%d):",line);
  printf(f,va_arg(argp,char *) );
  va_end(argp);
#ifdef ATARI
  while (getc(stdin) != ' ');
#endif
  exit(-1);
}



int ReadRGB(char *filename,BYTE *palinput)
{
	int i;
    char string[256];
	/*char *pdest;*/
	int col[32];	/* Thge read Lynx-GBR-palette */

	FILE *stream;

	if( (stream = fopen( filename, "r" )) == NULL )
	{
		printf("Can't open pal-input file: %s\r\n", filename);
		return 0;
	}

	while (fgets( string, 255, stream ))
	{
		if ((strstr( string, "pal[]={" )))
		{
			fgets( string, 255, stream );
			/*printf( "%s", string); */
			sscanf(string, "%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x",
			&col[ 0],&col[ 1],&col[ 2],&col[ 3],&col[ 4],&col[ 5],&col[ 6],&col[ 7],
			&col[ 8],&col[ 9],&col[10],&col[11],&col[12],&col[13],&col[14],&col[15]);
			/*for (i=0; i<16; i++)*/
			/*	printf("%x,", col[i]);*/
			printf("\r\n");


			fgets( string, 255, stream );
			/*printf( "%s", string);*/
			sscanf(string, "%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x",
			&col[16+ 0],&col[16+ 1],&col[16+ 2],&col[16+ 3],&col[16+ 4],&col[16+ 5],&col[16+ 6],&col[16+ 7],
			&col[16+ 8],&col[16+ 9],&col[16+10],&col[16+11],&col[16+12],&col[16+13],&col[16+14],&col[16+15]);
			/*for (i=0; i<16; i++)*/
			/*	printf("%x,", col[16+i]);*/
			printf("\r\n");

		}

	}
	fclose( stream );

	for (i=0; i<16; i++)
	{
		*palinput++ = col[i];	/* green */
		*palinput++	= col[16+i]; /* blue + red */
	}
	
	
	return 1;
}
