#include <stdio.h>
#include <string.h>
#include "head.h"
#include "tail.h"
#include "uploadheader.h"

#include <unistd.h>
#define READFLAGS "r"
#define WRITEFLAGS "w"

short get_blk_size(FILE *fp) {
    unsigned char buf[64];

    fread(buf, 1, 64, fp);
    if (strcmp(buf,"LYNX")) {
        rewind(fp);
        return 1024;
		}
    
	return ((short *)(buf))[2];
	}


int main(int argc, char *argv[]) {

    int i, j, blk_size;
    int blk_start = 0;
    int to_files = 0;
    int pass;

    FILE *fout = NULL;
    FILE *fin = NULL;
    FILE *fin2 = NULL;
    unsigned char buf[2048];
    char *out_dev = NULL;

    i = 1;
    while (i < argc) {
        if (!strcmp(argv[i], "-u")) { 
			blk_start = 16;
			}
        else if (!strcmp(argv[i], "-f")) {
            to_files = 1;
            out_dev = NULL;
			}
		else if (!strcmp(argv[i], "-c")) {
            to_files = 2;
            out_dev = NULL;
			}
		else if (!strcmp(argv[i], "-d")) {
            to_files = 0;
            out_dev = argv[i+1];
            i++;
			}
		else if (!fin) { 
			fin = fopen(argv[i], READFLAGS);
			}
        else if (!fin2) {
			fin2 = fopen(argv[i], READFLAGS);
			}
		i++;
		}
    
	if (!fin) {
        fprintf(stderr, "Usage: %s [-u] [-f] [-d device] file1 [file2]\n", argv[0]);
        fprintf(stderr, "  -u burns the upper part of a 512k game. You have to flip S6 OFF.\n");
        fprintf(stderr, "  -f creates separate files 00.o instead of stdout.\n");
        fprintf(stderr, "  -c creates copy-able separate files 00.o instead of stdout.\n");
        fprintf(stderr, "  -d use a specific device for output.\n");
        fprintf(stderr, "  Remember to flip S8 and S7 ON to burn the image.\n");
        return 1;
		}
		
    blk_size = get_blk_size(fin);
    
	if (fin2 && ((blk_size != get_blk_size(fin2)) || (blk_size != 512))) {
        fprintf(stderr, "Block size problems.\n");
        return 1;
		}
		
    for (pass = 0; pass < (((blk_size>1024) && to_files)?2:1); pass++) {
        if (pass==1) { blk_start = 16; }
        for (i = blk_start; i < blk_start + 16; i++) {
            if (to_files) {
                sprintf(buf, "%02x.o", i);
                fout = fopen(buf, WRITEFLAGS);
                if (to_files == 1) {
                    fwrite(head, 1, head_len, fout);
					}
                else {
                    fwrite(uploadheader, 1, uploadheader_len, fout);
                    fwrite(head+10, 1, head_len-10, fout);
					}
				}
			else {
                fout = out_dev ? fopen(out_dev, WRITEFLAGS) : stdout;
                
				fwrite(uploadheader, 1, uploadheader_len, fout);
				fwrite(head+10, 1, head_len-10, fout);
                }
            
			*(short *)buf = (i - blk_start)<<4;
			
			fwrite(buf, 1, 2, fout);
            for (j = 0; j < 16; j++) {
                memset(buf, 0xff, 2048);
                fread(buf, 1, blk_size, fin);
                if (fin2) fread(buf+blk_size, 1, blk_size, fin2);
				fwrite(buf+(blk_start<<6), 1, 1024, fout);
				}
			fwrite(tail, 1, tail_len, fout);
            
			if (to_files) {
                fclose(fout);
				}
            else {
                sleep(i?20:10);
				}
			}
        rewind(fin);
        get_blk_size(fin);
		}
    
	fclose(fin);
    if (fin2) fclose(fin2);
    if (out_dev) { fclose(fout); }
	
    return 0;
	}

