
#include <ldg.h>

#include "zlib.h"

/* prototypages */

const char* CDECL get_version();
const char* CDECL get_info();
const char* CDECL get_error(int err);
unsigned long CDECL get_compil_flags();
unsigned long CDECL get_sizeof_stream_struct();

int   CDECL raw_deflate_init (z_stream *strm, int level); 
int   CDECL raw_deflate      (z_stream *strm, int flush); 
int   CDECL raw_deflate_end  (z_stream *strm); 

int   CDECL raw_inflate_init (z_stream *strm);
int   CDECL raw_inflate      (z_stream *strm, int flush);
int   CDECL raw_inflate_end  (z_stream *strm);

unsigned long CDECL update_crc32(uLong crc_value, const Bytef *buf, uInt len);

/* tableau de taille à modifier pour mettre toutes les addresses des procédures à présenter */

PROC LibFunc[] = { 
  {"get_version", "/* Returns library version */\n" "char* get_version(void);\n", get_version},
  {"get_info", "/* Returns library information */\n" "char* get_info(void);\n", get_info},
  {"get_error", "/* Returns string error */\n" "char* get_error(int err);\n", get_error},
  {"get_compil_flags", "/* Returns library compilation flags */\n" "unsigned long get_compil_flags(void);\n", get_compil_flags},
  {"get_sizeof_stream_struct", "/* Returns sizeof(z_stream) */\n" "unsigned long get_sizeof_stream_struct(void);\n", get_sizeof_stream_struct},
	
	{"raw_deflate_init", "/* Initiates Deflate */\n" "long raw_deflate_init(z_stream *strm, long level);\n", raw_deflate_init},
	{"raw_deflate", "/* Deflate */\n" "long raw_deflate(z_stream *strm, long flush);\n", raw_deflate},
	{"raw_deflate_end", "/* Ends Deflate */\n" "long raw_deflate_end(z_stream *strm);\n", raw_deflate_end},
	
	{"raw_inflate_init", "/* Initiates Inflate */\n" "long raw_inflate_init(z_stream *strm);\n", raw_inflate_init},
	{"raw_inflate", "/* Inflate */\n" "long raw_inflate(z_stream *strm, long flush);\n", raw_inflate},
	{"raw_inflate_end", "/* Ends Inflate */\n" "long raw_inflate_end(z_stream *strm);\n", raw_inflate_end},
  
	{"update_crc32", "/* Returns the crc32 value with the old crc and new data */\n" "unsigned long update_crc32(unsigned long crc, char *src, unsigned int srclen);\n", update_crc32}
	};

LDGLIB LibLdg[] = { { 0x0001,	12, LibFunc,	"zlib: deflate/inflate/crc32 basic routines.", 1} };

/* fonctions de la librairie servant aux clients */

const char* CDECL get_version() { return ZLIB_VERSION; }
const char* CDECL get_info() { return "[1][deflate, inflate and crc32 routines.][ Ok ]"; }
const char* CDECL get_error(err) int err; { return zError(err); }
unsigned long CDECL get_compil_flags() { return zlibCompileFlags(); }
unsigned long CDECL get_sizeof_stream_struct() { return (uLong)sizeof(z_stream); }

int CDECL raw_deflate_init (z_stream *strm, int level) {	return deflateInit2(strm, level, Z_DEFLATED, -MAX_WBITS, MAX_MEM_LEVEL, Z_DEFAULT_STRATEGY); } 
int CDECL raw_deflate (z_stream *strm, int flush) { return deflate(strm, flush); } 
int CDECL raw_deflate_end (z_stream *strm) { return deflateEnd(strm); } 

int CDECL raw_inflate_init (z_stream *strm) { return inflateInit2(strm, -MAX_WBITS); }
int CDECL raw_inflate (z_stream *strm, int flush) { return inflate(strm, flush); }
int CDECL raw_inflate_end (z_stream *strm) { return inflateBackEnd(strm); }

unsigned long CDECL update_crc32(crc_value, buf, len) uLong crc_value; const Bytef *buf; uInt len; { return(crc32(crc_value, buf, len)); }

/* boucle principale : communication de la librairie avec les clients */

int main(void) {
	ldg_init( LibLdg);
	return 0;
	}
