/*
	Tabulator width: 3
	Comments start: Column 60										  *Column 60*
*/

#include	<PORTAB.H>
#include	<AES.H>
#include	<TOS.H>
#include <string.h>
#include "DRAGDROP.H"

/*-------------------------------------------------------------------------------------*/ 
/* Drag & Drop - Open pipe (for the sender)															*/
/* Function return:  	Handle of pipe, -1 for errors or -2 for errors at appl_write	*/
/*	app_id:					ID of sender (own application)									      */
/*	rcvr_id:					ID of receiver 		          											*/
/*	window:					Handle of receiver-window													*/
/*	mx:						x-coordinate of mouse when released or -1								*/
/*	my:						y-coordinate of mouse when released or -1								*/
/*	kbstate:					Status of the control keys													*/
/*	format:					Field for up to 8 formats supported by receiver				      */
/*	oldpipesig:				Pointer to the old signal-dispatcher									*/
/*-------------------------------------------------------------------------------------*/ 
WORD	ddcreate( WORD	app_id, WORD rcvr_id, WORD window, WORD mx, WORD my, 
                WORD kbstate, ULONG format[8], void **oldpipesig )
{
	BYTE	pipe[24];
	WORD	mbuf[8];
	LONG	handle_mask;
	WORD	handle, i;

	strcpy( pipe, "U:\\PIPE\\DRAGDROP.AA" );
	pipe[18] = 'A' - 1;

	do
	{
		pipe[18]++;															/* Repeat last letter */
		if ( pipe[18] > 'Z' )											/* Not a letter of the alphabet? */
		{
			pipe[17]++;														/* Alter first letter of extension */
			if ( pipe[17] > 'Z' )										/* Could no pipe be opened? */
				return( -1 );
		}

		handle = (WORD) Fcreate( pipe, 0x02 );						/* Create pipe, 0x02 means that EOF will be returned */
																				/* if the pipe was not opened for reading by anyone  */
	} while ( handle == EACCDN );

	if ( handle < 0 )														/* Could the pipe not be created? */
		return( handle );

	mbuf[0] = AP_DRAGDROP;												/* Send Drap&Drop message  */
	mbuf[1] = app_id;														/* ID of own application */
	mbuf[2] = 0;
	mbuf[3] = window;														/* Window handle */
	mbuf[4] = mx;															/* x-coordinate of mouse */
	mbuf[5] = my;															/* y-coordinate of mouse */
	mbuf[6] = kbstate;													/* Keyboard status */
	mbuf[7] = (((WORD) pipe[17]) << 8 ) + pipe[18];				/* End of the pipe-name */

	if ( appl_write( rcvr_id, 16, mbuf ) == 0 )					/* Error with appl_write()? */
	{
		Fclose( handle );													/* Close pipe */
		return( -2 );
	}

	handle_mask = 1L << handle;
	i = Fselect( DD_TIMEOUT, &handle_mask, 0L, 0L );			/* Wait for reply */

	if ( i && handle_mask )												/* No timeout? */
	{
		BYTE	reply;
		
		if ( Fread( handle, 1L, &reply ) == 1 )					/* Read reply from receiver */
		{
			if ( reply == DD_OK )										/* All in order? */
			{
				if ( Fread( handle, DD_EXTSIZE, format ) == DD_EXTSIZE )	/* Read supported formats */
				{
					*oldpipesig = Psignal( SIGPIPE, (void *) SIG_IGN );	/* Unhook dispatcher */
					return( handle );
				}
			}
		}
	}

	Fclose( handle );														/* Close pipe */
	return( -1 );
}


/*----------------------------------------------------------------------*/ 
/* Drag & Drop - check whether the receiver accepts a format       		*/
/* Function return:  	DD_OK: Receiver supports the format   				*/
/*								DD_EXT: Receiver does not accept the format  	*/
/*								DD_LEN: Data is too long for the receiver   		*/
/*								DD_NAK: Error during communication					*/								
/*	handle:					Handle of pipe												*/
/*	format:					Shortcut for the format									*/
/*	name:						Description of the format as C-string				*/
/*	size:						Length of data to be sent  							*/
/*----------------------------------------------------------------------*/ 
WORD	ddstry( WORD handle, ULONG format, BYTE *name, LONG size )
{
	LONG	str_len;
	WORD	hdr_len;
	
	str_len = strlen( name ) + 1;										/* Length of string including Nullbyte */
	hdr_len = 4 + 4 + (WORD) str_len;								/* Length of header */

	if ( Fwrite( handle, 2, &hdr_len ) == 2 )						/* Send length of header */
	{
		LONG	written;
		
		written = Fwrite( handle, 4, &format );					/* Format shortcut */
		written += Fwrite( handle, 4, &size );						/* Length of data to be sent */
		written += Fwrite( handle, str_len, name );				/* Description of format as C-string */

		if ( written == hdr_len )										/* Could the header be written? */
		{
			BYTE	reply;
			
			if ( Fread( handle, 1, &reply ) == 1 )
				return( reply );											/* Return reply */
		}
	}	
	return( DD_NAK );
}

/*----------------------------------------------------------------------*/ 
/* Drag & Drop - Close pipe    														*/
/*	handle:					Handle of pipe												*/
/* oldpipesig:				Pointer to old signal handler							*/
/*----------------------------------------------------------------------*/ 
void	ddclose( WORD handle, void *oldpipesig )
{
	Psignal( SIGPIPE, oldpipesig );									/* Enter old dispatcher once more */
	Fclose( handle );														/* Close pipe */
}

/*----------------------------------------------------------------------*/ 
/* Drag & Drop - Open pipe (for the receiver)   								*/
/* Function return:  	Handle of pipe or -1 (error)							*/
/* pipe:						Pointer to name of the pipe ("DRAGDROP.??")		*/
/* format:					Pointer to array with supported data formats    */
/* oldpipesig:				Pointer to the pointer to old signal handler		*/
/*----------------------------------------------------------------------*/
WORD	ddopen( BYTE *pipe, ULONG format[8], void **oldpipesig )
{
	WORD	handle;
	BYTE	reply;

	handle = (WORD) Fopen( pipe, FO_RW );							/* Inquire pipe handle */
	if ( handle < 0 )
		return( -1 );

	reply = DD_OK;															/* Program supports Drag & Drop */

	*oldpipesig = Psignal( SIGPIPE, (void *) SIG_IGN );		/* Ignore signal */

	if ( Fwrite( handle, 1, &reply ) == 1 )
	{
		if ( Fwrite( handle, DD_EXTSIZE, format ) == DD_EXTSIZE )
			return( handle );
	}

	ddclose( handle, *oldpipesig );									/* Close pipe */
	return( -1 );
}

/*----------------------------------------------------------------------*/ 
/* Read in header for Drag & Drop 													*/
/* Function return:  	0 Error  1: All OK           							*/
/*	handle:					Handle of pipe												*/
/* name:						Pointer to array for the data name 					*/
/* format:					Pointer to a Long that indicates data format		*/
/* size:						Pointer to a Long for the length of the data		*/
/*----------------------------------------------------------------------*/ 
WORD	ddrtry( WORD handle, BYTE *name, ULONG *format, LONG *size )
{
	WORD	hdr_len;

	if ( Fread( handle, 2, &hdr_len ) == 2 )						/* Read out header length */
	{
		if ( hdr_len >= 9 )												/* Complete header? */
		{
			if ( Fread( handle, 4, format ) == 4 )					/* Read out data type */
			{
				if ( Fread( handle, 4, size ) == 4 )				/* Read out length of data in bytes */
				{	
					WORD	name_len;
					
					name_len = hdr_len -= 8;							/* Length of the name including Nullbyte */

					if ( name_len > DD_NAMEMAX )				
						name_len = DD_NAMEMAX;

					if ( Fread( handle, name_len, name ) == name_len )	/* Read out data name	*/
					{
						BYTE	buf[64];
					
						hdr_len -= name_len;
	
						while ( hdr_len > 64 )							/* Read out rest of header */
						{
							Fread( handle, 64, buf );
							hdr_len -= 64;
						}
		
						if ( hdr_len > 0 )
							Fread( handle, hdr_len, buf );
	
						return( 1 );
					}
				}
			}
		}
	}
	return( 0 );															/* Error */
}

/*----------------------------------------------------------------------*/ 
/* Messages to the Drag & Drop - Send initiator									*/
/* Function return:  	0: Error  1: All OK          							*/
/*	handle:					Handle of pipe												*/
/* msg:						Message number   											*/
/*----------------------------------------------------------------------*/ 
WORD	ddreply( WORD handle, WORD msg )
{
	if ( Fwrite( handle, 1, ((BYTE *) &msg ) + 1 ) != 1 )		/* Error? */
	{
		Fclose( handle );													/* Close pipe */
		return( 0 );
	}
	return( 1 );
}
 