/********************************************************************
*
* MagiC Device Driver Development Kit
* ===================================
*
* Example of a driver for printer operation in the background
*
*
* This program realises an interrup-controled device driver.
* Some device functions are executed in assembler, which 
* makes fast and compact code possible.
*
*
* Tabulator width: 5
*
* (C) Andreas Kromke, 1994
* English translation: Peter West, April 99
*
********************************************************************/


#include <string.h>
#include <tos.h>
#include <tosdefs.h>
#include "magx.h"
#include "mgx_xfs.h"
#include "mgx_dfs.h"

extern void handle_busy( void );

#define NULL ((void *) 0)

/******************************************************************
*
* Device-specific variables
*
******************************************************************/

void *lpt_dev_owner = NULL;
MX_KERNEL *kernel;
void **oldvec;



#pragma warn -par

/******************************************************************
*
* Open device:
*  I memorise the current process, so that the device is not 
*  opened several times.
*
******************************************************************/

long lpt_dev_open   (MX_DOSFD *f)
{
     if   (lpt_dev_owner)
          return(EACCDN);          /* Already opened */
     lpt_dev_owner = kernel->act_pd;
     return(E_OK);
}


/******************************************************************
*
* Close device:
*  I release the device.
*
******************************************************************/

long lpt_dev_close  (MX_DOSFD *f)
{
     lpt_dev_owner = NULL;
     return(E_OK);
}


/******************************************************************
*
* Read:
*
******************************************************************/

long lpt_dev_read   (MX_DOSFD *f, void *buf,  long len  )
{
     return(EACCDN);
}


/******************************************************************
*
* Write:
*  -> Assembler module
*
******************************************************************/

extern long lpt_dev_write  (MX_DOSFD *f, void *buf,  long len  );


/******************************************************************
*
* Status:
*  -> Assembler module
*
******************************************************************/

extern long lpt_dev_stat   (MX_DOSFD *f, int  rwflag, void *unsel, void *appl);


/******************************************************************
*
* Position file pointer
*
******************************************************************/

long lpt_dev_lseek  (MX_DOSFD *f, long where, int mode  )
{
     return(EACCDN);
}


/******************************************************************
*
* Time/date stamp of the opened file
*
******************************************************************/

/*

Accomplished by DOS

long lpt_dev_datime (MX_DOSFD *f, int  *buf,  int rwflag)
{
}

*/

/******************************************************************
*
* Device-specific commands
*
******************************************************************/

long lpt_dev_ioctl  (MX_DOSFD *f, int  cmd, void *buf )
{
     return(EACCDN);
}


/******************************************************************
*
* Device being deleted:
*  Awaken device driver and hence terminate it.
*
******************************************************************/

long lpt_dev_delete ( MX_DOSFD *parent, MX_DOSDIR *dir )
{
     Mfpint(0, (void (*)()) oldvec);
     kernel->Pfree(_BasPag);
     return(E_OK);
}

#pragma warn +par

MX_DDEV drvr =
     {
     lpt_dev_open,
     lpt_dev_close,
     lpt_dev_read,
     lpt_dev_write,
     lpt_dev_stat,
     lpt_dev_lseek,
     NULL,					/* datime accomplished by XFS_DOS */
     lpt_dev_ioctl,
     lpt_dev_delete,
     NULL,					/* No getc */
     NULL,					/* No getline */
     NULL						/* No putc */
     };

int main()
{
	long errcode;

	/* Initialise MFP interrupt #0 (Centronics busy)  */

	oldvec = (void **) Setexc(64, (void (*)()) -1L);
	Mfpint(0, handle_busy);
	errcode = Dcntl(DEV_M_INSTALL, "u:\\dev\\lpt1", (long) &drvr);
	if   (errcode < 0L)
		{
		Mfpint(0, (void (*)()) oldvec);
		return((int) kernel);
		}

	kernel = (MX_KERNEL *) Dcntl(KER_GETINFO, NULL, 0L);
	Ptermres(-1L, 0);        	/* Keep all memory */
	return(0);
}
