; Hardware related functions of the LPT1 driver
;
; Tabulator width: 5

     SUPER

     XREF kernel

     XDEF lpt_dev_write
     XDEF lpt_dev_stat
     XDEF handle_busy

	INCLUDE "d:\xkaos\docs3\mgx_xfs.inc"

     TEXT

gpip              EQU $fffffa01           ;GPIP-data register
giselect          EQU $ffff8800           ;Select chip register
isrb              EQU $fffffa11           ;Interrupt-in-service register B

E_OK           EQU    0       ;   0     No error
ERROR          EQU   -1       ;  -1     General error
EDRVNR         EQU   -2       ;  -2     Drive not ready
EUNCMD         EQU   -3       ;  -3     Unknown command
E_CRC          EQU   -4       ;  -4     Checksum error
EBADRQ         EQU   -5       ;  -5     Command not possible
E_SEEK         EQU   -6       ;  -6     Track not found
EMEDIA         EQU   -7       ;  -7     Unknown medium
ESECNF         EQU   -8       ;  -8     Sector not found
EPAPER         EQU   -9       ;  -9     Out of paper
EWRITF         EQU  -10       ; -$A     Write error
EREADF         EQU  -11       ; -$B     Read error
EWRPRO         EQU  -13       ; -$D     Write-protected
E_CHNG         EQU  -14       ; -$E     Invalid disk change
EUNDEV         EQU  -15       ; -$F     Unknown device
EBADSF         EQU  -16       ; -$10    Verify error
EOTHER         EQU  -17       ; -$11    Disk change (A<->B)

EINVFN         EQU  -32       ; -$20    Invalid function number
EFILNF         EQU  -33       ; -$21    File not found
EPTHNF         EQU  -34       ; -$22    Path not found
ENHNDL         EQU  -35       ; -$23    No more handles left 
EACCDN         EQU  -36       ; -$24    Access denied
EIHNDL         EQU  -37       ; -$25    Invalid handle number
ENSMEM         EQU  -39       ; -$27    Insufficient memory
EIMBA          EQU  -40       ; -$28    Invalid memory block address
EDRIVE         EQU  -46       ; -$2E    Invalid drive specification
ENSAME         EQU  -48       ; -$30    Not the same drive
ENMFIL         EQU  -49       ; -$31    No more files
ELOCKED        EQU  -58       ;          MiNT: Device blcoked
ENSLOCK        EQU  -59       ;          MiNT: Unlock-error
ERANGE         EQU  -64       ; -$40    File pointer range error
EINTRN         EQU  -65       ; -$41    Internal error
EPLFMT         EQU  -66       ; -$42    Invalid program load format
EGSBF          EQU  -67       ; -$43    Memory block growth failure
EBREAK         EQU  -68       ; -$44    KAOS: Exited with CTRL-C
EXCPT          EQU  -69       ; -$45    KAOS: 68000 exception


**********************************************************************
*
*

unsel:    DC.L 0
appl:     DC.L 0

handle_busy:
 tst.l    unsel
 beq.b    hb_ende
 tst.l    appl
 beq.b    hb_ende
 movem.l  d0-d2/a0-a2,-(sp)

 moveq    #1,d0
 move.l   unsel(pc),a0
 clr.l    unsel                         ; Deactivate interrupt
 move.l   d0,(a0)                       ; Mark as arrived

 move.l   appl(pc),a0
 move.l   kernel(pc),a1
 move.l   mxk_appl_IOcomplete(a1),a1
 jsr      (a1)
 movem.l  (sp)+,d0-d2/a0-a2
hb_ende:
 move.b   #$fe,isrb                     ; Clear service-bit
 rte


/******************************************************************
*
* Writing:
* long lpt_dev_write  (MX_DOSFD *f, void *buf,  long len  );
*
******************************************************************/

lpt_dev_write:
 movem.l  d7/d6/a6,-(sp)
 move.l   a1,a6					; a6 = buf
 move.l   d0,d7					; d7 = count
 moveq    #0,d6
 bra      dw_nxt
dw_loop:

* Block interrupt and test condition

 move     sr,d1
 ori      #$700,sr
 btst.b   #0,gpip                  	; MFP-BUSY (parallel port)
 beq.b    dw_send                  	; No, send

* Set up interrupt

 pea      dev_unsel(pc)
 move.l   kernel,a1
 move.l   mxk_act_appl(a1),a0
 move.l   (a0),appl
 move.l   sp,unsel

* Release interrupt

 move.w   d1,sr

* Wait for interrupt

 move.l   mxk_evnt_IO(a1),a2
 move.l   sp,a0
 move.l   #500,d0                  	; 10s
 jsr      (a2)
 addq.l   #4,sp
 tst.l    d0                       	; OK ?
 beq      dw_end                   	; No
 bra      dw_loop                  	; ##### ??? ######

dw_send:
 lea      giselect,a1              	; Soundchip: Select/read register 
 lea      2(a1),a2                 	; Soundchip: Write register
 move.b   #7,(a1)                  	; Select register 7
 move.b   (a1),d0                  	; Get value
 ori.b    #%11000000,d0            	; Port A (Centr.Strobe) and
 move.b   d0,(a2)                  	; Port B (Centr.Data) to output
 move.b   #15,(a1)                 	; Select register 15: Port B
 move.b   (a6)+,(a2)               	; Output character
 move.b   #14,(a1)                 	; Select register 14: Port A
 move.b   (a1),d0
 andi.b   #%11011111,d0            	; Strobe low
 move.b   d0,(a2)                  	; Strobe low -> Printer
;Here some delay if required
 ori.b    #%00100000,d0            	; Strobe high
 move.b   d0,(a2)                  	; Strobe high -> Printer
 move     d1,sr


; move.l  #1000,d2                 	; #### ??? #####
;dw_delay:
; subq.l  #1,d2
; bne.b   dw_delay

 addq.l   #1,d6

dw_nxt:
 subq.l   #1,d7
 bcc      dw_loop
dw_end:
 move.l   d6,d0
 movem.l  (sp)+,d6/d7/a6
 rts


/******************************************************************
*
* Status:
* long lpt_dev_stat   (MAGX_FD *f, int  rwflag, void *unsel, long apcode)
*
******************************************************************/

lpt_dev_stat:
 tst.w    d0             			; Read?
 beq      st_err         			; Yes, error

 btst.b   #0,gpip        			; MFP-BUSY (parallel port)
 beq.b    st_ok          			; No, ready

 tst.l	d1
 beq		st_ende					; Wanted polling, return 0

 move.l   a1,unsel
 move.l   d1,appl
 move.l   #dev_unsel,d0
 bra      st_ende

st_ok:
 moveq    #1,d0
 bra.b    st_ende
st_err:
 moveq    #EWRITF,d0

st_ende:
 move.l   a1,d1
 beq.b    st_e2
 move.l   d0,(a1)
st_e2:
 rts


**********************************************************************
*
* void dev_unsel( a0 = long *unselect, a1 = void *apcode );
*
*

dev_unsel:
 clr.l    unsel
 clr.l    appl
 clr.l    (a0)
 rts
