/********************************************************************
*
* MagiC Device Driver Development Kit
* ===================================
*
* C module
*
*
* The MDDDK contains all the required modules to create a device
* driver for MagiC 3.0 and up in 'C'. In the module SAMPLE.S, the
* MagiC assembler interface is translated for 'C'. In order to be
* compatible with all compilers, all the functions in PureC are
* declared as "cdecl", i.e. parameter passing is always via the stack.
*
* The include-files mgx_???c.h contain cdecl procedure declarations
* for access via the "Glue" code in sample.s, i.e. the structures
* are not those of the operating system, but those of the "Glue" code.
* The "Glue" code then translates the procedure calls for the operating
* system.
*
* The example driver ignores read- and write-accesses - at the 
* corresponding places one has to insert one's own routines.
*
* For a detailed descrition of the functions see MGX_DFS.TXT (in the
* FILESYS folder).
*
* For the programming of an interrupt-controlled device driver see
* DEV_LPT1. In DEV_LPT1 some of the device functions are executed
* in assembler, which permits a faster and more compact code.
*
*
* (C) Andreas Kromke, 1994
*
********************************************************************/

#include <string.h>
#include <tos.h>
#include <tosdefs.h>

#include "magx.h"
#include "mgx_xfsc.h"
#include "mgx_dfsc.h"

#ifndef NULL
#define NULL ((void *) 0)
#endif


/******************************************************************
*
* Import from the assembler module "sample.s".
*
* _drvr is the structure that is installed for the kernel. It
* translates the calls from assembler to 'C', i.e. copies the 
* passing registers to the stack and and calls the routines of drvr.
* The routines of drvr are therefore declared as "cdecl".
*
* If routines are to be executed in assembler then one can enter
* a null-pointer in the structure "drvr", and implement the 
* function completely in the assembler part.
*
******************************************************************/

extern MX_DDEV _drvr;


/******************************************************************
*
* Device-specific variables
*
******************************************************************/

MX_KERNEL *kernel;



#pragma warn -par

/******************************************************************
*
* Open device
*
******************************************************************/

LONG cdecl sample_open( MX_DOSFD *f )
{
	return(E_OK);
}


/******************************************************************
*
* Close device
*
******************************************************************/

LONG cdecl sample_close( MX_DOSFD *f )
{
	return(E_OK);
}


/******************************************************************
*
* Read
*
******************************************************************/

LONG cdecl sample_read( MX_DOSFD *f, void *buf,  LONG len )
{
	return(0L);
}


/******************************************************************
*
* Write
*
******************************************************************/

LONG cdecl sample_write( MX_DOSFD *f, void *buf,  LONG len )
{
	return(0L);
}


/******************************************************************
*
* Status
*
******************************************************************/

LONG cdecl sample_stat( MX_DOSFD *f, WORD rwflag, void *unsel,
					void *appl)
{
	return(0);
}


/******************************************************************
*
* Position file pointer
*
******************************************************************/

LONG cdecl sample_seek( MX_DOSFD *f, LONG where, WORD mode )
{
	return(EACCDN);
}


/******************************************************************
*
* Time/date-stamp of the opened file
*
******************************************************************/

LONG cdecl sample_datime( MX_DOSFD *f, WORD *buf, WORD rwflag)
{
	return(EACCDN);
}


/******************************************************************
*
* Device-specific commands
*
******************************************************************/

LONG cdecl sample_ioctl( MX_DOSFD *f, WORD cmd, void *buf )
{
	return(EINVFN);
}


/******************************************************************
*
* Delete device
*  Remove device driver from memory (!)
*
******************************************************************/

LONG cdecl sample_delete ( MX_DOSFD *parent, MX_DOSDIR *dir )
{
	/* Deinstall the driver here */

	/* ... */

	kernel->Pfree(_BasPag);
	return(E_OK);
}

/******************************************************************
*
* Read in single character (for Fgetchar)
*
* mode & 0x0001:    cooked
* mode & 0x0002:    echo mode
*
* Return: This is generally a longword for CON, else a byte
*         0x0000FF1A for EOF
*
******************************************************************/

LONG cdecl sample_getc( MX_DOSFD *f, WORD mode )
{
	return(0L);
}


/******************************************************************
*
* Read in line (for Cconrs)
*
* mode & 0x0001:    cooked
* mode & 0x0002:    echo mode
*
* Return: Number of read bytes, or error code
*
******************************************************************/

LONG cdecl sample_getline( MX_DOSFD *f, char *buf,
						LONG size, WORD mode )
{
	return(0L);
}


/******************************************************************
*
* Output single character (for Fputchar)
*
* mode & 0x0001:    cooked
*
* Return: Number of bytes written, 4 for a terminal
*
******************************************************************/

LONG cdecl sample_putc( MX_DOSFD *f, WORD mode, LONG val )
{
	return(0L);
}


#pragma warn +par


MX_DDEV drvr =
	{
	sample_open,
	sample_close,
	sample_read,
	sample_write,
	sample_stat,
	sample_seek,
	sample_datime,
	sample_ioctl,
	sample_delete,
	sample_getc,
	sample_getline,
	sample_putc
	};

int main( void )
{
	long errcode;

	/* Standard functions if appropriate */
	/*
	_drvr.ddev_datime	= NULL;	/* For Fdatime  */
	_drvr.ddev_ioctl	= NULL;	/* For Fcntl    */
	_drvr.ddev_getc	= NULL;	/* For Fgetchar */
	_drvr.ddev_getline	= NULL;	/* For Cconrs   */
	_drvr.ddev_putc	= NULL;	/* For Fputchar */
	*/


	errcode = Dcntl(KER_GETINFO, NULL, 0L);
	if   (errcode > 0L)
		{
		kernel = (MX_KERNEL *) errcode;
		errcode = Dcntl(DEV_M_INSTALL, "u:\\dev\\sample",	(long) &_drvr);
		}
	if	(errcode < 0L)
		{
		return((int) errcode);
		}

	Ptermres(-1L, 0);        /* Retain all the memory */
	return(0);
}
