/*
 * Plugin header file, API v2.00
 */


#include <plugin\types2b.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tos.h>
#include <setjmp.h>
#include <vdi.h>
#include <plugin\nvdi.h>
#include <plugin\ec_error.h>

#ifdef __PUREC__
#define CDECL cdecl
#else
#include <compiler.h>
#define CDECL __CDECL
#endif


#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#ifndef MIN
#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))
#endif


/* FNCTAB structure */
typedef struct {			/* offset											*/
	uint32	id;				/*  0 id -> 'GB32'									*/
	uint16	version;		/*  4 version: $0112 -> v1.12						*/
	uint16	flags;			/*  6 bits: 0=load 1=save 2-15=not used				*/
	char	*ext_list;		/*  8 extention list, 4 chars each, null terminated	*/
	char	*format;		/* 12 format name, null terminated					*/
	char	*author;		/* 16 plugin author, null terminated				*/
	char	*misc;			/* 20 additional information, null terminated		*/
	char	*timestamp;		/* 24 build date/time, null terminated				*/
	void	*plg_init;		/* 28 plugin init, required							*/
	void	*plg_userdef;	/* 32 caller can put whatever here */
	void	*plg_open;		/* 36 open image for read, nulls if save plugin		*/
	void	*plg_rw;		/* 40 read/write image data							*/
	void	*plg_close;		/* 44 close file, free all resources				*/
} FNCTAB;					/* 48 bytes total */


/* Palette types		type	size in bytes				*/
#define	CPAL_NONE		0	/*	0							*/
#define	CPAL_ST			1	/*	32		16*2				*/
#define	CPAL_STE		2	/*	32		16*2				*/
#define	CPAL_TT030		3	/*	512		256*2				*/
#define	CPAL_FALCON		4	/*	1024	256*4				*/
#define	CPAL_VDI		5	/*	1536	256*(3*2)			*/
#define	CPAL_VDIX		6	/*	1536	256*(3*2)			*/
#define	CPAL_RGB		7	/*	768		256*3				*/
#define	CPAL_RGBX		8	/*	1024	256*(3+1)	padded	*/


typedef struct {
	uint8	red;
	uint8	green;
	uint8	blue;
} COLOR_MAP;


/* IMGINFO structure */
typedef struct {					/* 													size	offset	*/
	int16    	width;				/* pixel width										2		+0000	*/
	int16		height;				/* pixel height										2		+0002	*/
	int16 		options;  			/* options flag: true=set/false=defaults			2		+0004	*/
	uint16	 	planes;				/* bits per pixel									2		+0006	*/
	uint32 		colors;				/* total colors										4		+0008	*/
	int16		pal_type;			/* palette type	0 to 8								2		+0012	*/
	uint16		pages;				/* number of frames/images in the file 				2		+0014	*/
	uint16		delay;				/* animation delay, 200th sec. between each frame	2		+0016	*/
	int16		reserved1;			/* unused									 	 	2		+0018	*/
	void		*aes_global;		/* ptr to aes global array						 	4		+0020	*/
	int16		vdi_handle;			/* callers vdi handle								2		+0024	*/
	COLOR_MAP	palette[256];		/* palette, layout depends on the image 			1536	+0026	*/
	uint8		pal[512];			/* filler to get palette to 1536 bytes								*/
	uint32		background_color;	/* use for transparent color (xxRRGGBB)				4		+1562	*/
	uint16		bpl;				/* bytes per line, caller image buffer				2		+1566	*/
	uint16		page_wanted;		/* frame/image to fetch, 0 to pages - 1				2		+1568	*/
	char		info[40];			/* image info, ex: "Gif 87a"						40		+1570	*/
	char		more[40];			/* Extra picture info, ex: "Interlaced"				40		+1610	*/
	char		compression[30];	/* compression type, ex: "LZW"						30		+1650	*/
	uint32    	px_format;			/* nvdi 5 pixel format, describes bitmap layout		4		+1680	*/
	/* options:						   encoder		decoder												*/
	int32		option1;			/* quality		-									4		+1684	*/
	int32		option2;			/* compression	-									4		+1688	*/
	int32		option3;			/* color space	-									4		+1692	*/
	int32		option4;			/* progressive	-									4		+1696	*/
	int32		option5;			/* -			-									4		+1700	*/
	int32		option6;			/* -			-									4		+1704	*/
	int32		option7;			/* -			-									4		+1708	*/
	int32		option8;			/* -			-									4		+1712	*/
	/* private data for plugins																			*/
	void		*_priv_ptr;			/*													4		+1716	*/
	void		*_priv_ptr_more;	/*													4		+1720	*/
	void		*__priv_ptr_more;	/*													4		+1724	*/
	int32		_priv_var;			/*													4		+1728	*/
	int32		_priv_var_more;		/*													4		+1732	*/
} IMGINFO;							/*													total	 1736	*/


/* prototypes */
void	CDECL plugin_init(void);
void	CDECL plugin_deinit(void);
/*  these must be int32 or c:asm%() fails with 'number not a word' in gfa */
int32	CDECL plugin_open(IMGINFO *info, const char *name);
int32	CDECL plugin_rw(IMGINFO *info, uint8 *buffer);
int32	CDECL plugin_close(IMGINFO *info);


#define	INFO_TIMESTAMP	(__DATE__" "__TIME__)	/* build date/time */
#define	INFO_ID			0x47423332L				/* 'GB32' */


FNCTAB fnctab = {
	INFO_ID,
	INFO_VERSION,
	INFO_FLAGS,
	INFO_EXTENSIONS,
	INFO_FORMAT,
	INFO_AUTHOR,
	INFO_MISC,
	INFO_TIMESTAMP,
	plugin_init,
	0L,
	plugin_open,
	plugin_rw,
	plugin_close,
};


/* eof */
