*-----------------------------------------------------------------------*
*		     'PCS','PC1' and 'TNY' slideshow source.			*
*-----------------------------------------------------------------------*
*			      (C) 1992  Douglas Little 				*
*-----------------------------------------------------------------------*

*-----------------------------------------------------------------------*
*	Includes 'PCS' file decompression + display routines			*
*-----------------------------------------------------------------------*
*	Requires Devpac 2 for assembly, set tabs to 6!				*
*-----------------------------------------------------------------------*
*	This code serves only as an example of how to use the display	*
*	code safely. It is not an exercise in how to do an excellent	*
*	slideshow, but is laid out in such a way as to be readable by	*
*	others (sort of). Feel free to improve on the design, but don't	*
*	mess with the display interrupt unless you know how it works!	*
*-----------------------------------------------------------------------*
*	P.S.	The PACK-ICE decrunch source has been removed, so the		*
*		double-packed file option is disabled. I cannot spread	*
*		another author's code without his knowledge as it is		*
*		copyright material and may require permission.			*
*-----------------------------------------------------------------------*

	OPT	O+,W+

Devpac2_Pro		; if this option does not work, take it out!
			; (Devpac2 Pro's dcb.? command is back to front and
			; can cause problems. If the assembler jams up,
			; comment this option out and try again.

*-----------------------------------------------------------------------*
*	STANDARD HARDWARE EQUATES							*
*-----------------------------------------------------------------------*

LineADD		=	160
PHYS_MED		=	$FFFF8201
PHYS_TOP		=	$FFFF8203
COLOUR		=	$FFFF8240

MFP			=	$FFFFFA00
ENABLE_A		=	MFP+$07		; int enable A
ENABLE_B		=	MFP+$09		; int enable B
PENDING_A		=	MFP+$0B		; int pending A
PENDING_B		=	MFP+$0D		; int pending B
IN_SERVICE_A	=	MFP+$0F		; int in-service A
IN_SERVICE_B	=	MFP+$11		; int in-service B
MASK_A		=	MFP+$13		; int mask A
MASK_B		=	MFP+$15		; int mask B
VECTOR		=	MFP+$17		; MFP vector base
CTRL_A		=	MFP+$19		; MFP timer A control
CTRL_B		=	MFP+$1B		; MFP timer B control
DATA_A		=	MFP+$1F		; timer A data
DATA_B		=	MFP+$21		; timer B data

HBI_VEC		=	$68			; Hblank timer
VBI_VEC		=	$70			; VBI
KBD_VEC		=	$118			; IKBD
TIMER_A		=	$134			; General timer
TIMER_B		=	$120			; Raster timer

BLIT			=	$FFFF8A00
halftone		=	BLIT+00	16*16 pattern mask
src_xinc		=	BLIT+32	increment of next source word (-128 -> +127)
src_yinc		=	BLIT+34	increment of next source line (-128 -> +127)
src_addr		=	BLIT+36	source data address
endmask1		=	BLIT+40	mask for first word in line (or only word)
endmask2		=	BLIT+42	mask for middle words in line
endmask3		=	BLIT+44	mask for last word in line
dst_xinc		=	BLIT+46	increment of next dest. word (-128 -> +127)
dst_yinc		=	BLIT+48	increment of next dest. line (-128 -> +127)
dst_addr		=	BLIT+50	destination screen address
x_size		=	BLIT+54	x-size	(number of words to go)
y_size		=	BLIT+56	y_size	(number of lines to go)
HOP			=	BLIT+58	halftone operation...
blit_op		=	BLIT+59	logic operations
blit_stat		=	BLIT+60	blitter chip status registers
skew			=	BLIT+61	offset bit shift (byte, 0 > +-15)

*-----------------------------------------------------------------------*
*	USEFUL MACROS									*
*-----------------------------------------------------------------------*

push	macro
	move.\0	\1,-(sp)
	endm
	
pop	macro
	move.\0	(sp)+,\1
	endm

pushall		macro
	movem.l	d0-d7/a0-a6,-(sp)
	endm
	
popall		macro
	movem.l	(sp)+,d0-d7/a0-a6
	endm

supervisor		macro			; supervisor mode
	clr.l		-(sp)
	move.w	#32,-(sp)
	trap		#1
	addq		#6,sp
	move.l	d0,OLD_STK
	endm

user	macro					; user mode
	move.l	OLD_STK,-(sp)
	move.w	#32,-(sp)
	trap		#1
	addq		#6,sp
	endm

delay	macro				; wait for #n VBI's
	move.w	#\1,TIMER
.wz\@	tst.w		TIMER
	bne.s		.wz\@
	endm

*-----------------------------------------------------------------------*

sync		macro				; clock-cycle timing macro
		IFEQ		NARG-1	; please don't read this, especially
		IFD		Devpac2_Pro
		dcb.w		\1,$4E71	; if you are a fan of high level
		ELSEIF
		dcb.w		$4E71,\1
		ENDC
		ELSEIF			; coding!
		IFLT		\1-3-3
		IFD		Devpac2_Pro
		dcb.w		\1,$4E71
		ELSEIF
		dcb.w		$4E71,\1
		ENDC
		ELSEIF
		move.w	#(\1-3)/3-1,\2
.wc\@		dbra		\2,.wc\@
Calc		set		(\1-3)-((\1-3)/3)*3
		IFGT		Calc
		IFD		Devpac2_Pro
		dcb.w		Calc,$4E71	; if you are a fan of high level
		ELSEIF
		dcb.w		$4E71,Calc	; if you are a fan of high level
		ENDC
		ENDC
		ENDC
		ENDC
		endm

*-----------------------------------------------------------------------*

START:supervisor				; into supervisor mode
	move.b	$FFFF820A.w,NORM	; store old frequency
	bsr		EMPTY_BUFFER	; clear keyboard buffer of keypresses
	bsr		INIT_SCREENS	; set screen addresses/attributes
	bsr		INIT_VECTORS	; initialise any interrupts needed
	move.b	#'A',DRIVE		; set source drive to 'A'.
*-----------------------------------------------------------------------*
*	BUILD LISTS OF EACH TYPE OF PICTURE ON THE DISK				*
*-----------------------------------------------------------------------*
	clr.w		NAMES			; no names in list yet
	lea		NAME_LIST(pc),a0	; get name list handy in a0
	lea		TYPE_LIST(pc),a1	; and the list of picture types in a1
.next	move.l	FILTER(pc),a2	; get address of file extension filter
	move.b	(a0)+,(a2)+		; copy first letter from extension list
	beq.s		.done			; if zero, it must be the last one.
	move.b	(a0)+,(a2)+		; otherwise copy the other two to
	move.b	(a0)+,(a2)+		; make up the whole 3-letter extension.
	move.l	(a1)+,PICTURE_TYPE  get address of correct display rout,
	bsr		ADD_TYPE_TO_LIST	  and search drive A for any matches.
	bra.s		.next			; go back and search for next type.
.done	tst.w		NAMES			; check file-count. If none of the
	beq		EXIT			; filetypes found then just quit!
*-----------------------------------------------------------------------*
*	LOAD AND DISPLAY PICTURES IN TURN						*
*-----------------------------------------------------------------------*
	clr.w		CURRENT_NAME	; start filetype-counter from scratch.
	lea		TYPE_BANK,a0	; list of display-routine addresses.
	lea		NAME_BANK,a1	; and the list of filenames found.
.loop	move.w	CURRENT_NAME(pc),d0 Get number of first file, and make a
	move.w	d0,d1			; backup in d1, d0 is multiplied by
	add.w		d0,d0			; 4 (doubled up twice) and used to
	add.w		d0,d0			; index a0 which holds the list of
	move.l	(a0,d0),a2		; picture display routines. a2 holds it.
	mulu		#20,d1		; each name entry is 20 bytes, so
	lea		(a1,d1),a6		; 20*filenum gets the picture name.
	move.l	a6,FILENAME		; store address of nametext in FILENAME
	movem.l	a0-a2,-(sp)		; keep these registers safe...
	move.l	#110000,BYTES	; max filesize about 102k. This is fine
	move.l	#PICTURE,FILE_POS	; tell load routine where to load.
	bsr		LOAD_PICTURE	; load piccy (FILENAME,FILE_POS,BYTES)
	tst.l		d0			; check d0 for loading-problems...
	beq.s		.alok			; if zero, all is ok!
	movem.l	(sp)+,a0-a2		; if not, MUST restore OLD registers
	bra.s		.oops			; and skip past picture-displayer.
.alok	cmp.l		#'ICE!',PICTURE	; check header for PACK-ICE compression
	bne.s		.fine			; if not, ignore ICE-unpack routs.
	pushall				; keep all regs safe.
	move.l	BYTES,d0		; get number of bytes loaded and add
	add.l		d0,FILE_POS		; to FILE_POS, this should skip past
	lea		PICTURE,a0		; the last loaded file, into safe mem.
	move.l	FILE_POS,a1		; source data = a0, free memory = a1
	bsr		DECRUNCH		; unpack a0 to a1.
	popall				; put back registers.
.fine	movem.l	(sp)+,a0-a2		; restore OLD registers from up there ^
	pushall				; hmmm, perhaps this could be improved!
	delay		5			; wait for 5 VBI's (and why not?)
	jsr		(a2)			; display actual picture (a2=disp rout)
	delay		5			; wait for 5 more (so it's symmetrical)
	bsr		FLUSH			; flush the IKBD properly (sorry, GEM!)
	bsr		EMPTY_BUFFER	; now empty GEM's keyboard buffer too.
	popall				; bung back all registers.
.oops	tst.b		QUIT			; test for quit key pressed, and if so
	bne		EXIT			; (not zero) then bog off out of it.
	addq		#1,CURRENT_NAME	; otherwise increment name-counter
	move.w	NAMES,d0		; and check for last name in list.
	cmp.w		CURRENT_NAME,d0	; if it is equal to the number of files
	bne		.loop			; then clear it and loop back.
	clr.w		CURRENT_NAME	; otherwise just loop back.
	bra		.loop

*-----------------------------------------------------------------------*
*	LOAD A PICTURE FROM DISK							*	
*-----------------------------------------------------------------------*

LOAD_PICTURE:				; standard GEM file-read routines.
	clr.w		-(sp)
	push.l	FILENAME(pc)
	move.w	#$3D,-(sp)		; open file
	trap		#1
	addq		#8,sp
	move.l	d0,d5
	tst.l		d0
	bmi.s		.err			; handle. d0 negative=error
.read	move.l	FILE_POS(pc),-(sp); address to load.
	move.l	BYTES(pc),-(sp)	; bytes to load.
	move.w	d5,-(sp)
	move.w	#$3F,-(sp)
	trap		#1
	lea		12(sp),sp
	tst.l		d0
	bpl.s		.clos
.ercl	move.w	d5,-(sp)
	move.w	#$3E,-(sp)
	trap		#1
	addq.l	#4,sp
.err	moveq		#-1,d0
	rts
.clos	move.l	d0,BYTES	; store bytes actually loaded for reference.
	move.w	d5,-(sp)
	move.w	#$3E,-(sp)
	trap		#1
	addq.l	#4,sp
	moveq		#0,d0
	rts
	
FILENAME:	ds.l	1		; filename pointer.
FILE_POS:	ds.l	1		; address to load.
BYTES:	ds.l	1		; bytes to load.
HANDLE:	ds.w	1		; GEM file handle

*-----------------------------------------------------------------------*
*	FILE SEARCHING SYSTEM								*
*-----------------------------------------------------------------------*

ADD_TYPE_TO_LIST:			; check disk for any existing files of
	pea		(a0)		; type '*.XXX' (where XXX=extension)
	pea		(a1)
	lea		SEARCHNAME(pc),a1
	move.b	DRIVE,(a1)+	; copy drive number,
	move.b	#":",(a1)+	; colon,
	move.b	#"\",(a1)+	; backslash,
	move.b	#"*",(a1)+	; star and
	move.b	#".",(a1)+	; dot into the searchname. (i.e. 'A:\*.')
	move.l	FILTER(pc),a0
	move.b	(a0)+,(a1)+	; now copy the new file extension onto
	move.b	(a0)+,(a1)+	; the end of it.
	move.b	(a0)+,(a1)+
	clr.b		(a1)		; finish with a zero...

	pea		DTA(pc)	; set up DISK TRANSFER ADDRESS (DTA BUFFER)
	push.w	#$1A		; (BIOS $1A) so we can look at what GEM is
	trap		#1		; finding on the disk.
	addq		#6,sp

	push.w	#0			; do a 'FIND FIRST' (BIOS $4E) to start
	pea		SEARCHNAME(pc)	; a new filesearch.
	push.w	#$4E
	trap		#1
	addq		#8,sp
	tst.l		d0			; found any matches?
	bne.s		.no_files		; if no names of this type then quit.

.loop	bsr.s		ADD_NAME_TO_LIST	; otherwise add this file to current
	push.w	#$4F			; list of filenames,
	trap		#1			; do a 'FIND NEXT'  (BIOS $4F)
	addq		#2,sp			; and check for a return
	tst.l		d0			; if so, then
	beq.s		.loop			; loop back and add it too.
.no_files					; otherwise finish.
	pop.l		a1
	pop.l		a0
	rts

ADD_NAME_TO_LIST:				; copy filename from DTA buffer to 
	lea		DTA+DTA_name,a0	; the current name list.
	lea		SEARCHNAME(pc),a1
	lea		NAME_BANK(pc),a2
	lea		TYPE_BANK(pc),a3
	move.w	NAMES(pc),d0
	move.w	d0,d1
	add.w		d1,d1
	add.w		d1,d1
	add.w		d1,a3
	move.l	PICTURE_TYPE(pc),(a3)
	mulu		#20,d0
	add.w		d0,a2
	move.b	(a1)+,(a2)+		; set up pathname
	move.b	(a1)+,(a2)+
	move.b	(a1)+,(a2)+
	moveq		#12-1,d0
.name	move.b	(a0)+,(a2)+		; copy whole 12-character filename
	dbra		d0,.name		; as well (8 chars for name, a '.' and
	clr.b		(a2)			; 3 chars for extension)
	addq		#1,NAMES		; inc number of names in list
	rts


FILTER:	dc.l		EXTENSION
EXTENSION:	ds.l		1

		rsreset
DTA_space	rs.b		21
DTA_attr	rs.b		1
DTA_time	rs.w		1
DTA_date	rs.w		1
DTA_size	rs.l		1
DTA_name	rs.b		14
DTA:		ds.b		44	; DTA buffer and contents

NAMES:	ds.w		1
SEARCHNAME:	ds.b		64
NAME_BANK:	ds.b		20*80
TYPE_BANK:	ds.l		80

PICTURE_TYPE:	ds.l	1
CURRENT_NAME:	ds.w	1
DRIVE:		ds.b	1
			even

*-----------------------------------------------------------------------*

NAME_LIST:	dc.b		"PC1"		; filenames to search for (in order)
		dc.b		"TN?"
		dc.b		"PCS"
		dc.b		0
		even

TYPE_LIST:	dc.l		DISPLAY_PC1	; and corresponding display-routs.
		dc.l		DISPLAY_TINY
		dc.l		DISPLAY_PCS

*-----------------------------------------------------------------------*
*	DISPLAY ROUTINES									*
*-----------------------------------------------------------------------*

DISPLAY_PC1:				; show Degas Elite 'PC1' file
	bsr		FLUSH
	bsr		EMPTY_BUFFER
	movem.l	BLANK,d0-d7
	movem.l	d0-d7,COLOUR.w
	move.b	NORM(pc),$FFFF820A.w
	delay		16
	move.l	FILE_POS,a0
	bsr		MAKE_SCR
	bsr		STRANGE_FADE	; does sod-all so far.
	move.w	SPEED,TIMER
.wv	bsr		KEYS			; check for control-keys
	tst.b		QUIT
	bne.s		.rts
	tst.b		HOLD
	bne.s		.held
	tst.w		TIMER
	bne.s		.wv
.rts	rts

.held	bsr		KEYS
	tst.b		QUIT
	bne.s		.rts
	tst.b		HOLD
	bne.s		.held
	rts

DISPLAY_TINY:				; show David Mumper's TINY' format
	bsr		FLUSH
	bsr		EMPTY_BUFFER
	movem.l	BLANK,d0-d7
	movem.l	d0-d7,COLOUR.w
	push.b	$FFFF8260.w
	move.b	NORM(pc),$FFFF820A.w
	delay		16
	move.l	FILE_POS,a0
	bsr		TINY
	bsr		STRANGE_FADE
	move.w	SPEED,TIMER
.wv	bsr		KEYS
	tst.b		QUIT
	bne.s		.rts
	tst.b		HOLD
	bne.s		.held
	tst.w		TIMER
	bne.s		.wv
.rts	pop.b		$FFFF8260.w
	rts

.held	bsr		KEYS
	tst.b		QUIT
	bne.s		.rts
	tst.b		HOLD
	bne.s		.held
	bra.s		.rts

*-----------------------------------------------------------------------*
*	DISPLAY 'PCS' ROUTINES START HERE						*
*-----------------------------------------------------------------------*

DISPLAY_PCS:				; show one of my own snazzy 'PCS' pics.
	bsr		FLUSH			; empty IKBD buffers of any keypresses.
	bsr		EMPTY_BUFFER
	movem.l	BLANK,d0-d7		; empty out palette
	movem.l	d0-d7,COLOUR.w
	move.l	LOG_SCR,a0		; clear LOGICAL screen (SCREEN 1)
	bsr		CLS
	move.l	PHYS_SCR,a0		; clear PHYSICAL screen (SCREEN 2)
	bsr		CLS	
	move.l	FILE_POS,a0		; get address of file
	bsr.s		UNPACK_PCS		; unpack picture onto screen(s).
	delay		10			; wait for 10 vbi's (in case of 50/60Hz
	bsr		ENHANCED_DISPLAY	; switch). Turn on display interrupt.
	move.w	SPEED,d1		; set up display length (in VBI's)
.loop	bsr		KEYS			; check for keypresses
	tst.b		HOLD
	bne.s		.held
	tst.b		QUIT
	bne.s		.out
	addq		#1,TIMER		; wait for 1 VBI
.wtv	tst.w		TIMER
	bne.s		.wtv
	subq		#1,d1			; decrement wait-counter.
	bpl.s		.loop
.out	bsr		STANDARD_DISPLAY	; when done, remove display interrupt.
	movem.l	BLANK,d0-d7		; dump palette
	movem.l	d0-d7,COLOUR.w
	move.l	PHYS_SCR,d0		; reset physical screen address.
	lsr.w		#8,d0
	move.l	d0,$FFFF8200.w
	rts

.held	bsr		KEYS			; comes here when screen is frozen
	tst.b		QUIT			; (spacebar)
	bne.s		.out
	tst.b		HOLD
	bne.s		.held
	bra.s		.out

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	UNPACK A 'PCS' PICTURE								*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*

			rsreset
PCS_width		rs.w	1	; usually 320 for now
PCS_height		rs.w	1	; usually 200 for now
PCS_interlace	rs.b	1	; PCS-ST/E = 0 : SuperHam and Pchrome <> 0
PCS_ste		rs.b	1	; uses ste palette? 50/60Hz?
PCS_start		rs.b	0	; end of file header

;---------------------------------------------------------------------------
;		bit list... 	(PCS_interlace)
;		bit 0		:	if clear > XOR screen1 with screen2
;		bit 1		:	if clear > XOR palette1 with palette2
;		bit 2		:	if set   > interlace on, use bits 0+1,
;					otherwise ignore bits 0+1.
;
;	1.	if bit 2 is CLEAR then ignore bits 0+1.
;	2.	if bit 2 is SET and bit 0 is CLEAR then XOR
;		screen 1 with screen 2 after decompression. (delta-compression)
;	3.	if bit 2 is SET and bit 1 is CLEAR then XOR
;		palette 1 with palette 2 after decompression.
;---------------------------------------------------------------------------
;		bit list... 	(PCS_ste)
;		bit 0		:	if set > use 50Hz otherwise use 60Hz
;		bit 1		:	if set > then pic uses STE palette of 4096.
;
;	1.	if bit 0 is SET then the picture requires 50Hz,
;		otherwise set to 60Hz (STE or not)
;	2.	if bit 1 is SET, then piccy uses 4096 colour palette.
;---------------------------------------------------------------------------
;
;	There are 2 or 4 compressed chunks in each file - 1 bitmap and
;	1 palette for each screen, with 2 screens if it's interlaced.
;
;	The body of a chunk is a 2-byte value (not necessarily on a word
;	boundary) holding the number of control bytes in that compressed
;	chunk. This is followed by a big list of control bytes and data.
;
;	The bitmaps are horizontally byte-run compressed (like Degas)
;	but wrap around the screen instead of terminating on each scanline
;	(unlike Degas, more like Tiny). The screen planes are compressed
;	entirely separately, (the whole of plane 0 followed by the whole
;	of plane 1 etc.) without a break in the compression. It is just
;	one big string of data. If the screen was empty, the entire data
;	would consist of a control byte 0 (get a word), a control word
;	of 32000 (number of repeats), and a byte of 0 (byte to repeat).
;	The palette is compressed the same way, but using compressed words
;	instead of bytes.
;
;       For a given control byte, x: (as Tiny standard)
;
;
;     x < 0   Absolute value specifies the number of unique bytes/words to
;             fetch directly (from 1 to 127)
;
;     x = 0   1 word is taken which specifies the number of times to repeat
;     	  the next data byte/word fetched (from 128 to 32767)
;
;     x = 1   1 word is taken which specifies the number of unique
;     	  bytes/words to be fetched directly (from 128 - 32767)
;
;     x > 1   Specifies the number of times to repeat the next byte/word
;             fetched (from 2 to 127)

UNPACK_PCS:
	sf		INTERLACE		; no interlace yet
	move.l	LOG_SCR,BIT1	; set up screen 1
	move.l	PHYS_SCR,BIT2	; and screen 2 pointers
	move.l	#PALETTE_1,PAL1	; same for palettes
	move.l	#PALETTE_2,PAL2
	lea		PCS_start(a0),a1	; get past file header
	move.l	a0,a6			; keep for later
	move.b	#0,HERZ		; set to 60Hz for now
	btst.b	#0,PCS_ste(a6)	; check real picture frequency,
	beq.s		.hz60			; if 60Hz, then leave as it is
.hz50	move.b	#2,HERZ		; otherwise must be 50Hz
.hz60	move.b	HERZ,$FFFF820A.w	; set up freq.
	move.l	BIT1,a0		; get dest address of bitmap 1
	bsr.s		UNPACK_BITMAP	; unpack it onto screen
	move.l	PAL1,a0		; same with palette
	bsr		UNPACK_PALETTE	; unpack it.
	tst.b		PCS_interlace(a6)	; check for interlaced mode
	beq.s		.done			; if not, skip past it
	st		INTERLACE		; set INTERLACE to TRUE.
	move.l	BIT2,a0		; now unpack second screen and
	bsr.s		UNPACK_BITMAP	; palette in the same way
	move.l	PAL2,a0
	bsr		UNPACK_PALETTE
	bsr		XOR_BITMAP		; do delta-decompression if needed
	bsr		XOR_PALETTE		; on bitmap2 or palette2
.done	add.l		#32,PAL1		; skip past first 16 colours
	add.l		#32,PAL2		; in palette banks
	rts
	
UNPACK_BITMAP:				; decompress a bitmap.
	moveq		#0,d6
	move.w	#40,d2
	move.w	#200,d3
	moveq		#5,d4
	move.b	(a1)+,d7
	lsl.w		#8,d7
	move.b	(a1)+,d7
.Main	moveq		#0,d0
	subq		#1,d7
	bmi.s		.esc
	move.b	(a1)+,d0
	bmi.s		.B_block_copy
	beq.s		.W_run_length
	cmp.b		#1,d0
	beq.s		.W_block_copy
	bra.s		.B_run_length
.W_run_length
	move.b	(a1)+,d0
	lsl.w		#8,d0
	move.b	(a1)+,d0
.B_run_length
	subq		#1,d0
	move.b	(a1)+,d1
.run	move.b	d1,(a0,d6)
	addq		#1,d6
	and.w		#1,d6
	bne.s		.ok
	addq		#8,a0
.ok	subq		#1,d2				; drop 1 line
	bne.s		.fine
	moveq		#40,d2
	subq		#1,d3
	bne.s		.fine
	move.w	#200,d3
	lea		2-32000(a0),a0
	subq		#1,d4
	beq.s		.esc
.fine	dbra		d0,.run
	bra.s		.Main
.esc	rts
.B_block_copy
	neg.b		d0
	bra.s		.nw
.W_block_copy
	move.b	(a1)+,d0
	lsl.w		#8,d0
	move.b	(a1)+,d0
.nw	subq		#1,d0
.blk	move.b	(a1)+,d1
	move.b	d1,(a0,d6)
	addq		#1,d6
	and.w		#1,d6
	bne.s		.ok2
	addq		#8,a0
.ok2	subq		#1,d2				; drop 1 line
	bne.s		.fin2
	moveq		#40,d2
	subq		#1,d3
	bne.s		.fin2
	move.w	#200,d3
	lea		2-32000(a0),a0
	subq		#1,d4
	beq.s		.esc
.fin2	dbra		d0,.blk
	bra		.Main

UNPACK_PALETTE:				; decompress a palette
	move.b	(a1)+,d7
	lsl.w		#8,d7
	move.b	(a1)+,d7
.Main	moveq		#0,d0
	subq		#1,d7
	bmi.s		.esc
	move.b	(a1)+,d0
	bmi.s		.B_block_copy
	beq.s		.W_run_length
	cmp.b		#1,d0
	beq.s		.W_block_copy
	bra.s		.B_run_length
.W_run_length
	move.b	(a1)+,d0
	lsl.w		#8,d0
	move.b	(a1)+,d0
.B_run_length
	subq		#1,d0
	move.b	(a1)+,d1
	lsl.w		#8,d1
	move.b	(a1)+,d1
.run	move.w	d1,(a0)+
	dbra		d0,.run
	bra.s		.Main
.esc	rts
.B_block_copy
	neg.b		d0
	bra.s		.nw
.W_block_copy
	move.b	(a1)+,d0
	lsl.w		#8,d0
	move.b	(a1)+,d0
.nw	subq		#1,d0
.blk	move.b	(a1)+,d1
	lsl.w		#8,d1
	move.b	(a1)+,d1
	move.w	d1,(a0)+
	dbra		d0,.blk
	bra.s		.Main

XOR_BITMAP:						; delta decompression on bitmap.
	btst.b	#0,PCS_interlace(a6)
	bne.s		.nox
	pushall
	move.l	BIT1,a0
	move.l	BIT2,a1
	move.w	#32000/4-1,d0
.blop	move.l	(a0)+,d1
	eor.l		d1,(a1)+
	dbra		d0,.blop
	popall
.nox	rts

XOR_PALETTE:						; delta decompression on palette.
	btst.b	#1,PCS_interlace(a6)
	bne.s		.nox
	pushall
	move.l	PAL1,a0
	move.l	PAL2,a1
	move.w	#16*(3*199+1)-1,d0
.clop	move.w	(a0)+,d1
	eor.w		d1,(a1)+
	dbra		d0,.clop
	popall
.nox	rts

HERZ:		ds.b	1
INTERLACE:	ds.b	1
		even
		
*-----------------------------------------------------------------------*
*	COLOUR SWITCHING ROUTINE							*
*-----------------------------------------------------------------------*
*	This is the actual screen-display interrupt and setup code		*
*-----------------------------------------------------------------------*

SCANLINE		=	$700
VIDEO_COUNTER	=	$FFFF8209

STE_HAM:
	btst		#1,$FFFF820A.w
	bne.s		.hz50
	move.b	#32-10,SCANLINE.w
	move.l	#SCAN_COUNTER_60HZ,HBI_VEC.w
	bra.s		.hz60
.hz50	move.b	#62-10,SCANLINE.w
	move.l	#SCAN_COUNTER_50HZ,HBI_VEC.w
.hz60	move.w	#$2100,sr
	pea		(a0)
	pea		(a1)
	move.l	PAL2(pc),a0
	lea		2*(1-16)(a0),a0
	lea		2+COLOUR.w,a1
	move.w	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	pop.l		a1
	pop.l		a0
.wait	tst.b		SCANLINE.w
	bne.s		.wait
	move.w	#$2300,sr
	push.w	d0
.read	btst		#0,$FFFFFC00.w
	beq.s		.out
	move.b	$FFFFFC02.w,d0
	bra.s		.read
.out	pop.w		d0
	tst.w		TIMER
	ble.s		.rte
	subq		#1,TIMER
.rte	push.l	d0
	move.l	PAL1,d0
	tst.b		INTERLACE
	beq.s		.nin1
	move.l	PAL2,PAL1
.nin1	move.l	d0,PAL2
	move.l	BIT1,d0
	tst.b		INTERLACE
	beq.s		.nin2
	move.l	BIT2,BIT1
.nin2	move.l	d0,BIT2
.nint	lsr.w		#8,d0
	move.l	d0,$FFFF8200.w
	pop.l		d0
.skip	rts

SCAN_COUNTER_50HZ:
	subq.b	#1,SCANLINE.w
	ble.s		SCREEN_RASTER_50HZ
	rte
	
SCREEN_RASTER_50HZ:
	move.w	#$2700,sr
	movem.l	d0-a6,-(sp)
	move.l	a7,.ssp+2
	lea		VIDEO_COUNTER.w,a6
	moveq		#0,d0
	moveq		#64,d7
.wait	move.b	(a6),d0
	beq.s		.wait
	sub.w		d0,d7
	lsl.w		d7,d0
	sync		55,d0
	move.l	PAL2(pc),a7
	rept		199
	movem.l	(a7)+,d0-a6
	movem.l	d0-d7,COLOUR.w
	movem.l	a0-a6,COLOUR.w
	move.l	(a7)+,28+COLOUR.w
	lea		COLOUR.w,a0
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.w	#0,COLOUR.w
	move.l	(a7)+,(a0)+
	sync		7,d0
	endr
.ssp	move.l	#0,a7
	movem.l	(sp)+,d0-a6
	move.l	#ARTE,HBI_VEC.w	
	move.b	#$23,(sp)
ARTE:	rte

SCAN_COUNTER_60HZ:
	subq.b	#1,SCANLINE.w
	ble.s		SCREEN_RASTER_60HZ
	rte
	
SCREEN_RASTER_60HZ:
	move.w	#$2700,sr
	movem.l	d0-a6,-(sp)
	move.l	a7,.ssp+2
	lea		VIDEO_COUNTER.w,a6
	moveq		#0,d0
	moveq		#64,d7
.wait	move.b	(a6),d0
	beq.s		.wait
	sub.w		d0,d7
	lsl.w		d7,d0
	sync		54,d0
	move.l	PAL2(pc),a7	
	rept		199
	movem.l	(a7)+,d0-a6
	movem.l	d0-d7,COLOUR.w
	movem.l	a0-a6,COLOUR.w
	move.l	(a7)+,28+COLOUR.w
	lea		COLOUR.w,a0
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.l	(a7)+,(a0)+
	move.w	#0,COLOUR.w
	move.l	(a7)+,(a0)+
	sync		6,d0
	endr
.ssp	move.l	#0,a7
	movem.l	(sp)+,d0-a6
	move.l	#ARTE,HBI_VEC.w	
	move.b	#$23,(sp)
	rte
	
*-----------------------------------------------------------------------*
*	INITIALISE PCS DISPLAY INTERRUPT						*
*-----------------------------------------------------------------------*

ENHANCED_DISPLAY:
	move.b	#$12,$FFFFFC02.w		; turn off the mouse 'cos it
	lea		VECTOR_STORAGE(pc),a0	; bugs the display-routs.
	move.l	$4D2.w,(a0)+
	move.w	#$2700,sr
	move.l	#STE_HAM,$4D2.w
	move.w	#$2300,sr
.out	rts

STANDARD_DISPLAY:
	lea		VECTOR_STORAGE(pc),a0
	move.w	#$2700,sr
	move.l	(a0)+,$4D2.w
	move.w	#$2300,sr
	move.b	#$8,$FFFFFC02.w		; mouse communication back on
.out	rts

FLUSH:push.w	d7
.read	btst		#0,$FFFFFC00.w	; empty hardware ikbd buffer
	beq.s		.out
	move.b	$FFFFFC02.w,d7
	bra.s		.read
.out	pop.w		d7
	rts

BIT1:			ds.l		1
BIT2:			ds.l		1
PAL1:			ds.l		1
PAL2:			ds.l		1
VECTOR_STORAGE:	ds.b		20

*-----------------------------------------------------------------------*
*	PICTURE UNPACK ROUTINES								*
*-----------------------------------------------------------------------*

STRANGE_FADE:			; just a block copy for now...
	move.l	LOG_SCR,a0
	move.l	PHYS_SCR,a1
	move.w	#32000/4-1,d0
.cpy	move.l	(a0)+,(a1)+
	dbra		d0,.cpy
	delay		1
	movem.l	PALETTE,d0-d7
	movem.l	d0-d7,COLOUR.w
	rts

*-----------------------------------------------------------------------*
*	Display 'PC1' Picture Format     Written by DML 1991			*
*-----------------------------------------------------------------------*

MAKE_SCR:					; unpacks *.pc1 file to LOG_SCR
makebit		macro
.A	move.b	\1,(a1)+		;copy byte
	addq		#1,d3			;count	it
	cmp.b		#40,d3		;end of plane ?
	beq.s		.C
	btst		#0,d3
	bne.s		.D
	addq		#6,a1
.D	dbra		d1,.A
	bra.s		MAKE_LOOP
.C	moveq		#0,d3
	addq		#1,d4			;increase planes finished
	cmp.b		#4,d4			;end of line	?
	beq.s		.E
	sub.w		#152,a1
	bra.s		.D
.E	moveq		#0,d4
	dbra		d5,.D
	endm
	addq		#2,a0
	moveq		#15,d0
	lea		PALETTE,a1
.D	move.w	(a0)+,d1
	move.w	d1,(a1)+
	dbra		d0,.D
	move.l	LOG_SCR,a1		;destination
	moveq		#0,d3			;bytes	this plane (0-39)
	moveq		#0,d4			;planes (0-3)
	move.w	#199,d5		;number of lines to do
MAKE_LOOP
	move.b	(a0)+,d1		;get control	byte
	ext.w		d1
	bpl.s		COPY_BLK		;copy literal
	cmp.b		#-128,d1		;no operation (ignore)
	beq.s		MAKE_LOOP
	neg.w		d1			;copy same byte lots of times
COPY_SAME
	move.b	(a0)+,d2
	makebit	d2
	bra.s		END_MAKE		;finished
COPY_BLK
	makebit	(a0)+			;copy block
END_MAKE
	rts	

*-----------------------------------------------------------------------*
*	Display 'TINY' Picture Format     Written by DML 1991			*
*-----------------------------------------------------------------------*

TINY:	moveq		#8,d6
	moveq		#0,d2
	moveq		#0,d3
	moveq		#0,d4
	move.b	(a0)+,d0
	cmp.b		#2,d0
	ble.s		.ncyc
	addq		#4,a0
	subq.b	#3,d0
.ncyc	move.b	d0,$FFFF8260.w
	moveq		#16-1,d0
	lea		PALETTE(pc),a1
.cols	move.b	(a0)+,d1
	lsl.w		d6,d1
	move.b	(a0)+,d1
	move.w	d1,(a1)+
	dbra		d0,.cols
	move.b	(a0)+,d0
	lsl.w		d6,d0
	move.b	(a0)+,d0
	move.w	d0,d1
	addq		#2,a0
	move.l	a0,a1
	lea		(a0,d1),a2
	move.l	LOG_SCR,a0
	move.l	a0,a3
	
.Main	moveq		#0,d0
	move.b	(a1)+,d0
	bmi.s		.B_block_copy
	beq.s		.W_run_length
	cmp.b		#1,d0
	beq.s		.W_block_copy
	bra.s		.B_run_length

.W_run_length
	move.b	(a1)+,d0
	lsl.w		d6,d0
	move.b	(a1)+,d0
.B_run_length
	subq		#1,d0
	move.b	(a2)+,d1
	lsl.w		d6,d1
	move.b	(a2)+,d1
.run	move.w	d1,(a0)
	lea		160(a0),a0
	addq		#1,d2
	cmp.w		#200,d2			; bottom of screen?
	blt.s		.no1				; no.
	moveq		#0,d2				; if so,go to top,
	lea		8-(160*200)(a0),a0	; start at next column.
	addq		#1,d3				; inc column
	cmp.w		#20,d3			; last column?
	blt.s		.no1				; no.
	moveq		#0,d3				; if so,start at left again,
	addq		#2,d4				; go in 1 column.
	cmp.w		#6,d4				; all columns done?
	bgt.s		.esc				; if so,escape.
	lea		(a3,d4),a0			; get next plane address.
.no1	dbra		d0,.run
	bra.s		.Main

.esc	rts

.B_block_copy
	neg.b		d0
	bra.s		.nw
.W_block_copy
	move.b	(a1)+,d0
	lsl.w		d6,d0
	move.b	(a1)+,d0
.nw	subq		#1,d0
.blk	move.b	(a2)+,d1
	lsl.w		d6,d1
	move.b	(a2)+,d1
	move.w	d1,(a0)
	lea		160(a0),a0
	addq		#1,d2
	cmp.w		#200,d2			; bottom of screen?
	blt.s		.no2				; no.
	moveq		#0,d2				; if so,go to top,
	lea		8-(160*200)(a0),a0	; start at next column.
	addq		#1,d3				; inc column
	cmp.w		#20,d3			; last column?
	blt.s		.no2				; no.
	moveq		#0,d3				; if so,start at left again,
	addq		#2,d4				; go in 1 column.
	cmp.w		#6,d4				; all columns done?
	bgt.s		.esc				; if so,escape.
	lea		(a3,d4),a0			; get next plane address.
.no2	dbra		d0,.blk
	bra		.Main
	
*-------------------------------------------------------------------------*

EXIT:	bsr		RESET_VECTORS
	bsr.s		RESET_SCREENS
	user
	clr.w		-(sp)
	trap		#1

INIT_SCREENS:
	push.w	#2
	trap		#14
	addq		#2,sp
	move.l	d0,OLD_SCR
	push.w	#4
	trap		#14
	addq		#2,sp
	move.w	d0,OLD_REZ
	move.l	#(BUFFER2+255),d0
	clr.b		d0
	move.l	d0,LOG_SCR
	move.l	#(BUFFER1+255),d0
	clr.b		d0
	move.l	d0,PHYS_SCR
	lsr.w		#8,d0
	move.l	d0,$FFFF8200.w
	push.w	#0
	push.l	#-1
	push.l	#-1
	push.w	#5
	trap		#14
	add.w		#12,sp
	movem.l	COLOUR.w,d0-d7
	movem.l	d0-d7,GEM_PAL
	rts

RESET_SCREENS:
	movem.l	GEM_PAL,d0-d7
	movem.l	d0-d7,COLOUR.w
	push.w	OLD_REZ
	push.l	OLD_SCR
	push.l	OLD_SCR
	push.w	#5
	trap		#14
	add.w		#12,sp
	clr.l		$4D2.w
	move.b	NORM(pc),$FFFF820A.w
	rts

INIT_VECTORS:
	lea		VECTORS,a0
	move.l	USP,a1
	move.l	a1,(a0)+
	move.l	HBI_VEC.w,(a0)+
	move.l	VBI_VEC.w,(a0)+
	move.l	KBD_VEC.w,(a0)+
	move.l	TIMER_A.w,(a0)+
	move.l	TIMER_B.w,(a0)+
	move.b	ENABLE_A.w,(a0)+
	move.b	ENABLE_B.w,(a0)+
	move.b	MASK_A.w,(a0)+
	move.b	MASK_B.w,(a0)+
	move.b	DATA_A.w,(a0)+
	move.b	DATA_B.w,(a0)+
	move.b	CTRL_A.w,(a0)+
	move.b	CTRL_B.w,(a0)+
	move.b	VECTOR.w,(a0)+
	move.w	#$2700,sr
	move.l	#GEM_VBI,$4D2.w
	move.w	#$2300,sr
	rts
	
RESET_VECTORS:
	move.w	#$2700,sr
	lea		VECTORS,a0
	move.l	(a0)+,a1
	move.l	a1,USP
	move.l	(a0)+,HBI_VEC.w
	move.l	(a0)+,VBI_VEC.w
	move.l	(a0)+,KBD_VEC.w
	move.l	(a0)+,TIMER_A.w
	move.l	(a0)+,TIMER_B.w
	move.b	(a0)+,ENABLE_A.w
	move.b	(a0)+,ENABLE_B.w
	move.b	(a0)+,MASK_A.w
	move.b	(a0)+,MASK_B.w
	move.b	(a0)+,DATA_A.w
	move.b	(a0)+,DATA_B.w
	move.b	(a0)+,CTRL_A.w
	move.b	(a0)+,CTRL_B.w
	move.b	(a0)+,VECTOR.w
	move.w	#$2300,sr
	rts

GEM_VBI:
	tst.w		TIMER
	ble.s		.rts
	subq		#1,TIMER
.rts	rts

KEYS:	clr.l		KEY
.loop	push.w	#11
	trap		#1
	addq		#2,sp
	tst.l		d0
	beq.s		.none
	push.w	#1
	trap		#1
	addq		#2,sp
	move.l	d0,KEY
	bra.s		.loop
.none	move.l	KEY(pc),d0
	tst.b		d0
	beq.s		.nfre
	cmp.b		#27,d0
	seq		QUIT
	cmp.b		#' ',d0
	seq		HOLD
	cmp.b		#13,d0
	bne.s		.nfre
	sf		HOLD
.nfre	swap		d0
	cmp.b		#59,d0
	blt.s		.nf
	cmp.b		#68,d0
	bgt.s		.nf
	sub.b		#59,d0
	ext.w		d0
	lsl.w		#8,d0
	add.w		d0,d0
	add.w		#50,d0
	move.w	d0,SPEED
.nf	rts

KEY:	ds.l		1
SCAN:	ds.l		1

EMPTY_BUFFER:
	pushall
.bak	push.w	#11
	trap		#1
	addq		#2,sp
	tst.l		d0
	beq.s		.out
	push.w	#7
	trap		#1
	addq		#2,sp
	bra.s		.bak
.out	popall
	rts

SPEED:	dc.w	800	
NORM:		ds.b	1
		even
		
*-------------------------------------------------------------------------*

CLS:	lea		32000(a0),a0	; fast CLS, not really needed for
	moveq		#0,d1			; a slideshow!
	move.l	d1,d2
	move.l	d1,d3
	move.l	d1,d4
	move.l	d1,d5
	move.l	d1,d6
	move.l	d1,d7
	move.l	d1,a1
	move.l	d1,a2
	move.l	d1,a3
	move.l	d1,a4
	move.l	d1,a5
	move.l	d1,a6
	moveq		#25-1,d0
.cls	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d7/a1-a6,-(a0)
	movem.l	d1-d4/a1-a4,-(a0)
	dbra		d0,.cls
	rts

*-------------------------------------------------------------------------*

DECRUNCH:	;include	f:\pack_ice.240\ice_unpa.s
		rts
				
*-------------------------------------------------------------------------*

	SECTION BSS

*-------------------------------------------------------------------------*

BSS_ST:

QUIT:			ds.b		1
HOLD:			ds.b		1
TIMER:		ds.w		1
PHYS_SCR		ds.l		1
LOG_SCR		ds.l		1
OLD_SCR		ds.l		1
OLD_STK		ds.l		1
OLD_REZ		ds.w		1
GEM_PAL		ds.w		16
BLANK:		ds.w		16
PALETTE:		ds.w		16
VECTORS:		ds.b		40

PALETTE_1:		ds.w		16*(3*200+1)
PALETTE_2:		ds.w		16*(3*200+1)
BUFFER1:		ds.b		32256
BUFFER2:		ds.b		32256

BSS_END:

PICTURE:		ds.b		105000