/*
 * Exemple de librairie : cas des paramtres flottants
 */

#include <portab.h>
#include <aes.h>
#include <ldg.h>
#include <math.h>

/* TRUC
 * Un type pour viter les conflicts avec PureC 
 * Ca permet de passer un flottant aussi bien avec
 * PureC que Gcc. Le flottant est encapsul par
 * le long.
 */

typedef union real {
		long dummy;
		double value;
	} Real;

/* prototypages */

char*  CDECL information(VOID);
double CDECL sinus( Real*);
double CDECL cosinus( Real*);

/*
 * tableau de taille  modifier pour mettre toutes 
 * les addresses des procdures  prsenter 
 */

PROC LibFunc[] = { 
"information", "/* Retourne une chaine info sur la lib*/\n"
			   "char *information( VOID);\n", information,
"sinus", 	   "/* La fonction mathmatique sinus*/\n"
			   "double sinus( double *x);\n", sinus,
"cosinus", "/* La fonction mathmatique cosinus*/\n"
			   "double cosinus( double *x);\n", cosinus };

LDGLIB LibLdg[]={ 
				  0x0101,	/* version de la lib */
				  3,		/* nombre de fonctions dans la lib */
				  LibFunc,	/* Adresse des fonctions */
				  "Cette librairie illustre le cas des passages de paramtres flottant.",	/* Chaine d'information */
				  0    		/* Flags de la lib, obligatoire */
				};


/*
 *	Les fonctions de la librairie servant aux clients
 */

char* CDECL information(VOID) {
	return("[1][Dbut de librairie Mathmatique!!!][Ok]");
}

double CDECL sinus( Real *val) {
	return( sin(val->value));
}

double CDECL cosinus( Real *val) {
	return( cos(val->value));
}

/*
 *	boucle principale: communication de la librairie avec les clients
 */

int main( void) {
	ldg_init( LibLdg);
	return 0;
}
