/*
*
* Library with MagiC-specific functions
*
*/

#include <portab.h>
#include <tos.h>
#include <string.h>
#include <aes.h>
#include <magx.h>
#include "magxlib.h"


#ifndef NULL
#define NULL 0L
#endif
#define P_COOKIES	0x5a0



/*******************************************************************
*
* Ascertain cookie.
*
*******************************************************************/

static LONG __init_cookie(void)
{
	return(* ((LONG *) P_COOKIES));
}

ULONG *get_cookie(ULONG val)
{
	ULONG *cookie;

	cookie = (ULONG *) Supexec(__init_cookie);
	if	(!cookie)
		return(NULL);
	while(*cookie)
		{
		if	(*cookie == val)
			return(cookie+1);
		cookie += 2;
		}
	return(NULL);
}


/*******************************************************************
*
* Ascertain MagiC version.
* ========================
*
* If <crdate> != NULL then the creation date will be 
* returned in the form yyyymmdd. With "<" and ">" one 
* can then ascertain directly whether a given function 
* is available with the MagiC version to hand.
*
* Return: 	0		no MagiC installed
*			-1		we're still in the AUTO-folder
*			0x0a0b	version a.b
*
*******************************************************************/

WORD get_MagiC_ver(ULONG *crdate)
{
	ULONG *cookie;
	AESVARS *av;

	cookie = get_cookie('MagX');
	if	(!cookie)
		return(0);
	av = ((MAGX_COOKIE *) (*cookie))->aesvars;
	if	(!av)
		return(-1);
	if	(crdate)
		{
		*crdate = av->date << 16L;							 /* yyyy0000 */
		*crdate |= av->date >> 24L;							 /* yyyy00dd */
		*crdate |= (av->date >> 8L) & 0xff00L;	 /* yyyymmdd */
		}
	return(av->version);
}


/****************************************************************
*
* Makes an F(BOX)TEXT object scrollable when MagiC is running
*
* If <is_scroll> is FALSE, then the text field will only be 
* converted to a user character-string.
*
* In the RCS the text field should be left empty, the mask and 
* the validation character-string must, however, be input as the
* RCS otherwise goes on strike.
* For scrolling fields a new mask has to be created, the one 
* installed in the .RSC file can not be used because it is too short.
* The mask created here consists only of '_' characters, because this 
* covers 99.9% of all application cases for scrolling objects. 
* The length of the validation character-string is of no importance, 
* i.e. it must be at least 1, because the AES automatically replicates 
* the last character of the validation string until it reaches the 
* length of the text field.
*
* The maximum length for the input character-string is in each 
* case (TEDINFO.te_txtlen - 1).
*
****************************************************************/

void init_scrlted(OBJECT *o, WORD is_scroll, XTED *xted,
				char *txt, char *tmplt, WORD len)
{
	TEDINFO *t;

	t = o->ob_spec.tedinfo;
	t->te_just = TE_LEFT;		      /* Important! */
	t->te_ptext = txt;
	if	(is_scroll)
		{
		memset(tmplt, '_', len);	  /* New mask */
		tmplt[len] = '\0';
		xted->xte_ptmplt = tmplt;
		xted->xte_pvalid = t->te_pvalid;
		xted->xte_vislen = t->te_tmplen - 1;
		xted->xte_scroll = 0;
		
		t->te_tmplen = len+1;
		t->te_ptmplt = NULL;
		t->te_pvalid = (void *) xted;
		}
	t->te_txtlen = t->te_tmplen;
}
