/*
	Tabulator width: 3
	Comments from: Column 60											*Column 60*

*/

#ifndef	__PRN_DIALOGS__
#define	__PRN_DIALOGS__

typedef struct _prn_tray												/* Description of paper feed/eject trays*/
{
	struct _prn_tray	*next;
	
	int32	tray_id;															/* Number of feed or eject tray */
	int8	name[32];														/* Name of tray */
} PRN_TRAY;

typedef struct _media_size												/* Description of a paper format */
{
	struct _media_size	*next;

	int32			size_id;													/* ID of the paper format */
	int8			name[32];												/* Name of paper format */
} MEDIA_SIZE;

typedef struct _media_type												/* Description of a paper-type/print-medium */
{
	struct _media_type	*next;

	int32			type_id;													/* ID of the paper format */
	int8			name[32];												/* Name of paper format */
} MEDIA_TYPE;

typedef struct _prn_mode												/* Description of a printer */
{
	struct _prn_mode *next;												/* Pointer to the next print mode */

	int32			mode_id;													/* Mode-ID  (index within the file) */
	int16			hdpi;														/* Horizontal resolution in dpi */
	int16			vdpi;														/* Vertical resolution in dpi */
	int32			mode_capabilities;									/* Mode capabilities */

	int32			color_capabilities;									/* Available colour modes */
	int32			dither_flags;											/* Flags that specify whether the corresponding colour mode is available with or without dithering */
	MEDIA_TYPE	*paper_types;											/* Suitable paper types */
	int32			reserved;

	int8			name[32];												/* Mode name */
} PRN_MODE;

/* old_printer can also be 0L */
typedef int32	(cdecl *PRN_SWITCH)( struct _drv_entry *drivers, struct _prn_settings *settings, struct _prn_entry *old_printer, struct _prn_entry *new_printer );

/* sub_flags */
#define	PRN_STD_SUBS	0x0001										/* Standard sub-dialogs for NVDI printers */
#define	PRN_FSM_SUBS	0x0002										/* Standard sub-dialogs for FSM-printers */
#define	PRN_QD_SUBS		0x0004										/* Standard sub-dialogs for QuickDraw printers */

typedef struct _prn_entry												/* Device description */
{
	struct _prn_entry	*next;											/* Pointer to the next device description */
	int32			length;													/* Structure length */
	int32			format;													/* Data format */
	int32			reserved;												/* Reserved */
	
	int16			driver_id;												/* Driver ID */
	int16			driver_type;											/* Driver type */
	int32			printer_id;												/* Printer ID */
	int32			printer_capabilities;								/* Printer capabilities */
	int32			reserved1;

	int32			sub_flags;												/* Flags for the sub-dialogs */
	struct _pdlg_sub	*sub_dialogs;									/* Pointer to the list of sub-dialogs for this printer */
	PRN_SWITCH	setup_panel;											/* Initialise sub-dialog at printer change */
	PRN_SWITCH	close_panel;											/* Close sub-dialog at printer change */

	PRN_MODE		*modes;													/* List of available resolutions */
	MEDIA_SIZE	*papers;													/* List of available paper formats */
	PRN_TRAY		*input_trays;											/* List of feed trays */
	PRN_TRAY		*output_trays;											/* List of output trays */

	int8			name[32];												/* Name of printer */
} PRN_ENTRY;

typedef struct	_dither_mode
{
	struct _dither_mode	*next;
	int32			length;													/* Structure length */
	int32			format;													/* Data format */
	int32			reserved;												/* Reserved */

	int32			dither_id;												/* ID */
	int32			color_modes;											/* Supported colour depths */
	int32			reserved1;
	int32			reserved2;

	int8			name[32];												/* Name of dither mode */
} DITHER_MODE;


typedef struct
{
	int32			magic;													/* 'pdnf' */
	int32			length;													/* Structure length */
	int32			format;													/* Data format */
	int32			reserved;												/* Reserved */

	int16			driver_id;												/* Driver number for the VDI */
	int16			driver_type;											/* Driver type */
	int32			reserved1;
	int32			reserved2;
	int32			reserved3;

	PRN_ENTRY	*printers;												/* List or printers belonging to driver */
	DITHER_MODE	*dither_modes;											/* List of dither modes supported by driver */
	int32			reserved4;
	int32			reserved5;

	int32			reserved6;
	int32			reserved7;
	int32			reserved8;
	int32			reserved9;
	
	int8			device[128];											/* Output file of printer driver */
	
} DRV_INFO;

typedef struct _drv_entry
{
	struct _drv_entry	*next;
} DRV_ENTRY;

#define	PDLG_CHG_SUB	0x80000000L
#define	PDLG_IS_BUTTON	0x40000000L

#define	PDLG_PREBUTTON	0x20000000L
#define	PDLG_PB_OK		1
#define	PDLG_PB_CANCEL	2
#define	PDLG_PB_DEVICE	3

#define	PDLG_BUT_OK		( PDLG_PREBUTTON + PDLG_PB_OK )
#define	PDLG_BUT_CNCL	( PDLG_PREBUTTON + PDLG_PB_CANCEL )
#define	PDLG_BUT_DEV	( PDLG_PREBUTTON + PDLG_PB_DEVICE )

typedef	int32 (cdecl *PDLG_INIT)( struct _prn_settings *settings, struct _pdlg_sub *sub );
typedef	int32	(cdecl *PDLG_HNDL)( struct _prn_settings *settings, struct _pdlg_sub *sub, int16 exit_obj );
typedef	int32	(cdecl *PDLG_RESET)( struct _prn_settings *settings, struct _pdlg_sub *sub );

typedef struct _pdlg_sub												/* Sub-dialog for device settings */
{
	struct _pdlg_sub *next;												/* Pointer to the successor in the list */
	int32			length;													/* Structure length */
	int32			format;													/* Data format */
	int32			reserved;												/* Reserved */
	
	void			*drivers;												/* Only for internal dialogs */
	int16			option_flags;											/* Flags, inc. PDLG_PRINTING, PDLG_PREFS */
	int16			sub_id;													/* ID for sub-dialogs, is entered for global sub-dialogs of pdlg_add() */
	DIALOG		*dialog;													/* Pointer to structure of the window dialog or 0L */
	OBJECT		*tree;													/* Pointer to the assembled object tree */
	int16			index_offset;											/* Index offset of the sub-dialog */
	int16			reserved1;
	int32			reserved2;
	int32			reserved3;
	int32			reserved4;

	PDLG_INIT	init_dlg;												/* Initialising function */
	PDLG_HNDL	do_dlg;													/* Servicing function */
	PDLG_RESET	reset_dlg;												/* Reset function */
	int32			reserved5;

	OBJECT		*sub_icon;												/* Pointer to the icon for the listbox */
	OBJECT		*sub_tree;												/* Pointer to the object tree of the sub-dialog */
	int32			reserved6;
	int32			reserved7;

	int32			private1;												/* Dialog-specific information */
	int32			private2;
	int32			private3;
	int32			private4;

} PDLG_SUB;

#endif