;Tabulator width:	3
;Comments:  																;From Column 60

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	Pure C Startup Code
;
;	ARGV and the passsing of long filenames in double quotes are supported
;
;	07.10.95
;  English translation: Peter West, April 99

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Exporting references

						EXPORT	exit										;void	exit( WORD status );
						EXPORT	__exit
			
						EXPORT	_BasPag									;Address of Basepage
						EXPORT	_StkLim									;Lower stack limit
						EXPORT	_PgmSize									;Size of the program (TPA)
						EXPORT	_app										;Flag for accessory (0) or application (1)
						EXPORT	errno										;Global error variable
						EXPORT	_AtExitVec
						EXPORT	_FilSysVec
						EXPORT	_RedirTab
			
						EXPORT	__text
						EXPORT	__data
						EXPORT	__bss

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Importing references

						IMPORT	main										;WORD main( WORD argc, BYTE **argv, BYTE **envp );
						IMPORT	_fpumode									;Type of FPU
						IMPORT	_StkSize									;Size of stack
						IMPORT	_FreeAll									;Function for releasing memory

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;The BASEPAGE structure

						OFFSET	0

p_lowtpa:			ds.l	1												;Address of TPA
p_hitpa:				ds.l	1												;First byte after the TPA

p_tbase:				ds.l	1												;Address of TEXT segement
p_tlen:				ds.l	1												;Length of TEXT segment

p_dbase:				ds.l	1												;Address of DATA segment
p_dlen:				ds.l	1												;Length of DATA segment

p_bbase:				ds.l	1												;Address of BSS segment
p_blen:				ds.l	1												;Length of BSS segment

p_dta:				ds.l	1												;Pointer to default-DTA

p_parent:			ds.l	1												;Pointer to basepage of process to be called

p_resrvd0:			ds.l	1												;Reserved

p_env:				ds.l	1												;Pointer to environment strings
p_resrvd1:			ds.b	80												;Reserved
p_cmdlin:			ds.b	128											;Command line

sizeof_BASEPAGE:	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

						TEXT
__text:																		;Start address of TEXT segment

						bra.b		start_me_up								;Skip the header

						dc.l		_RedirTab								;Pointer to redirection table
						dc.l		_StkSize									;Size of stack

						ALIGN	16

						dc.b	'Pure C',0									;Copyright reference

						ALIGN	16

start_me_up:		move.l	a0,d0										;Accessory?
						bne.b		is_acc

						move.l	4(sp),a3									;Pointer to basepage
						moveq		#1,d0										;Application
						bra.b		is_app

is_acc:				movea.l	a0,a3										;Pointer to basepage
						clr.w		d0											;Accessory

is_app:				move.l	a3,_BasPag								;Pointer to basepage
						move.w	d0,_app									;Flag accessory/application

;Establish memory requirements

						move.l	p_tlen(a3),d1							;Length of TEXT segment
						add.l		p_dlen(a3),d1							;Length of DATA segment
						add.l		p_blen(a3),d1							;Length of BSS segment
						add.l		#sizeof_BASEPAGE,d1					;Length of basepage
						move.l	d1,_PgmSize								;Program length

;Set stack
						move.l	d1,d2										;Length
						add.l		a3,d2										;Pointer to basepage
						and.b		#$fc,d2									;Round to Longword boundary
						move.l	d2,sp										;Address of stack

						tst.w		d0											;Accessory?
						beq		chk_fpu

;Release memory

						move.l	d1,-(sp)									;Memory requirement
						move.l	a3,-(sp)									;Address of basepage
						clr.w		-(sp)										;Reserved
						move.w	#74,-(sp)								;Mshrink
						trap		#1
						lea.l		12(sp),sp

;Examine environment strings

						move.l	sp,d0
						sub.l		#_StkSize-4,d0
						and.b		#$fc,d0									;Adjust to Longword boundary
						movea.l	d0,a1										;envp[] starts with the lowest stack address
						move.l	a1,a4										;Store
						move.l	p_env(a3),a2							;Pointer to environment strings

scan_env_loop:		move.l	a2,(a1)+									;Save address in envp[]
						movea.l	a2,a5										;Save Address
						tst.b		(a2)+										;End of environment string?
						beq.b		scan_env_end
						
scan_env_str:		tst.b		(a2)+										;Up to end of string
						bne.b		scan_env_str

						movep.w	0(a5),d0
						swap		d0
						movep.w	1(a5),d0									;'ARGV' produces in this case 'AGRV'
						cmpi.l	#'AGRV',d0								;'ARGV' produces in this case 'AGRV'
						bne.b		scan_env_loop
						cmpi.b	#'=',4(a5)								;'=' ?
						bne.b		scan_env_loop
						cmpi.b	#127,p_cmdlin(a3)						;Command line 127 bytes long?
						bne.b		scan_env_loop

						clr.b		(a5)										;Terminate environment (remove ARGV)
						clr.l		-4(a1)									;Clear last envp[] 
						movea.l	a1,a5										;argv[] starts directly after envp[]
						moveq		#0,d3										;argc is 0
						move.l	a2,(a1)+									;Pointer to first string

scan_ARGV:			tst.b		(a2)+										;Scan for end of string
						bne.b		scan_ARGV
						
						move.l	a2,(a1)+									;Pointer to next argument
						addq.w	#1,d3										;Increment argc
						tst.b		(a2)										;Last environment string?
						bne.b		scan_ARGV

						bra		scan_end

scan_env_end:		clr.l		-4(a1)									;Clear last envp[]

;Examine command line

scan_cmd_line:		lea		p_cmdlin(a3),a0						;Pointer to command line
						move.b	(a0),d1									;Length of command line
						ext.w		d1
						movea.l	a1,a5										;Store argv[]

						move.l	a0,(a1)+									;argv[0]: Pointer to first string
						clr.b		(a0)+										;Empty string
						moveq		#1,d3										;argc
						move.l	a0,(a1)+									;argv[1]: Pointer to second string

						moveq		#' ',d4									;Space
						moveq		#39,d5									;Single-quote mark (')
						moveq		#'"',d6									;Double-quote mark (")
						
						bra.b		scan_next
						
scan_cmd_loop:		move.b	(a0)+,d0
						cmp.b		d4,d0										;Space or divider character?
						bhi.b		scan_squote
	
						tst.b		-2(a0)									;Is previous byte a Nullbyte?
						bne.b		scan_eos									;End of a string

						addq.l	#1,-4(a1)								;Correct address of string
						bra.b		scan_term								;Then ignore space character
						
scan_squote:		cmp.b		d5,d0										;Filename in ' single-quotes?
						bne.b		scan_dquote

						move.l	-4(a1),d0
						addq.l	#1,d0
						cmp.l		d0,a0										;Single-quote within text?
						bne.b		scan_dquote

						addq.l	#1,-4(a1)								;Correct address of string

scan_snglquote:	cmp.b		(a0)+,d5									;' Single-quote?
						dbeq		d1,scan_snglquote
						subq.w	#1,d1										;End of string?
						bmi.b		scan_end
						beq.b		scan_eos									;No further characters follow

						cmp.b		(a0),d5									;Additional single-quote
						bne.b		scan_eos									;Otherwise end of filename?
						
						movea.l	-(a1),a2									;Pointer to start of string						
						movea.l	a0,a3										;Pointer to second single-quote
						
scan_move_args:	move.b	-2(a3),-(a3)							;Move string by one byte
						cmpa.l	a2,a3
						bhi.b		scan_move_args

						addq.l	#1,a0										;Pointer to past second single-quote
						subq.w	#1,d1										;Reduce length of command line
						addq.l	#1,(a1)+									;Correct address of string
						bra.b		scan_snglquote							;Scan for next single-quote character

scan_dquote:		cmp.b		d6,d0										;Filename in double-quotes?
						bne.b		scan_next

						addq.l	#1,-4(a1)								;Correct address of string

scan_dblquote:		cmp.b		(a0)+,d6									;Double-quote character?
						dbeq		d1,scan_dblquote
						subq.w	#1,d1										;End of string?
						bmi.b		scan_end

scan_eos:			move.l	a0,(a1)+									;Start address of new string
						addq.w	#1,d3										;Increment argc
scan_term:			clr.b		-1(a0)									;Terminate string
						
scan_next:			subq.w	#1,d1
						bpl.b		scan_cmd_loop

						tst.b		-1(a0)									;Is last byte a Nullbyte?
						beq.b		scan_end									;Then ignore space character

						addq.w	#1,d3										;Increment argc
						clr.b		(a0)										;Terminate string
						addq.l	#4,a1

scan_end:			movea.l	a1,a6										;Lower stack limit
						clr.l		-(a1)										;Clear last argv[]

chk_fpu:				clr.w		_fpumode									;Not an Atari FPU

						lea		256(a6),a6								;Add 256 bytes for calls of the libraries
						move.l	a6,_StkLim								;Lowest stack address

						clr.w		errno										;Delete global error variable (extlib)
						clr.l		_AtExitVec								;Delete vector for atexit() (stdlib function)
						clr.l		_FilSysVec								;Delete vector for termination of filesystem

;Jump to main()

						move.w	d3,d0										;argc
						movea.l	a5,a0										;argv
						movea.l	a4,a1										;envp
						
						jsr		main										;WORD	main( WORD argc, BYTE **argv, BYTE **envp );


;void	exit( WORD status );

exit:					move.w	d0,-(sp)									;Save return value for Pterm()

						move.l	_AtExitVec,d0							;Were functions installed with atexit()?
						beq.b		__exit
			
						movea.l	d0,a0
						jsr		(a0)

__exit:				move.l	_FilSysVec,d0							;Any files still to be closed or written back?
						beq.b		exit_free
			
						movea.l	d0,a0
						jsr		(a0)										;Call file functions

exit_free:			jsr		_FreeAll									;Release memory blocks

						move.w	#76,-(sp)								;Pterm()
						trap		#1


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
						DATA
__data:																		;Start address of DATA segment

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
						BSS
__bss:																		;Start address of BSS segment

_BasPag:				ds.l	1												;Pointer to basepage
_app:					ds.w	1												;Flag 0: Accessory / 1: Application
_StkLim:				ds.l	1												;Lower stack limit
_PgmSize:			ds.l	1												;Length of program (the TPA)
_RedirTab:			ds.l	6												;Table for output redirection

errno:				ds.w	1												;Global error variable (extlib)
_AtExitVec:			ds.l	1												;Vector for atexit() (stdlib function)
_FilSysVec:			ds.l	1												;Vector for termination of filesystem

						END
