*
*
* Structures and constants for the Assembler-portion
* of a MagiC-XFS
*
* Version: Andreas Kromke, 23.5.97
*
*

     OFFSET

mxk_version:        DS.W      1
mxk_fast_clrmem:    DS.L      1
mxk_toupper:        DS.L      1
mxk__sprintf:       DS.L      1
mxk_act_pd:         DS.L      1
mxk_act_appl:       DS.L      1
mxk_keyb_app:       DS.L      1
mxk_pe_slice:       DS.L      1
mxk_pe_timer:       DS.L      1
mxk_appl_yield:     DS.L      1
mxk_appl_suspend:   DS.L      1
mxk_appl_begcritic: DS.L      1
mxk_appl_endcritic: DS.L      1
mxk_evnt_IO:        DS.L      1
mxk_evnt_mIO:       DS.L      1
mxk_evnt_emIO:      DS.L      1
mxk_appl_IOcomplete:DS.L      1
mxk_evnt_sem:       DS.L      1
mxk_Pfree:          DS.L      1
mxk_int_msize:      DS.W      1
mxk_int_malloc:     DS.L      1
mxk_int_mfree:      DS.L      1
mxk_resv_intmem:    DS.L      1
mxk_diskchange:     DS.L      1
mxk_DMD_rdevinit:	DS.L		1
mxk_ker_proc_info:	DS.L		1
mxk_ker_mxalloc:	DS.L		1
mxk_ker_mfree:		DS.L		1
mxk_ker_mshrink:	DS.L		1

	OFFSET

dfsk_version:		DS.W	1
dfsk_dir_srch:		DS.L	1
dfsk_reopen_FD:	DS.L	1
dfsk_close_DD:		DS.L	1
dfsk_match_8_3:	DS.L	1
dfsk_conv_8_3:		DS.L	1
dfsk_init_DTA:		DS.L	1

     OFFSET

dev_close:     DS.L      1
dev_read:      DS.L      1
dev_write:     DS.L      1
dev_stat:      DS.L      1
dev_seek:      DS.L      1
dev_datime:    DS.L      1
dev_ioctl:     DS.L      1
dev_getc:      DS.L      1
dev_getline:   DS.L      1
dev_putc:      DS.L      1

     OFFSET

dd_dmd:        DS.L      1    /* 0x00: Pointer to DMD                      */
dd_refcnt:     DS.W      1    /* 0x04: Ref. counter for standard paths     */

     OFFSET

fd_dmd:        DS.L      1    /* 0x00: Pointer to DMD                      */
fd_refcnt:     DS.W      1    /* 0x04: Ref. counter for closing or -1      */
fd_mode:       DS.W      1    /* 0x06: Opening mode (0,1,2) and flags      */
fd_dev:        DS.L      1    /* 0x08: Pointer to MX_DEV                   */

     OFFSET

dhd_dmd:       DS.L      1    /* 0x00: Pointer to DMD                      */

     OFFSET

dta_res1:      DS.B      20
dta_drive:     DS.B      1    /* 0x14: */
dta_res2:      DS.B      1    /* 0x15: */
dta_time:      DS.W      1    /* 0x16: Found time                          */
dta_date:      DS.W      1    /* 0x18: Found date                          */
dta_len:       DS.L      1    /* 0x1a: Found length                        */
dta_name:      DS.B      14   /* 0x1e: Found filename                      */

     OFFSET

d_xfs:         DS.L      1    /* 0x00: The file system driver              */
d_drive:       DS.W      1    /* 0x04: Drive number 0..25                  */
d_root:        DS.L      1    /* 0x06: Pointer to DD of the root           */
d_biosdev:     DS.W      1    /* 0x0a: BIOS-drive or -1                    */
d_driver:      DS.L      1    /* 0x0c: With devcode this defines the medium*/
d_devcode:     DS.L      1    /* 0x10: e.g. SCSI target & drive            */

     OFFSET

xattr_mode:    DS.W      1    /* %ttttsssrwxrwxrwx                         */
                              /* Bit 12,13,14,15: File type                */
                              /*         2: BIOS special file              */
                              /*         4: Directory file                 */
                              /*         8: Regular file                   */
                              /*        10: fifo                           */
                              /*        12: Memory region or process       */
                              /*        14: Symbolic link                  */
                              /* Bit 9,10,11: Special bits                 */
                              /*         1: sticky bit (?)                 */
                              /*         2: setgid (?)                     */
                              /*         4: setuid (?)                     */
                              /* Bit 0..8: Access modes                    */
                              /*         rwx for user/group/world          */
xattr_index:   DS.L      1
xattr_dev:     DS.W      1
xattr_res1:    DS.W      1
xattr_nlink:   DS.W      1
xattr_uid:     DS.W      1
xattr_gid:     DS.W      1
xattr_size:    DS.L      1
xattr_blksize: DS.L      1
xattr_nblocks: DS.L      1
xattr_mtime:   DS.W      1
xattr_mdate:   DS.W      1
xattr_atime:   DS.W      1
xattr_adate:   DS.W      1
xattr_ctime:   DS.W      1
xattr_cdate:   DS.W      1
xattr_attr:    DS.W      1
xattr_res2:    DS.W      1
xattr_res3:    DS.L      2
xattr_sizeof:

     OFFSET

xfs_name:      DS.B      8
xfs_next:      DS.L      1
xfs_flags:     DS.L      1
xfs_init:      DS.L      1
xfs_sync:      DS.L      1
xfs_pterm:     DS.L      1
xfs_garbcoll:  DS.L      1
xfs_freeDD:    DS.L      1
xfs_drv_open:  DS.L      1
xfs_drv_close: DS.L      1
xfs_path2DD:   DS.L      1
xfs_sfirst:    DS.L      1
xfs_snext:     DS.L      1
xfs_fopen:     DS.L      1
xfs_fdelete:   DS.L      1
xfs_link:      DS.L      1
xfs_xattr:     DS.L      1
xfs_attrib:    DS.L      1
xfs_chown:     DS.L      1
xfs_chmod:     DS.L      1
xfs_dcreate:   DS.L      1
xfs_ddelete:   DS.L      1
xfs_DD2name:   DS.L      1
xfs_dopendir:  DS.L      1
xfs_dreaddir:  DS.L      1
xfs_drewinddir: DS.L     1
xfs_dclosedir: DS.L      1
xfs_dpathconf: DS.L      1
xfs_dfree:     DS.L      1
xfs_wlabel:    DS.L      1
xfs_rlabel:    DS.L      1
xfs_symlink:   DS.L      1
xfs_readlink:  DS.L      1
xfs_dcntl:     DS.L      1

     OFFSET

p_lowtpa:      DS.L      1    /* 0x00: Start of TPA, the BP itself         */
p_hitpa:       DS.L      1    /* 0x04: Points 1 byte past TPA              */
p_tbase:       DS.L      1    /* 0x08: Start of TEXT segment               */
p_tlen:        DS.L      1    /* 0x0c: Length of TEXT segment              */
p_dbase:       DS.L      1    /* 0x10: Start of DATA segment               */
p_dlen:        DS.L      1    /* 0x14: Length of DATA segment              */
p_bbase:       DS.L      1    /* 0x18: Start of BSS segment                */
p_blen:        DS.L      1    /* 0x1c: Length of BSS segment               */
p_dta:         DS.L      1    /* 0x20: Current DTA buffer                  */
p_parent:      DS.L      1    /* 0x24: Pointer to BP of the parent         */
p_procid:      DS.W      1	/* 0x28: Process ID        				*/
p_res1:        DS.W      1
p_env:         DS.L      1    /* 0x2c: Pointer to environment              */
p_devx:        DS.B      6
p_res2:        DS.B      1
p_defdrv:      DS.B      1    /* 0x37: Default drive                       */
p_res3:        DS.B      8
p_drvx:        DS.B     32	/* 0x40	*/
p_res4:		DS.L		1	/* 0x60	*/
p_umask:		DS.W		1	/* 0x64: Mask for file permissions			*/
p_res5:        DS.W		1	/* 0x66	*/
p_mem:         DS.L      1
p_context:     DS.L      1
p_mflags:      DS.L      1
p_mres3:       DS.L      1
p_mres4:       DS.L      1
p_reg:         DS.L      1
p_cmdlin:      DS.B    128    /* 0x80: Command line                        */

     TEXT

/* Standard handles */

STDIN               EQU  0
STDOUT              EQU  1
STDAUX              EQU  2
STDPRN              EQU  3
STDHDL4             EQU  4
STDHDL5             EQU  5

/* Write/Read modes for Fgetchar and Fputchar */

CMODE_RAW           EQU  0
CMODE_COOKED        EQU  1
BCMODE_COOKED       EQU  0
CMODE_ECHO          EQU  2
BCMODE_ECHO         EQU  1

/* Opening mode of files (MagiC-internal)                                  */
/* NOINHERIT is not supported, as according to TOS convention only the     */
/* handles 0..5 are inherited                                              */
/* High byte as used under MiNT    

OM_RPERM       EQU  1         /* File is opened for reading                */
BOM_RPERM      EQU  0
OM_WPERM       EQU  2         /* File is opened for writing                */
BOM_WPERM      EQU  1
OM_EXEC        EQU  4         /* File is opened for execution              */
BOM_EXEC       EQU  2
OM_APPEND      EQU  8         /* Write accesses to the end (kernel!)       */
BOM_APPEND     EQU  3
OM_RDENY       EQU  16        /* Others may not read simultaneously        */
BOM_RDENY      EQU  4
OM_WDENY       EQU  32        /* Others may not write simultaneously       */
BOM_WDENY      EQU  5
OM_NOCHECK     EQU  64        /* NO checking by the kernel                 */
BOM_NOCHECK    EQU  6


/* Opening mode of files (MiNT) */
O_RWMODE       EQU  3         /* Mask for r/w-modes 					*/
O_RDONLY       EQU  0
O_WRONLY       EQU  1
O_RDWR         EQU  2
O_EXEC         EQU  3

O_APPEND       EQU  8         /* Write always to the end of the file       */
BO_APPEND      EQU  3

O_SHMODE       EQU  $70
O_COMPAT       EQU  0
O_DENYRW       EQU  $10
O_DENYW        EQU  $20
O_DENYR        EQU  $30
O_DENYNONE     EQU  $40

O_NOINHERIT    EQU  $80       ; Not supported by MagiC
O_NDELAY       EQU  $100      ; Not supported by MagiC
O_CREAT        EQU  $200
BO_CREAT       EQU  9
O_TRUNC        EQU  $400
BO_TRUNC       EQU  10
O_EXCL         EQU  $800
BO_EXCL        EQU  11
O_TTY          EQU  $2000     ; Not supported by MagiC
O_HEAD         EQU  $4000     ; Not supported by MagiC
O_LOCK         EQU  $8000     ; Not supported by MagiC

; Supported Dcntl-modes (MagiC-specific!)
KER_GETINFO    EQU  $0100     /* Kernel: Return pointer to kernel     	*/
KER_DOSLIMITS  EQU  $0101     /* Kernel: Limits for FAT file systems 		*/
KER_INSTXFS    EQU  $0200     /* Kernel: Install an XFS 				*/
DFS_GETINFO    EQU  $1100     /* XFS_DOS: Return pointer to DFS-kernel 	*/
DFS_INSTDFS    EQU  $1200     /* XFS_DOS: Install a DFS 				*/
DEV_M_INSTALL  EQU  $cd00     /* DFS_U 								*/

; Supported Fcntl-modes
FSTAT          EQU  $4600
FIONREAD       EQU  $4601
FIONWRITE      EQU  $4602
FUTIME         EQU  $4603
FTRUNCATE      EQU  $4604
SHMGETBLK      EQU  $4d00
SHMSETBLK      EQU  $4d01
PBASEADDR      EQU  $5002

LASTDRIVE      EQU  'Z'-'A'   ; Highest drive number

/* Modes and codes for Dpathconf() */

DP_MAXREQ      EQU  -1
DP_IOPEN       EQU  0    /* Internal limit on number of open files 		*/
DP_MAXLINKS    EQU  1    /* Max. number of hard links to a file 			*/
DP_PATHMAX     EQU  2    /* Max. path name length 					*/
DP_NAMEMAX     EQU  3    /* Max. length of an individual file name 		*/
DP_ATOMIC      EQU  4    /* No. of bytes that can be written atomically 	*/
DP_TRUNC       EQU  5    /* File name truncation behavior 				*/
 DP_NOTRUNC    EQU  0    /* Long filenames give an error 				*/
 DP_AUTOTRUNC  EQU  1    /* Long filenames truncated 					*/
 DP_DOSTRUNC   EQU  2    /* DOS truncation rules in effect 				*/
DP_CASE        EQU  6
 DP_CASESENS   EQU  0    /* Case sensitive 							*/
 DP_CASECONV   EQU  1    /* Case always converted 					*/
 DP_CASEINSENS EQU  2    /* Case insensitive, preserved 				*/
DP_MODEATTR    EQU  7
 DP_ATTRBITS   EQU  $000000ff
 DP_MODEBITS   EQU  $000fff00
 DP_FILETYPS   EQU  $fff00000
  DP_FT_DIR    EQU  $00100000
  DP_FT_CHR    EQU  $00200000
  DP_FT_BLK    EQU  $00400000
  DP_FT_REG    EQU  $00800000
  DP_FT_LNK    EQU  $01000000
  DP_FT_SOCK   EQU  $02000000
  DP_FT_FIFO   EQU  $04000000
  DP_FT_MEM    EQU  $08000000
DP_XATTRFIELDS EQU  8
 DP_INDEX      EQU  $0001
 DP_DEV        EQU  $0002
 DP_RDEV       EQU  $0004
 DP_NLINK      EQU  $0008
 DP_UID        EQU  $0010
 DP_GID        EQU  $0020
 DP_BLKSIZE    EQU  $0040
 DP_SIZE       EQU  $0080
 DP_NBLOCKS    EQU  $0100
 DP_ATIME      EQU  $0200
 DP_CTIME      EQU  $0400
 DP_MTIME      EQU  $0800

/* For Psemaphores, the modes 0/1 are not supported at present */

PSEM_CRGET     EQU  0    /* Create and get 							*/
PSEM_DESTROY   EQU  1
PSEM_GET       EQU  2
PSEM_RELEASE   EQU  3
