/*
 *	Librairie ME.LDG
 *	module  compiler et  linker avec les autres modules du client
 *
 * Dvelopp par Arnaud BERCEGEAY <bercegeay@atari.org>
 *
 */

#include <ldg.h>
#include "me_ldg.h"

/* definitions des pointeurs sur fonctions */

long cdecl (*RIM_OpenImg)(MEIMG * meimg, char * filename, long mode) = NULL;
long cdecl (*RIM_CloseImg)(MEIMG * meimg) = NULL;
long cdecl (*RIM_LoadImg)(MEIMG * meimg, long mode, long no_algo, short * global) = NULL;
MELIST* cdecl (*RIM_CreateNewList)( long mode ) = NULL;
void cdecl (*RIM_DeleteList)( MELIST * melist ) = NULL;
long cdecl (*RIM_DoConfig)( char * filename ) = NULL;
MELIST* cdecl (*WIM_CreateNewList)( long mode ) = NULL;
void cdecl (*WIM_DeleteList)( MELIST * melist ) = NULL;
long cdecl (*WIM_DoConfig)( char * filename ) = NULL;
TRMLIST* cdecl (*TRM_CreateNewList)( void ) = NULL;
void cdecl (*TRM_DeleteList)( TRMLIST * trmlist ) = NULL;
void cdecl (*ME_CompressPalette)(char * palette, long size) = NULL;
void cdecl (*ME_ExplainError)( short * global) = NULL;
void cdecl (*ME_Init)( short * global, long mode) = NULL;


/* definition de la structure LDG de me.ldg */

LDG *ldg_me = NULL;


/* initialisation de ces variables */

long init_ldg_me (LDG * ldg_me) 
{
	RIM_OpenImg = ldg_find("RIM_OpenImg",ldg_me);
	RIM_CloseImg = ldg_find("RIM_CloseImg",ldg_me);
	RIM_LoadImg = ldg_find("RIM_LoadImg",ldg_me);
	RIM_CreateNewList = ldg_find("RIM_CreateNewList",ldg_me);
	RIM_DeleteList = ldg_find("RIM_DeleteList",ldg_me);
	RIM_DoConfig = ldg_find("RIM_DoConfig",ldg_me);
	WIM_CreateNewList = ldg_find("WIM_CreateNewList",ldg_me);
	WIM_DeleteList = ldg_find("WIM_DeleteList",ldg_me);
	WIM_DoConfig = ldg_find("WIM_DoConfig",ldg_me);
	TRM_CreateNewList = ldg_find("TRM_CreateNewList",ldg_me);
	TRM_DeleteList = ldg_find("TRM_DeleteList",ldg_me);
	ME_CompressPalette = ldg_find("ME_CompressPalette",ldg_me);
	ME_ExplainError = ldg_find("ME_ExplainError",ldg_me);
	ME_Init = ldg_find("ME_Init",ldg_me);
	
	if (ME_Init)
		(*ME_Init)(ldg_global,0L);
			
	if (   (RIM_OpenImg!=NULL) && (RIM_CloseImg!=NULL) && (RIM_LoadImg!=NULL)
	    && (ME_CompressPalette!=NULL)
	    && (ME_ExplainError!=NULL) && (ME_Init!=NULL)
	    && (RIM_DoConfig) && (RIM_CreateNewList)
	    && (RIM_DeleteList)
	    && (WIM_DoConfig) && (WIM_CreateNewList)
	    && (WIM_DeleteList)
	    && (TRM_CreateNewList) && (TRM_DeleteList))
	{
		return 0L ; /* tout est ok */
	}
	
	return -1L; /* manque au moins une fonction */ 
}


/* eof */
