/*
 *	Opration Popupthon: un popup pour Olivier Landemarre
 *	Longueur de la tabulation : 4
 *	Version PureC / Gcc
 */

#define PCGEMLIB 1 /* mettre 1 si les utilisateurs de Pure C
					* utilise les librairies GEM Pure C */

/* Fichiers headers */

#include <portab.h>
#if PCGEMLIB
#include <aes.h>
#include <vdi.h>
#else
#include <aesbind.h>
#include <vdibind.h>
#endif
#include <stdlib.h>
#include <ldg.h>
#include <mt_aes.h>

/* Macros */
#define max(a,b)	(((a)>(b))?(a):(b))

/* Prototypages */
char * CDECL __infos( VOID);
VOID CDECL __get_bkgr( LONG handle, LONG of_x, LONG of_y, LONG of_w, LONG of_h, MFDB *img);
VOID CDECL __put_bkgr( LONG handle, LONG of_x, LONG of_y, LONG of_w, LONG of_h, MFDB *img);
WORD CDECL __popup	 ( OBJECT *menu, LONG x, LONG y, LONG item, WORD *gl);

/* Variables globales */
PROC Proc[]  = {
"__infos",    "/* Retourne une chaine info sur la lib*/\n"
			   "char *information( VOID);\n", (void *)__infos,
"__get_bkgr", "/* Sauvegarde fond cran */\n"
			  "VOID (*_get_bkgr)( LONG handle, LONG of_x, LONG of_y, LONG of_w, LONG of_h, MFDB *img);\n", (void *)__get_bkgr,
"__put_bkgr", "/* Restauration fond cran*/\n"
			  "VOID (*_put_bkgr)( LONG handle, LONG of_x, LONG of_y, LONG of_w, LONG of_h, MFDB *img);\n", (void *)__put_bkgr,
"__popup",    "/* Routine popup */\n"
			  "WORD (*_popup)( OBJECT *menu, LONG x, LONG y, LONG item, AESGL *global);", (void *)__popup};

char Info[] = "Librarie de gestion de PopUp. Dominique Brziat 1997/1998";

LDGLIB Ldg[] = {
				0x0100,	/* version de la lib, recommand */
				4,		/* nombre de fonction dans la lib */
				Proc,	/* Pointeurs vers nos fonctions */
				Info,	/* Information sur la lib */
				0x0    	/* Flags de la lib, obligatoire */
				};

/* 
 * Fonctions de la librairie
 */

char* CDECL __infos( VOID) {
	return("[1][Librairie PopUp:|1 - sauvegarde fond cran|2 - restoration fond cran|3 - popup][OK]");
}

/*
 *	Sauve la portion d'cran (x,y,w,h) en mmoire (structure MFDB)
 */

VOID CDECL __get_bkgr( LONG handle, 
					   LONG of_x, LONG of_y, LONG of_w, LONG of_h, 
					   MFDB *img) {
	int pxy[8];
	size_t taille;
	MFDB ecr = {0};		/* Ecran logique */
	int work[57];

	vq_extnd( (int)handle, 1, work);
		
	/* Taille tampon de copie fond */
	/* work[4] = nombre de plans */

	taille = ((((size_t)(of_w / 16) + ((of_w % 16) != 0)) * 2 * (size_t)work[ 4]) * (size_t)of_h) + 256; 
	
	img->fd_addr = malloc (taille);			/* Rserver tampon */
	img->fd_w = (int)of_w;						/* Remplir la structure MFDB */
	img->fd_h = (int)of_h;
	img->fd_wdwidth = ((int)of_w / 16) + (((int)of_w % 16) != 0);
	img->fd_stand = 1;
	img->fd_nplanes = work[ 4];

	pxy[0] = (int)of_x;		/* Remplir le tableau */
	pxy[1] = (int)of_y;
	pxy[2] = pxy[0] + (int)of_w - 1;
	pxy[3] = pxy[1] + (int)of_h - 1;
	pxy[4] = 0;
	pxy[5] = 0;
	pxy[6] = (int)of_w - 1;
	pxy[7] = (int)of_h - 1;
	v_hide_c ( (int)handle);							/* Virer la souris */
	vro_cpyfm ( (int)handle, S_ONLY, pxy, &ecr, img);	/* Copier l'image */
	v_show_c ( (int)handle, 1);							/* Remettre la souris */
}

/* Restaure la portion d'cran contenue dans img aux coodonnes
   (x,y,w,h) 
 */

VOID CDECL __put_bkgr( LONG handle, 
					   LONG of_x, LONG of_y, LONG of_w, LONG of_h,
					   MFDB *img) {
	int pxy[8];
	MFDB ecr = {0};		/* Ecran logique */

	pxy[0] = 0;		/* Remplir le tableau */
	pxy[1] = 0;
	pxy[2] = (int)of_w - 1;
	pxy[3] = (int)of_h - 1;
	pxy[4] = (int)of_x;
	pxy[5] = (int)of_y;
	pxy[6] = (int)of_x + (int)of_w - 1;
	pxy[7] = (int)of_y + (int)of_h - 1;
	v_hide_c ( (int)handle);								/* Remettre la souris */
	vro_cpyfm ( (int)handle, S_ONLY, pxy, img, &ecr);	/* Copier l'image */
	v_show_c ( (int)handle, 1);							/* Virer la souris */
	free ( img->fd_addr);							/* Librer la mmoire */
}

int vdihandle(void)
{
	int	work_in[11], work_out[57], i;
	
	for( i=0; i<10; work_in[i++]=1);
	work_in[10]=2;
	v_opnvwk(work_in, &i, work_out);
	return i;
}

/*
 * MenuPopUp()
 * Version plus simple que celui de ma lib
 * menu: l'arbre du menu popup
 * x,y: position d'affichage
 * retour: l'index de l'item selectionn ou -1
 *
 * Remarque que la fonction n'utilise pas de TIMER
 * mais que des vnements MU_M1, ainsi ca prend moins
 * de temps machine.
 */

WORD CDECL __popup( OBJECT *menu, LONG x, LONG y, LONG item, WORD *gl) {
	MFDB fond;
	int res,key;
	int dum,but;
	int last_choice = -1;
	int new_choice;
	int xclip, yclip, wclip, hclip;
	/* Parametres pour evnt_multi */
	int m1_flag;
	int m1_x;
	int m1_y;
	int m1_w;
	int m1_h;
	int mx,my;
	int buff[8];
	int handle;	
	
	/* Crer une station virtuelle */
	handle = vdihandle();

	/* position du popup */

	if( (int)item != -1) {
		mt_objc_offset( menu, (int)item, &xclip, &yclip, gl);
		x += (menu->ob_x - xclip);
		y += (menu->ob_y - yclip);
	}

	/* On recale par rapport  la taille d'cran */
	mt_wind_get( 0, WF_WORKXYWH, &xclip, &yclip, &wclip, &hclip, gl);
	
	if( x+menu->ob_width>xclip+wclip)
		menu -> ob_x = xclip+wclip-menu->ob_width-1;
	else
		menu -> ob_x = (int)x;
	if( y+menu->ob_height>yclip+hclip)
		menu -> ob_y = yclip+hclip-menu->ob_height-1;
	else
		menu -> ob_y = (int)y;

	xclip=menu->ob_x-3;
	yclip=menu->ob_y-3;
	wclip=menu->ob_width+6;
	hclip=menu->ob_height+6;

	/* Sauvegarde fond d'cran */
	__get_bkgr( handle, xclip, yclip, wclip, hclip, &fond);
	
	/* Affichage Popup */
	mt_objc_draw( menu, 0, MAX_DEPTH, xclip, yclip, wclip, hclip, gl);
	
	/* Reserver les venements */
	mt_wind_update ( BEG_MCTRL, gl);
	
	/* Gestion des venements par EvntMulti() */

	mt_graf_mkstate( &mx, &my, &but, &dum, gl);
	
	/* initialiser les paramtres pour MU_M1 */
	last_choice = mt_objc_find( menu, 0, 2, mx, my, gl);
	if( last_choice == -1) {
		last_choice = max((int)item,0);
		m1_flag = 0;
	} else
		m1_flag = 1;
	
	if( last_choice != -1 &&
		!(menu[last_choice].ob_flags & SELECTABLE)) {
		m1_x = mx-1;
		m1_y = my-1;
		m1_w = 2;
		m1_h = 2;
	} else {
		int ix,iy;
		
		mt_objc_offset( menu, last_choice, &ix, &iy, gl);
		x = ix;
		y = iy;
		m1_x = (int)x;
		m1_y = (int)y;
		m1_w = menu[last_choice].ob_width;
		m1_h = menu[last_choice].ob_height;
	}
	if( menu[last_choice].ob_flags & SELECTABLE)
		mt_objc_change( menu, last_choice, 0, 
						xclip, yclip, wclip, hclip, 
						SELECTED, 1, gl);

	key = 0;
	do {
		res = mt_evnt_multi(
					MU_BUTTON|MU_M1,
				 	1, 1, but?0:1,
					m1_flag, m1_x, m1_y, m1_w, m1_h,
					0, 0, 0, 0, 0,
					buff,
					0L,
					&mx, &my,
					&dum, &dum, &dum, &dum, 
					gl);

		if( res & MU_M1) {
			key = 0;
			new_choice = mt_objc_find( menu, 0, 2, mx, my, gl);
			if( last_choice != new_choice) {
				mt_graf_mouse( M_OFF, 0L, gl);
				if( last_choice != -1 && menu[ last_choice].ob_flags & SELECTABLE
					&& !(menu[ last_choice].ob_state & DISABLED))
				{
					mt_objc_change( menu, last_choice, 0, 
									xclip, yclip, wclip, hclip, NORMAL, 1, 
									gl);
				}
				last_choice = new_choice;
				if( new_choice != -1 && menu[ new_choice].ob_flags & SELECTABLE 
					&& !(menu[ new_choice].ob_state & DISABLED))
				{
		    		mt_objc_change( menu, new_choice, 0, 
		    						xclip, yclip, wclip, hclip, SELECTED, 1,
		    						gl);
				}
				
				/* choisir le nouveau rectangle M1 */
				if( key == 0) {
				 	if( new_choice == -1) { /* hors formulaire */
				 		dum = 0;
				 		m1_flag = 0;
				 	} else {				/* dans formulaire */
				 		dum = new_choice;
				 		m1_flag = 1;
				 	}
				 	if( new_choice != -1 &&		/* dans formulaire & objet non selectionnable */
				 		!(menu[new_choice].ob_flags & SELECTABLE) ) {
				 		m1_x = mx-1;
						m1_y = my-1;
						m1_w = 2;
						m1_h = 2;
				 	} else {
				 		int ix, iy;
				 		
				 		mt_objc_offset( menu, dum, &ix, &iy, gl);
				 		x = ix;
				 		y = iy;
						m1_x = (int)x;
						m1_y = (int)y;
						m1_w = menu[dum].ob_width;
						m1_h = menu[dum].ob_height;
					}
				}
				graf_mouse( M_ON, 0L);
			}
		}
		
	} while( !(res & MU_BUTTON));

	/* fin */

	/* enlever le popup */

	mt_wind_update ( END_MCTRL, gl);
	__put_bkgr( handle, xclip, yclip, wclip, hclip, &fond);

	if( new_choice != -1 && menu[ new_choice].ob_flags & SELECTABLE)
	{
		menu[ new_choice].ob_state &= ~SELECTED;
		if( menu[ new_choice].ob_state & DISABLED)
			new_choice = -1;
	}
	
	v_clsvwk( handle);
	return new_choice;
}

#ifndef DEBUG

int main( void) {
	ldg_init( Ldg);
	return 0;
}

#endif