/*
	Tabulator width: 3
	Comments from: Column 60											*Column 60*

*/

#ifndef	__PRN_SETTINGS__
#define	__PRN_SETTINGS__

/*----------------------------------------------------------------------------------------*/ 
/* Setable colour modes of a printer mode																*/
/*----------------------------------------------------------------------------------------*/ 
#define	CC_MONO			0x0001										/* 2 grey levels */
#define	CC_4_GREY		0x0002										/* 4 grey levels */
#define	CC_8_GREY		0x0004										/* 8 grey levels */
#define	CC_16_GREY		0x0008										/* 16 grey levels */
#define	CC_256_GREY		0x0010										/* 256 grey levels */
#define	CC_32K_GREY		0x0020										/* 32768 colours in grey levels wandeln */
#define	CC_65K_GREY		0x0040										/* 65536 colours in grey levels wandeln */
#define	CC_16M_GREY		0x0080										/* 16777216 colours in grey levels wandeln */

#define	CC_2_COLOR		0x0100										/* 2 colours */
#define	CC_4_COLOR		0x0200										/* 4 colours */
#define	CC_8_COLOR		0x0400										/* 8 colours */
#define	CC_16_COLOR		0x0800										/* 16 colours */
#define	CC_256_COLOR	0x1000										/* 256 colours */
#define	CC_32K_COLOR	0x2000										/* 32768 colours */
#define	CC_65K_COLOR	0x4000										/* 65536 colours */
#define	CC_16M_COLOR	0x8000										/* 16777216 colours */

#define	NO_CC_BITS		16

/*----------------------------------------------------------------------------------------*/ 
/* Setable dithering modes																				*/
/*----------------------------------------------------------------------------------------*/ 
#define	DC_NONE			0												/* No dithering modes */
#define	DC_FLOYD			1												/* Simple Floyd-Steinberg */

#define	NO_DC_BITS		1

/*----------------------------------------------------------------------------------------*/ 
/* Printer capabilities																							*/
/*----------------------------------------------------------------------------------------*/ 
#define	PC_FILE			0x0001										/* Printer can be addressed via GEMDOS files */
#define	PC_SERIAL		0x0002										/* Printer can be accessed on the serial port */
#define	PC_PARALLEL		0x0004										/* Printer can be accessed on the parallel port */
#define	PC_ACSI			0x0008										/* Printer can output on the ACSI port */
#define	PC_SCSI			0x0010										/* Printer can output on the SCSI port */

#define	PC_BACKGROUND	0x0080										/* Driver can print in background */

#define	PC_SCALING		0x0100										/* Driver can scale page */
#define	PC_COPIES		0x0200										/* Driver can produce copies of a page */

/*----------------------------------------------------------------------------------------*/ 
/* Mode capabilities																							*/
/*----------------------------------------------------------------------------------------*/ 
#define	MC_PORTRAIT		0x0001										/* Page can be output in portrait format */
#define	MC_LANDSCAPE	0x0002										/* Page can be output in landscape format */
#define	MC_REV_PTRT		0x0004										/* Page can be output turned 180 deg. in portrait format */
#define	MC_REV_LNDSCP	0x0008										/* Page can be output turned 180 deg. in landscape format */
#define	MC_ORIENTATION	0x000f

#define	MC_SLCT_CMYK	0x0400										/* Driver kann bestimmte Farbebenen ausgeben */
#define	MC_CTRST_BRGHT	0x0800										/* Driver kann Kontrast und Helligkeit verndern */

/*----------------------------------------------------------------------------------------*/ 
/* plane_flags																										*/
/*----------------------------------------------------------------------------------------*/ 
#define	PLANE_BLACK		0x0001
#define	PLANE_YELLOW	0x0002
#define	PLANE_MAGENTA	0x0004
#define	PLANE_CYAN		0x0008


/* <driver_mode> */
#define	DM_BG_PRINTING	0x0001										/* Flag for background printing */

/*----------------------------------------------------------------------------------------*/ 
/*----------------------------------------------------------------------------------------*/ 

/* <page_flags> */
#define	PG_EVEN_PAGES	0x0001										/* Only output even-numbered pages */
#define	PG_ODD_PAGES	0x0002										/* Only output odd-numbered pages */

/* <first_page/last_page> */
#define	PG_MIN_PAGE		1
#define	PG_MAX_PAGE		9999

/* <orientation> */
#define	PG_UNKNOWN		0x0000										/* Orientation unknown or not adjustable */
#define	PG_PORTRAIT		0x0001										/* Output page in portrait format */
#define	PG_LANDSCAPE	0x0002										/* Output page in landscape format */

typedef struct _prn_settings
{
	int32	magic;															/* 'pset' */
	int32	length;															/* Structure length */
	int32	format;															/* Structure type */
	int32	reserved;

	int32	page_flags;														/* Flags, inc. even pages, odd pages */
	int16	first_page;														/* First page to be printed */
	int16	last_page;														/* Last page to be printed */
	int16	no_copies;														/* Number of copies */
	int16	orientation;													/* Orientation */
	fixed	scale;															/* Scaling: 0x10000L corresponds to 100% */

	int16 driver_id;														/* VDI device number */
	int16	driver_type;													/* Type of selected driver */
	int32	driver_mode;													/* Flags, inc. for background printing */
	int32	reserved1;
	int32	reserved2;
	
	int32	printer_id;														/* Printer number */
	int32	mode_id;															/* Mode number */
	int16	mode_hdpi;														/* Horizontal resolution in dpi */
	int16	mode_vdpi;														/* Vertical resolution in dpi */
	int32	quality_id;														/* Print mode (hardware-set quality, e.g. Microweave or Econofast) */

	int32	color_mode;														/* Colour mode */
	int32	plane_flags;													/* Flags for number of colour planes to be output (e.g. cyan only) */
	int32	dither_mode;													/* Dithering mode */
	int32	dither_value;													/* Parameter for dithering mode */

	int32	size_id;															/* Paper format */
	int32	type_id;															/* Paper type (normal, glossy) */
	int32	input_id;														/* Paper feed tray */
	int32	output_id;														/* Paper eject tray */

	fixed	contrast;														/* Contrast: 0x10000L corresponds to normal setting */
	fixed	brightness;														/* Brightness: 0x1000L corresponds to normal setting */
	int32	reserved3;
	int32	reserved4;

	int32	reserved5;
	int32	reserved6;
	int32	reserved7;
	int32	reserved8;

	int8	device[128];													/* Filename for printout */

#ifdef __PRINTING__
	TPrint	mac_settings;												/* Settings of the Mac printer-driver */
#else
	struct
	{
		uint8	inside[120];
	} mac_settings;
#endif

} PRN_SETTINGS;

#endif
