/* Tabulator width: 5 */


#ifndef NULL
#define NULL        ( ( void * ) 0L )
#endif

#define N_OBJS 16

#define TOP_WINOBJS	(NAME+CLOSER+FULLER+BACKDROP+ICONIFIER)
#define RGT_WINOBJS (UPARROW+DNARROW+VSLIDE)
#define BOT_WINOBJS (LFARROW+RTARROW+HSLIDE)

/* WINDOW-structure for MagiC-kernel */

typedef struct {
	WORD state;
	WORD attr;
	void *own;			/* (APPL *) */
	WORD kind;			/* from wind_create() */
	char	*name;			/* Pointer to title line */
	char	*info;			/* Pointer to Info line	*/
	GRECT curr;
	GRECT prev;
	GRECT full;
	GRECT work;
	GRECT overall;			/* Outline */
	GRECT unic;
	GRECT min;			/* Minimum size */
	WORD	oldheight;		/* Old height of shading	*/
	WORD	hslide;		 	/* Horizontal slider position */
	WORD vslide; 			/* Vertical slider position */
	WORD hslsize;			/* Horizontal slider size */
	WORD vslsize;			/* Vertical slider size */
	void *wg;				/* Rectangle list */
	void *nextwg;			/* Next rectangle of the list */
	WORD	whdl;
	OBJECT tree[N_OBJS];
	WORD is_sizer;
	WORD is_info;
	WORD is_rgtobjects;
	WORD is_botobjects;
	TEDINFO ted_name;
	TEDINFO ted_info;
} WININFO;

/* Bits of state */

#define OPENED 1
#define COVERED 2
#define ACTIVE 4
#define LOCKED 8
#define ICONIFIED 32
#define SHADED 64

/* Passing structure for linking in */

typedef struct {
	WORD		version;		/* Version number of structure */
	LONG		wsizeof;		/* Size of the WINDOW-structure */
	WORD		whshade;		/* Height of the shaded window */
	void		(*wbm_create)( WININFO *w );
	void		(*wbm_skind)( WININFO *w );
	void		(*wbm_ssize)( WININFO *w );
	void		(*wbm_sslid)( WININFO *w, WORD vertical );
	void		(*wbm_sstr)( WININFO *w );
	void		(*wbm_sattr)( WININFO *w, WORD chbits );
	void		(*wbm_calc)( WORD kind, WORD *fg );
	WORD		(*wbm_obfind)( WININFO *w, WORD x, WORD y );
} WINFRAME_HANDLER;

/* Passing structure for global window settings */

typedef struct {
	WORD		flags;
	WORD		h_inw;
	void		*finfo_inw;
} WINFRAME_SETTINGS;

/* Bits of flags */

#define NO_BDROP 1

extern WINFRAME_SETTINGS *settings;
extern WORD h_inw;
extern int vdi_handle;
extern OBJECT *adr_window;
