;
;
; MagiC Device Driver Development Kit
; ===================================
;
; Assembler Include-file for error codes
;
; (C) Andreas Kromke, 1994
;
;

E_OK           EQU    0       ;   0     OK, no error
ERROR          EQU   -1       ;  -1     Basic, fundamental error
EDRVNR         EQU   -2       ;  -2     Drive not ready
EUNCMD         EQU   -3       ;  -3     Unknown command
E_CRC          EQU   -4       ;  -4     CRC error
EBADRQ         EQU   -5       ;  -5     Bad request
E_SEEK         EQU   -6       ;  -6     Seek error
EMEDIA         EQU   -7       ;  -7     Unknown medium
ESECNF         EQU   -8       ;  -8     Sector not found
EPAPER         EQU   -9       ;  -9     Out of paper
EWRITF         EQU  -10       ; -$A     Write fault
EREADF         EQU  -11       ; -$B     Read fault
EGENRL         EQU  -12       ; -$C     General error (from TOS 3.06 on)
EWRPRO         EQU  -13       ; -$D     Write protect
E_CHNG         EQU  -14       ; -$E     Impermissible media change
EUNDEV         EQU  -15       ; -$F     Unknown device
EBADSF         EQU  -16       ; -$10    Verify error - bad sectors on format
EOTHER         EQU  -17       ; -$11    Insert other disk (A<->B)

EINVFN         EQU  -32       ; -$20    Invalid function number
EFILNF         EQU  -33       ; -$21    File not found
EPTHNF         EQU  -34       ; -$22    Path not found
ENHNDL         EQU  -35       ; -$23    No handles left
EACCDN         EQU  -36       ; -$24    Access denied
EIHNDL         EQU  -37       ; -$25    Invalid handle
ENSMEM         EQU  -39       ; -$27    Insufficient memory
EIMBA          EQU  -40       ; -$28    Invalid memory block address
EDRIVE         EQU  -46       ; -$2E    Invalid drive was specified
ENSAME         EQU  -48       ; -$30    Not the same drive
ENMFIL         EQU  -49       ; -$31    No more files
ELOCKED        EQU  -58       ;          MiNT: Device locked
ENSLOCK        EQU  -59       ;          MiNT: Unlock error
ERANGE         EQU  -64       ; -$40    Invalid file pointer - range error
EINTRN         EQU  -65       ; -$41    Internal error
EPLFMT         EQU  -66       ; -$42    Invalid program load format
EGSBF          EQU  -67       ; -$43    Setblock failure
EBREAK         EQU  -68       ; -$44    KAOS: User break (^C)
EXCPT          EQU  -69       ; -$45    KAOS: 68000  exception (bombs)

* MiNT errors:

EMOUNT         EQU  -200      ;         Returns path2DD for root/..

* MagiC errors:

ELINK          EQU  -300      ;         File is symbolic link

