/*
*
* Body of a "shared library"
*
* Andreas Kromke
* 22.10.97
*
*/

#include <portab.h>
#include <tos.h>
#include <tosdefs.h>
#pragma warn -par

typedef void *PD;

char *mem;               /* Here global memory */

/*****************************************************************
*
* The init-function is called once during loading the library.
* For this it runs as a process of the library, i.e. files can
* be opened and memory can be reserved that belong to the library
* in each case.
* Warning: The files opened in this way may _NOT_ be accessed
*          by the library functions, because these run in the
*          context of the caller.
*
* Warning: The init-function runs in supervisor mode, as a
*          library generally does not have a user stack.
*          Hence it must not use too much stack space (max. 1kB)
*          and may not run too long (because multitasking is
*          blocked in supervisor mode).
*          But if necessary a user stack can be allocated and one
*          can then switch to user mode.
*
*****************************************************************/

extern LONG cdecl slb_init( void )
{
     mem = Malloc(4096L);
     if     (mem)
          return(E_OK);
     else     return(ENSMEM);
}

/*****************************************************************
*
* The exit-function is called once during releasing the library.
* For this it runs as a process of the library, i.e. files can
* be opened and memory can be reserved that belong to the library
* in each case.
*
* Warning: The exit-function runs in supervisor mode, as a
*          library generally does not have a user stack.
*          Hence it must not use too much stack space (max. 1kB)
*          and may not run too long (because multitasking is
*          blocked in supervisor mode).
*          But if necessary a user stack can be allocated and one
*          can then switch to user mode.
*
*****************************************************************/

extern void cdecl slb_exit( void )
{
     Mfree(mem);
}


/*****************************************************************
*
* The open-function is called once during opening of the library 
* by an application process. For this it runs as a process of the 
* caller, i.e. files can be opened and memory can be reserved that 
* belong to the caller in each case.
*
* The kernel ensures that each process does not open the library 
* several times, and that the library is always closed properly.
*
* Warning: The open-function runs in user mode, and actually with
*          the user stack of the caller. This means that the caller,
*          even when running in supervisor mode, always has to make
*          a sufficiently large usp available.
*
*****************************************************************/

extern LONG cdecl slb_open( PD *pd )
{
     return(E_OK);
}


/*****************************************************************
*
* The close-function is called once during closing of the library 
* by an application process. For this it runs as a process of the 
* caller, i.e. files can be opened and memory can be reserved and
* released, that belongs to the caller in each case.
*
* Warning: The close-function runs in user mode, and actually with
*          the user stack of the caller. This means that the caller,
*          even when running in supervisor mode, always has to make
*          a sufficiently large usp available.
*
*****************************************************************/

extern void cdecl slb_close( PD *pd )
{
}


/*****************************************************************
*
* An example library function.
* It is executed in the context of the caller, and actually with
* the stack of the caller (depending on status usp or ssp).
*
* It is strongly recommended to call the functions of an SLB only in
* user mode, so as to ensure compatibility to later implementations.
*
*****************************************************************/

extern LONG cdecl slb_fn0( PD *pd, LONG fn, WORD nargs, char *s )
{
     Cconws(s);
     Cconws("\r\n Key: ");
     Cconin();
     return(E_OK);
}
