/****************************************************************
*
*             WINFRAME                             1.7.98
*             ========
* Last change: English translation: Peter West, April 99
*
* Tabulator width: 5
*
* Written with Pure C V1.1
* Project file: WINFRAME.PRJ
*
* Alternative window-frame manager (example) for MagiC 6.
* The program is executed as a shared library (SLB).
*
****************************************************************/

#include <mgx_dos.h>
#include <mt_aes.h>
#include <string.h>
#include "globals.h"
#include "win_objs.h"
#include "winframe.h"

extern char __text[];
typedef void *PD;

OBJECT *adr_window;

WINFRAME_HANDLER old_wfh,new_wfh;
WINFRAME_SETTINGS *settings;
WORD h_inw;


/*********************************************************************
*
* Register window-frame manager with the AES
*
*********************************************************************/

static WORD sys_set_winframe_manager( WINFRAME_HANDLER *old_wfh,
						WINFRAME_HANDLER *new_wfh,
						WINFRAME_SETTINGS **set )
{
	PARMDATA d;
	static WORD	c[] = { 0, 1, 1, 2 };

	d.intin[0] = 6;			/* Subcode 6: Window-frame manager */
	d.addrin[0] = old_wfh;
	d.addrin[1] = new_wfh;
	_mt_aes( &d, c, NULL );
	if	(set)
		*set = d.addrout[0];
	return( d.intout[0] );
}


/*****************************************************************
*
* Initialise library.
* The library does not have its own ap_id. Despite this we need
* the appl_init() for initialising our global field.
*
*****************************************************************/

LONG cdecl slb_init( void )
{
	char *path,*name;


	/* Initialisation */
	/* -------------- */

	if   ((appl_init()) < 0)
		return(ERROR);

	/* Search for RSC file in the path of the SLB */
	/* ------------------------------------------ */

	path = __text-128;
	name = strrchr(path, '\\');
	if	(name)
		name++;
	else	name = path;
	strcpy(name, "winframe.rsc");
	if	(!rsrc_load(path))
		{
		form_xerr(EFILNF, "winframe.rsc");
		return(EFILNF);
		}

	rsrc_gaddr(0, T_WINDOW, &adr_window);
	global_init();

	/* Configure manager */
	/* ----------------- */

	new_wfh.version = old_wfh.version = 2;
	new_wfh.wsizeof = sizeof(WININFO);
	new_wfh.whshade = 18;		/* Height of shaded window */
	new_wfh.wbm_create = wbm_create;
	new_wfh.wbm_skind = wbm_skind;
	new_wfh.wbm_ssize = wbm_ssize;
	new_wfh.wbm_sslid = wbm_sslid;
	new_wfh.wbm_sstr = wbm_sstr;
	new_wfh.wbm_sattr = wbm_sattr;
	new_wfh.wbm_calc = wbm_calc;
	new_wfh.wbm_obfind = wbm_obfind;

	/* Install manager */
	/* --------------- */

	if	(!sys_set_winframe_manager(&old_wfh, &new_wfh,
					&settings))
		{
		form_xerr(ERROR, "WINFRAME.SLB");
		return(ERROR);
		}

	h_inw = settings->h_inw - 1;
	global_init2();
	return(E_OK);
}


/*****************************************************************
*
* Clean up library.
* We can not do an appl_exit() as we have no ap_id. 
* rsrc_free() on the other hand would be permitted, 
* as the RSC structures lie in the global field.
*
*****************************************************************/

extern void cdecl slb_exit( void )
{

	/* Remove AES functions again */
	/* -------------------------- */

	sys_set_winframe_manager(&new_wfh, &old_wfh, NULL);

	rsrc_free();
}


/*****************************************************************
*
* Open library
*
*****************************************************************/

#pragma warn -par
extern LONG cdecl slb_open( PD *pd )
{
	return(E_OK);
}


/*****************************************************************
*
* Close library
*
*****************************************************************/

extern void cdecl slb_close( PD *pd )
{
}
#pragma warn .par
