/*
*
* Program for the manipulation of bit 3 in the program header.
* MagiC needs this bit, which is generally 0, to assign to 
* the program only the minimum amount of memory that is needed,
* i.e. only basepage+text+data+symbol+BSS.
* Is needed in particular for all SharedLibraries.
*
* Andreas Kromke
* 25.10.97
*
*/

#include <portab.h>
#include <tos.h>
#include <tosdefs.h>
#include <stdio.h>

/* ProgramHeader, Program header for executable files                   */
/************************************************************************/

typedef struct {
 WORD ph_branch;         /* 0x00: Must be 0x601a                          */
 LONG ph_tlen;           /* 0x02: Length of TEXT segment                  */
 LONG ph_dlen;           /* 0x06: Length of DATA segment                  */
 LONG ph_blen;           /* 0x0a: Length of BSS  segment                  */
 LONG ph_slen;           /* 0x0e: Length of the symbol table              */
 LONG ph_res1;           /* 0x12: Required by PureC                       */
 LONG ph_flags;          /* 0x16:     Bit 0: Don't clear heap             */
                         /*          Bit 1: Load into FastRAM             */
                         /*          Bit 2: Malloc from FastRAM           */
                         /*          Bit 3: Only t+d+b+s (MagiC 5.20)     */
                         /*          Bit 4,5,6,7: Memory protection (MiNT)*/
                         /*          Bit 8: Unused                        */
                         /*          Bit 9: Unused                        */
                         /*          Bit 10: Unused                       */
                         /*          Bit 11: SharedText (MiNT)            */
                         /*          Bit 12: Unused                       */
                         /*          Bit 13: Unused                       */
                         /*          Bit 14: Unused                       */
                         /*          Bit 15: Unused                       */
                         /*          Bits 31..28: TPA size                */
                         /*           (times 128k + 128k: Min. heap size) */
 WORD ph_reloflag;       /* 0x1a: Non-zero => do not relocate             */
} PH;



WORD main( WORD argc, char *argv[] )
{
     PH ph;
     WORD ret = 0;
     LONG err;
     WORD f;

     for     (argc--,argv++; argc; argc--,argv++)
          {
          Cconws("File: ");
          Cconws(*argv);
          err = Fopen(*argv, RMODE_RW);     /* Open for reading + writing */
          f = (WORD) err;                   /* File handle                */
          err = Fread(f, sizeof(PH), &ph);
          if     ((err != sizeof(PH)) || (ph.ph_branch != 0x601a))
               {
               err = EPLFMT;
               goto nextone;
               }
          Fseek(0L, f, 0);                  /* File pointer to the start  */
          ph.ph_flags |= 8;                 /* Set bit 3                  */
          err = Fwrite(f, sizeof(PH), &ph);

      nextone:
          if     (f > 0)
               Fclose(f);
          if     (err < 0)
               {
               printf(" => Error %ld", err);
               ret = (WORD) err;
               }
          Cconws("\r\n");
          }
     return(ret);
}