
#define	NVDI_COOKIE		0x4E564449L /* 'NVDI' */

#define	NVDI_VERSION	0x0503

#define	VQ_EXTENDED		1

#define	CSPACE_RGB		1

#define	CBITMAP_MAGIC	'cbtm'

/*----------------------------------------------------------------------------------------*/
/* Structures																			*/
/*----------------------------------------------------------------------------------------*/

typedef struct _gcbitmap {	/* Public bitmap description (with version header) */
	int32	magic;		/* Structure identifier 'cbtm' */
	int32	length;		/* Structure length */
	int32	format;		/* Structure format (0) */
	int32	reserved;	/* Reserved (0) */

	uint8	*addr;		/* Bitmap address */
	int32	width;		/* Width of a line in bytes */
	int32	bits;		/* Bit depth */
	uint32	px_format;	/* Pixel format */

	int32	xmin;		/* minimum discrete x-coordinate of the bitmap */
	int32	ymin;		/* minimum discrete y-coordinate of the bitmap */
	int32	xmax;		/* maximum discrete x-coordinate of the bitmap + 1 */
	int32	ymax;		/* maximum discrete y-coordinate of the bitmap + 1 */

	uint8	*ctab;		/* Reference to the color table or 0L */
	uint8	*itab;		/* Reference to the inverse color table or 0L */
	int32	reserved0;	/* Reserved (0) */
	int32	reserved1;	/* Reserved (0) */
} GCBITMAP;


/*----------------------------------------------------------------------------------------*/
/* Constants for pixel formats															*/
/*----------------------------------------------------------------------------------------*/
#define	PX_1COMP	0x01000000L	/* Pixel consists of one used component: color index */
#define	PX_3COMP	0x03000000L	/* Pixel consists of three components used, e.g. RGB */
#define	PX_4COMP	0x04000000L	/* Pixel consists of four components used, e.g. CMYK */

#define	PX_REVERSED	0x00800000L	/* Pixel is output in reverse byte order */
#define	PX_xFIRST	0x00400000L	/* Unused bits precede the used bits (viewed in Motorola format) */
#define	PX_kFIRST	0x00200000L	/* K is in front of CMY (viewed in Motorola format) */
#define	PX_aFIRST	0x00100000L	/* Alpha channels are in front of the color bits (viewed in Motorola format) */

#define	PX_PACKED	0x00020000L	/* Bits are stored consecutively */
#define	PX_PLANES	0x00010000L	/* Bits are distributed over several levels (order: 0, 1, ..., n) */
#define	PX_IPLANES	0x00000000L	/* Bits are distributed over several words (order: 0, 1, ..., n) */

#define	PX_USES1	0x00000100L	/* 1 bit of the pixel is used */
#define	PX_USES2	0x00000200L	/* 2 bits of the pixel are used */
#define	PX_USES3	0x00000300L	/* 3 bits of the pixel are used */
#define	PX_USES4	0x00000400L	/* 4 bits of the pixel are used */
#define	PX_USES8	0x00000800L	/* 8 bits of the pixel are used */
#define	PX_USES15	0x00000f00L	/* 15 bits of the pixel are used */
#define	PX_USES16	0x00001000L	/* 16 bits of the pixel are used */
#define	PX_USES24	0x00001800L	/* 24 bits of the pixel are used */
#define	PX_USES32	0x00002000L	/* 32 bits of the pixel are used */
#define	PX_USES48	0x00003000L	/* 48 bits of the pixel are used */

#define	PX_1BIT		0x00000001L	/* Pixel consists of 1 bit */
#define	PX_2BIT		0x00000002L	/* Pixel consists of 2 bits */
#define	PX_3BIT		0x00000003L	/* Pixel consists of 2 bits */
#define	PX_4BIT		0x00000004L	/* Pixel consists of 2 bits */
#define	PX_8BIT		0x00000008L	/* Pixel consists of 2 bits */
#define	PX_16BIT	0x00000010L	/* Pixel consists of 2 bits */
#define	PX_24BIT	0x00000018L	/* Pixel consists of 2 bits */
#define	PX_32BIT	0x00000020L	/* Pixel consists of 2 bits */
#define	PX_48BIT	0x00000030L	/* Pixel consists of 2 bits */

#define	PX_CMPNTS	0x0f000000L	/* Mask for number of pixel components */
#define	PX_FLAGS	0x00f00000L	/* Mask for various flags */
#define	PX_PACKING	0x00030000L	/* Mask for pixel format */
#define	PX_USED		0x00003f00L	/* Mask for the number of bits used */
#define	PX_BITS		0x0000003fL	/* Mask for the number of bits per pixel */

/*----------------------------------------------------------------------------------------*/
/* Pixel formats for ATARI graphics														*/
/*----------------------------------------------------------------------------------------*/
#define	PX_ATARI1	( PX_PACKED + PX_1COMP + PX_USES1 + PX_1BIT )
#define	PX_ATARI2	( PX_IPLANES + PX_1COMP + PX_USES2 + PX_2BIT )
#define	PX_ATARI4	( PX_IPLANES + PX_1COMP + PX_USES4 + PX_4BIT )
#define	PX_ATARI8	( PX_IPLANES + PX_1COMP + PX_USES8 + PX_8BIT )
#define	PX_FALCON15	( PX_PACKED + PX_3COMP + PX_USES16 + PX_16BIT )

/*----------------------------------------------------------------------------------------*/
/* Pixel formats for Macintosh															*/
/*----------------------------------------------------------------------------------------*/
#define	PX_MAC1		( PX_PACKED + PX_1COMP + PX_USES1 + PX_1BIT )
#define	PX_MAC4		( PX_PACKED + PX_1COMP + PX_USES4 + PX_4BIT )
#define	PX_MAC8		( PX_PACKED + PX_1COMP + PX_USES8 + PX_8BIT )
#define	PX_MAC15	( PX_xFIRST + PX_PACKED + PX_3COMP + PX_USES15 + PX_16BIT )
#define	PX_MAC32	( PX_xFIRST + PX_PACKED + PX_3COMP + PX_USES24 + PX_32BIT )

/*----------------------------------------------------------------------------------------*/
/* Pixel formats for graphics cards														*/
/*----------------------------------------------------------------------------------------*/
#define	PX_VGA1		( PX_PACKED + PX_1COMP + PX_USES1 + PX_1BIT )
#define	PX_VGA4		( PX_PLANES + PX_1COMP + PX_USES4 + PX_4BIT )
#define	PX_VGA8		( PX_PACKED + PX_1COMP + PX_USES8 + PX_8BIT )
#define	PX_VGA15	( PX_REVERSED + PX_xFIRST + PX_PACKED + PX_3COMP + PX_USES15 + PX_16BIT )
#define	PX_VGA16	( PX_REVERSED + PX_PACKED + PX_3COMP + PX_USES16 + PX_16BIT )
#define	PX_VGA24	( PX_REVERSED + PX_PACKED + PX_3COMP + PX_USES24 + PX_24BIT )
#define	PX_VGA32	( PX_REVERSED + PX_xFIRST + PX_PACKED + PX_3COMP + PX_USES24 + PX_32BIT )

#define	PX_MATRIX16	( PX_PACKED + PX_3COMP + PX_USES16 + PX_16BIT )

#define	PX_NOVA32	( PX_PACKED + PX_3COMP + PX_USES24 + PX_32BIT )

/*----------------------------------------------------------------------------------------*/
/* Pixel formats for printers															*/
/*----------------------------------------------------------------------------------------*/
#define	PX_PRN1		( PX_PACKED + PX_1COMP + PX_USES1 + PX_1BIT )
#define	PX_PRN8		( PX_PACKED + PX_1COMP + PX_USES8 + PX_8BIT )
#define	PX_PRN32	( PX_xFIRST + PX_PACKED + PX_3COMP + PX_USES24 + PX_32BIT )

/*----------------------------------------------------------------------------------------*/
/* Preferred (fast) pixel formats for bitmaps 											*/
/*----------------------------------------------------------------------------------------*/

#define	PX_PREF1	( PX_PACKED + PX_1COMP + PX_USES1 + PX_1BIT )
#define	PX_PREF2	( PX_PACKED + PX_1COMP + PX_USES2 + PX_2BIT )
#define	PX_PREF4	( PX_PACKED + PX_1COMP + PX_USES4 + PX_4BIT )
#define	PX_PREF8	( PX_PACKED + PX_1COMP + PX_USES8 + PX_8BIT )
#define	PX_PREF15	( PX_xFIRST + PX_PACKED + PX_3COMP + PX_USES15 + PX_16BIT )
#define	PX_PREF32	( PX_xFIRST + PX_PACKED + PX_3COMP + PX_USES24 + PX_32BIT )

#define PX_PREF24	( PX_PACKED + PX_3COMP + PX_USES24 + PX_24BIT )	/* lp */
#define	PX_ATARI16	( PX_PACKED + PX_3COMP + PX_USES16 + PX_16BIT )	/* lp */

/*----------------------------------------------------------------------------------------*/
/* Transfer modes for bitmaps															*/
/*----------------------------------------------------------------------------------------*/

/* Mode constants */
#define	T_NOT				4	/* Constant for inversion in logical transfer modes */
#define	T_COLORIZE			16	/* Constant for coloring */

#define	T_LOGIC_MODE		0
#define	T_DRAW_MODE			32
#define	T_ARITH_MODE		64	/* Constants for arithmetic transfer modes */
#define	T_DITHER_MODE		128	/* Constant for dithering */

/* Logical transfer modes */
#define	T_LOGIC_COPY			T_LOGIC_MODE+0
#define	T_LOGIC_OR				T_LOGIC_MODE+1
#define	T_LOGIC_XOR				T_LOGIC_MODE+2
#define	T_LOGIC_AND				T_LOGIC_MODE+3
#define	T_LOGIC_NOT_COPY		T_LOGIC_MODE+4
#define	T_LOGIC_NOT_OR			T_LOGIC_MODE+5
#define	T_LOGIC_NOT_XOR			T_LOGIC_MODE+6
#define	T_LOGIC_NOT_AND			T_LOGIC_MODE+7

/* Drawing modes */
#define	T_REPLACE				T_DRAW_MODE+0
#define	T_TRANSPARENT			T_DRAW_MODE+1
#define	T_HILITE				T_DRAW_MODE+2
#define	T_REVERS_TRANSPARENT	T_DRAW_MODE+3

/* Arithmetische Transfermodi */
#define	T_BLEND					T_ARITH_MODE+0
#define	T_ADD					T_ARITH_MODE+1
#define	T_ADD_OVER				T_ARITH_MODE+2
#define	T_SUB					T_ARITH_MODE+3
#define	T_MAX					T_ARITH_MODE+5
#define	T_SUB_OVER				T_ARITH_MODE+6
#define	T_MIN					T_ARITH_MODE+7


/* eof */
